/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemCyberlimb
extends ItemCyberware
implements ICyberware.ISidedLimb {
    private Set<Integer> didFall = new HashSet<Integer>();

    public ItemCyberlimb(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super(name, slots, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEssential(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        ICyberware ware = CyberwareAPI.getCyberware(other);
        if (ware instanceof ICyberware.ISidedLimb) {
            return ware.isEssential(other) && ((ICyberware.ISidedLimb)((Object)ware)).getSide(other) == this.getSide(stack);
        }
        return false;
    }

    @Override
    public ICyberware.ISidedLimb.EnumSide getSide(ItemStack stack) {
        return stack.func_77952_i() % 2 == 0 ? ICyberware.ISidedLimb.EnumSide.LEFT : ICyberware.ISidedLimb.EnumSide.RIGHT;
    }

    public static boolean isPowered(ItemStack stack) {
        NBTTagCompound data = CyberwareAPI.getCyberwareNBT(stack);
        if (!data.func_74764_b("active")) {
            data.func_74757_a("active", true);
        }
        return data.func_74767_n("active");
    }

    @SubscribeEvent
    public void handleFallDamage(LivingAttackEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (e.field_70170_p.field_72995_K && (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 2)) || CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 3))) && event.getSource() == DamageSource.field_76379_h && !this.didFall.contains(e.func_145782_y())) {
            this.didFall.add(e.func_145782_y());
        }
    }

    @SubscribeEvent
    public void handleSound(PlaySoundAtEntityEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EntityPlayer && event.getSound() == SoundEvents.field_187800_eb && e.field_70170_p.field_72995_K && this.didFall.contains(e.func_145782_y())) {
            int numLegs = 0;
            if (CyberwareAPI.isCyberwareInstalled(e, new ItemStack((Item)this, 1, 2))) {
                ++numLegs;
            }
            if (CyberwareAPI.isCyberwareInstalled(e, new ItemStack((Item)this, 1, 3))) {
                ++numLegs;
            }
            if (numLegs > 0) {
                event.setSound(SoundEvents.field_187602_cF);
                event.setPitch(event.getPitch() + 1.0f);
                this.didFall.remove(e.func_145782_y());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void power(CyberwareUpdateEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        for (int i = 0; i < 4; ++i) {
            ItemStack test = new ItemStack((Item)this, 1, i);
            ItemStack installed = CyberwareAPI.getCyberware((Entity)e, test);
            if (e.field_70173_aa % 20 != 0 || installed.func_190926_b()) continue;
            boolean used = CyberwareAPI.getCapability((Entity)e).usePower(installed, this.getPowerConsumption(installed));
            CyberwareAPI.getCyberwareNBT(installed).func_74757_a("active", used);
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return 10;
    }
}

