/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.BlockBeaconLarge;
import flaxbeard.cyberware.common.item.ItemBrainUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityBeacon
extends TileEntity
implements ITickable {
    private static List<Integer> tiers = new ArrayList<Integer>();
    private static Map<Integer, Map<Integer, Map<BlockPos, Integer>>> beaconPos = new HashMap<Integer, Map<Integer, Map<BlockPos, Integer>>>();
    public boolean initialized = false;
    private boolean wasWorking = false;
    private int count = 0;
    private static int TIER = 2;

    public static Map<Integer, Map<BlockPos, Integer>> posForTier(int tier) {
        Map<Integer, Map<BlockPos, Integer>> map = beaconPos.get(tier);
        if (map == null) {
            beaconPos.put(tier, new HashMap());
            map = beaconPos.get(tier);
            tiers.add(tier);
            Collections.sort(tiers);
            Collections.reverse(tiers);
        }
        return map;
    }

    public void func_73660_a() {
        boolean working;
        boolean bl = working = !this.field_145850_b.func_175640_z(this.field_174879_c);
        if (!this.wasWorking && working) {
            this.enable();
        }
        if (this.wasWorking && !working) {
            this.disable();
        }
        this.wasWorking = working;
        if (this.field_145850_b.field_72995_K && working) {
            IBlockState state;
            this.count = (this.count + 1) % 20;
            if (this.count == 0 && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == CyberwareContent.radio) {
                boolean ns = state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.NORTH || state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.SOUTH;
                boolean backwards = state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.SOUTH || state.func_177229_b((IProperty)BlockBeaconLarge.FACING) == EnumFacing.EAST;
                float dist = 0.2f;
                float speedMod = 0.08f;
                int degrees = 45;
                for (int i = 0; i < 5; ++i) {
                    float sin = (float)Math.sin(Math.toRadians(degrees));
                    float cos = (float)Math.cos(Math.toRadians(degrees));
                    float xOffset = dist * sin;
                    float yOffset = 0.2f + dist * cos;
                    float xSpeed = speedMod * sin;
                    float ySpeed = speedMod * cos;
                    float backOffsetX = backwards ^ ns ? -0.3f : 0.3f;
                    float backOffsetZ = backwards ? 0.4f : -0.4f;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f + (ns ? xOffset + backOffsetX : backOffsetZ)), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + yOffset), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (ns ? backOffsetZ : xOffset + backOffsetX)), ns ? (double)xSpeed : 0.0, (double)ySpeed, ns ? 0.0 : (double)xSpeed, new int[]{255, 255, 255});
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f + (ns ? -xOffset + backOffsetX : backOffsetZ)), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + yOffset), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (ns ? backOffsetZ : -xOffset + backOffsetX)), ns ? (double)(-xSpeed) : 0.0, (double)ySpeed, ns ? 0.0 : (double)(-xSpeed), new int[]{255, 255, 255});
                    degrees += 18;
                }
            }
        }
    }

    private void disable() {
        Map<BlockPos, Integer> map = TileEntityBeacon.posForTier(TIER).get(this.field_145850_b.field_73011_w.getDimension());
        if (map == null) {
            TileEntityBeacon.posForTier(TIER).put(this.field_145850_b.field_73011_w.getDimension(), new HashMap());
            map = TileEntityBeacon.posForTier(TIER).get(this.field_145850_b.field_73011_w.getDimension());
        }
        if (map.containsKey(this.func_174877_v())) {
            map.remove(this.func_174877_v());
        }
    }

    private void enable() {
        Map<BlockPos, Integer> map = TileEntityBeacon.posForTier(TIER).get(this.field_145850_b.field_73011_w.getDimension());
        if (map == null) {
            TileEntityBeacon.posForTier(TIER).put(this.field_145850_b.field_73011_w.getDimension(), new HashMap());
            map = TileEntityBeacon.posForTier(TIER).get(this.field_145850_b.field_73011_w.getDimension());
        }
        if (!map.containsKey(this.func_174877_v())) {
            map.put(this.func_174877_v(), 64);
        }
    }

    public void func_145843_s() {
        this.disable();
        super.func_145843_s();
    }

    public static int isInRange(World world, double posX, double posY, double posZ) {
        for (int tier : tiers) {
            Map<BlockPos, Integer> map = TileEntityBeacon.posForTier(tier).get(world.field_73011_w.getDimension());
            if (map == null) {
                TileEntityBeacon.posForTier(tier).put(world.field_73011_w.getDimension(), new HashMap());
                map = TileEntityBeacon.posForTier(tier).get(world.field_73011_w.getDimension());
            }
            for (Map.Entry<BlockPos, Integer> entry : map.entrySet()) {
                float distance = (float)Math.sqrt((posX - (double)entry.getKey().func_177958_n()) * (posX - (double)entry.getKey().func_177958_n()) + (posZ - (double)entry.getKey().func_177952_p()) * (posZ - (double)entry.getKey().func_177952_p()));
                if (!(distance < (float)entry.getValue().intValue())) continue;
                return tier;
            }
        }
        List entities = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(posX - 32.0, 0.0, posZ - 32.0, posX + 32.0, 255.0, posZ + 32.0));
        ItemStack test = new ItemStack((Item)CyberwareContent.brainUpgrades, 1, 5);
        for (EntityLivingBase entity : entities) {
            if (!CyberwareAPI.hasCapability((Entity)entity) || !CyberwareAPI.isCyberwareInstalled((Entity)entity, test) || !ItemBrainUpgrade.isRadioWorking(entity) || !EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)entity, test))) continue;
            return 1;
        }
        return -1;
    }
}

