/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.item.ItemBlockCyberware;
import flaxbeard.cyberware.common.block.tile.TileEntityBeaconPost;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockBeaconPost
extends BlockContainer {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyInteger TRANSFORMED = PropertyInteger.func_177719_a((String)"transformed", (int)0, (int)2);
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.625, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.625, 0.625, 1.0, 1.0);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 0.375, 1.0, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.375);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625, 0.0, 0.375, 1.0, 1.0, 0.625);

    public BlockBeaconPost() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        String name = "radio_post";
        this.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockCyberware ib = new ItemBlockCyberware((Block)this, "cyberware.tooltip.beacon_post.0", "cyberware.tooltip.beacon_post.1", "cyberware.tooltip.beacon_post.2");
        ib.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)ib);
        this.func_149663_c("cyberware." + name);
        this.func_149647_a(Cyberware.creativeTab);
        CyberwareContent.blocks.add((Block)this);
        GameRegistry.registerTileEntity(TileEntityBeaconPost.class, (String)("cyberware:" + name));
        GameRegistry.registerTileEntity(TileEntityBeaconPost.TileEntityBeaconPostMaster.class, (String)("cyberware:" + name + "_master"));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TRANSFORMED, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos complete = this.complete(worldIn, pos);
        if (complete != null) {
            // empty if block
        }
    }

    private BlockPos complete(World world, BlockPos pos) {
        for (int y = -9; y <= 0; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos start = pos.func_177982_a(x, y, z);
                    BlockPos result = this.complete(world, pos, start);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private BlockPos complete(World world, BlockPos pos, BlockPos start) {
        BlockPos newPos;
        Object state;
        int z;
        int x;
        int y;
        for (y = 0; y <= 9; ++y) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    Block block;
                    if (y > 3 && (x != 0 || z != 0) || (block = (state = world.func_180495_p(newPos = start.func_177982_a(x, y, z))).func_177230_c()) == this && (Integer)state.func_177229_b((IProperty)TRANSFORMED) == 0) continue;
                    return null;
                }
            }
        }
        for (y = 0; y <= 9; ++y) {
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (y > 3 && (x != 0 || z != 0)) continue;
                    newPos = start.func_177982_a(x, y, z);
                    if (newPos.equals((Object)start)) {
                        world.func_180501_a(newPos, world.func_180495_p(newPos).func_177226_a((IProperty)TRANSFORMED, (Comparable)Integer.valueOf(2)), 2);
                        state = (TileEntityBeaconPost)world.func_175625_s(newPos);
                        continue;
                    }
                    world.func_180501_a(newPos, world.func_180495_p(newPos).func_177226_a((IProperty)TRANSFORMED, (Comparable)Integer.valueOf(1)), 2);
                    TileEntityBeaconPost post = (TileEntityBeaconPost)world.func_175625_s(newPos);
                    post.setMasterLoc(start);
                }
            }
        }
        return start;
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        if ((Integer)(state = state.func_185899_b((IBlockAccess)worldIn, pos)).func_177229_b((IProperty)TRANSFORMED) > 0) {
            BlockBeaconPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
            return;
        }
        BlockBeaconPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PILLAR_AABB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockBeaconPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockBeaconPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockBeaconPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockBeaconPost.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[BlockBeaconPost.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block == Blocks.field_180401_cv ? false : (!(block instanceof BlockBeaconPost && block.func_149688_o(iblockstate) == this.field_149764_J || block instanceof BlockFenceGate) ? (block.func_149688_o(iblockstate).func_76218_k() && iblockstate.func_185917_h() ? block.func_149688_o(iblockstate) != Material.field_151572_C : false) : true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return worldIn.field_72995_K ? true : ItemLead.func_180618_a((EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TRANSFORMED);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TRANSFORMED, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e())));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, TRANSFORMED});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TRANSFORMED) > 0 ? EnumBlockRenderType.INVISIBLE : EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 2: {
                return new TileEntityBeaconPost.TileEntityBeaconPostMaster();
            }
            case 1: {
                return new TileEntityBeaconPost();
            }
        }
        return null;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (world != null && (Integer)state.func_177229_b((IProperty)TRANSFORMED) > 0 && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityBeaconPost) {
            TileEntityBeaconPost post2;
            TileEntity masterTe;
            TileEntityBeaconPost post = (TileEntityBeaconPost)te;
            if ((Integer)state.func_177229_b((IProperty)TRANSFORMED) == 2) {
                post.destruct();
            } else if (post.master != null && !post.master.equals((Object)pos) && !post.destructing && (masterTe = world.func_175625_s(post.master)) != null && masterTe instanceof TileEntityBeaconPost && (post2 = (TileEntityBeaconPost)masterTe) instanceof TileEntityBeaconPost.TileEntityBeaconPostMaster && !post2.destructing) {
                post2.destruct();
            }
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return (Integer)state.func_177229_b((IProperty)TRANSFORMED) > 0;
    }
}

