/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui.hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.hud.INotification;
import flaxbeard.cyberware.api.hud.NotificationInstance;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.block.tile.TileEntityBeacon;
import flaxbeard.cyberware.common.handler.HudHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class NotificationDisplay
extends HudElementBase {
    private static Iterable<ItemStack> inv;
    private static int radioRange;
    private static boolean lightArmor;
    private static final NotificationInstance[] examples;

    public NotificationDisplay() {
        super("cyberware:notification");
        this.setDefaultX(5);
        this.setDefaultY(-15);
        this.setWidth(90);
        this.setHeight(38);
        this.setDefaultVerticalAnchor(IHudElement.EnumAnchorVertical.BOTTOM);
    }

    @Override
    public void renderElement(int x, int y, EntityPlayer p, ScaledResolution resolution, boolean hudjackAvailable, boolean isConfigOpen, float partialTicks) {
        if (!this.isHidden() && hudjackAvailable) {
            int temp;
            boolean flipVert = this.getVerticalAnchor() == IHudElement.EnumAnchorVertical.TOP;
            boolean flipHoriz = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
            float currTime = (float)p.field_70173_aa + partialTicks;
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)p);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            Iterable currInv = p.func_184193_aE();
            if (currInv != inv) {
                inv = currInv;
                temp = lightArmor ? 1 : 0;
                lightArmor = this.updateLightArmor();
                if (lightArmor != temp) {
                    HudHandler.addNotification(new NotificationInstance(currTime, new NotificationArmor(lightArmor)));
                }
            }
            temp = radioRange;
            radioRange = TileEntityBeacon.isInRange(p.field_70170_p, p.field_70165_t, p.field_70163_u, p.field_70161_v);
            if (radioRange != temp) {
                HudHandler.addNotification(new NotificationInstance(currTime, new NotificationRadio(radioRange)));
            }
            if (isConfigOpen) {
                for (int i = 0; i < examples.length; ++i) {
                    NotificationInstance ni = examples[i];
                    INotification notification = ni.getNotification();
                    double pct = 0.0;
                    if (i == 0) {
                        pct = (float)p.field_70173_aa % 40.0f / 40.0f;
                    }
                    float move = (float)(20.0 * Math.sin(pct * 1.5707963267948966));
                    GL11.glPushMatrix();
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(flipVert ? -move : move), (float)0.0f);
                    int index = examples.length - 1 - i;
                    int xPos = flipHoriz ? x + this.getWidth() - (index + 1) * 18 : x + index * 18;
                    notification.render(xPos, y + (flipVert ? 20 : 0));
                    GL11.glPopMatrix();
                }
            } else {
                ArrayList<NotificationInstance> nTR = new ArrayList<NotificationInstance>();
                for (int i = 0; i < HudHandler.notifications.size(); ++i) {
                    NotificationInstance ni = (NotificationInstance)HudHandler.notifications.get(i);
                    INotification notification = ni.getNotification();
                    if (currTime - ni.getCreatedTime() < (float)(notification.getDuration() + 25)) {
                        double pct = Math.max(0.0f, (currTime - ni.getCreatedTime() - (float)notification.getDuration()) / 30.0f);
                        float move = (float)(20.0 * Math.sin(pct * 1.5707963267948966));
                        GL11.glPushMatrix();
                        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glTranslatef((float)0.0f, (float)(flipVert ? -move : move), (float)0.0f);
                        int index = HudHandler.notifications.size() - 1 - i;
                        int xPos = flipHoriz ? x + this.getWidth() - (index + 1) * 18 : x + index * 18;
                        notification.render(xPos, y + (flipVert ? 20 : 0));
                        GL11.glPopMatrix();
                        continue;
                    }
                    nTR.add(ni);
                }
                for (NotificationInstance ni : nTR) {
                    HudHandler.notifications.remove(ni);
                }
            }
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean updateLightArmor() {
        for (ItemStack stack : inv) {
            if (!(!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmor ? ((ItemArmor)stack.func_77973_b()).func_82812_d().func_78044_b(EntityEquipmentSlot.CHEST) > 4 : !stack.func_190926_b() && stack.func_77973_b() instanceof ISpecialArmor && ((ISpecialArmor)stack.func_77973_b()).getProperties((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, (ItemStack)stack, (DamageSource)DamageSource.field_76367_g, (double)1.0, (int)1).AbsorbRatio * 25.0 > 4.0)) continue;
            return false;
        }
        return true;
    }

    static {
        radioRange = -1;
        lightArmor = false;
        examples = new NotificationInstance[]{new NotificationInstance(0.0f, new NotificationArmor(true)), new NotificationInstance(0.0f, new NotificationArmor(false)), new NotificationInstance(0.0f, new NotificationArmor(true)), new NotificationInstance(0.0f, new NotificationArmor(false))};
    }

    @SideOnly(value=Side.CLIENT)
    private static class NotificationRadio
    implements INotification {
        private int tier;

        private NotificationRadio(int tier) {
            this.tier = tier;
        }

        @Override
        public void render(int x, int y) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            if (this.tier > 0) {
                GlStateManager.func_179094_E();
                float[] color = CyberwareAPI.getHUDColor();
                GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
                ClientUtils.drawTexturedModalRect(x, y + 1, 13, 39, 15, 14);
                GlStateManager.func_179121_F();
                String v = this.tier == 1 ? I18n.func_135052_a((String)"cyberware.gui.radio_internal", (Object[])new Object[0]) : Integer.toString(this.tier - 1);
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                fr.func_175063_a(v, (float)(x + 15 - fr.func_78256_a(v)), (float)(y + 9), 0xFFFFFF);
            } else {
                float[] color = CyberwareAPI.getHUDColor();
                GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
                ClientUtils.drawTexturedModalRect(x, y + 1, 28, 39, 15, 14);
            }
        }

        @Override
        public int getDuration() {
            return 40;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class NotificationArmor
    implements INotification {
        private boolean light;

        private NotificationArmor(boolean light) {
            this.light = light;
        }

        @Override
        public void render(int x, int y) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            GL11.glPushMatrix();
            float[] color = CyberwareAPI.getHUDColor();
            GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
            ClientUtils.drawTexturedModalRect(x, y + 1, 0, 25, 15, 14);
            GL11.glPopMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (this.light) {
                ClientUtils.drawTexturedModalRect(x + 9, y + 1 + 7, 15, 25, 7, 9);
            } else {
                ClientUtils.drawTexturedModalRect(x + 8, y + 1 + 7, 22, 25, 8, 9);
            }
        }

        @Override
        public int getDuration() {
            return 20;
        }
    }
}

