/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui;

import com.google.common.collect.ImmutableSet;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.HotkeyHelper;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.client.KeyBinds;
import flaxbeard.cyberware.client.gui.GuiHudConfiguration;
import flaxbeard.cyberware.common.handler.HudHandler;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.SyncHotkeyPacket;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiCyberwareMenu
extends GuiScreen {
    Minecraft field_146297_k;
    boolean movedWheel = false;
    int selectedPart = -1;
    int lastMousedOverPart = -1;
    private boolean editing = false;
    private boolean color = false;
    private float radiusBase = 100.0f;
    private float innerRadiusBase = 40.0f;
    private boolean close = false;
    private GuiTextField hex;
    private float[][] colorOptions = new float[][]{{0.0f, 1.0f, 1.0f}, {0.29803923f, 1.0f, 0.0f}, {1.0f, 0.84705883f, 0.0f}, {1.0f, 0.7137255f, 0.25882354f}, {0.83137256f, 0.46666667f, 1.0f}, {1.0f, 0.0f, 0.0f}, {0.23921569f, 0.68235296f, 1.0f}, {1.0f, 0.34901962f, 0.9098039f}, {0.10980392f, 1.0f, 0.6117647f}, {1.0f, 1.0f, 1.0f}};
    private static final int ROW_SIZE = 5;

    public GuiCyberwareMenu() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int numRows = (this.colorOptions.length + 5 - 1) / 5;
        this.hex = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 70, this.field_146295_m / 2 - 100 + 30 * numRows, 140, 20);
        String s = Integer.toHexString(CyberwareAPI.getHUDColorHex()).toUpperCase();
        while (s.length() < 6) {
            s = "0" + s;
        }
        this.hex.func_146180_a(s);
        this.hex.func_146184_c(false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int d = Mouse.getDWheel();
        if (!(this.movedWheel || d == 0 || this.editing || this.color)) {
            this.movedWheel = true;
            if (this.selectedPart == -1 && d > 0) {
                d = 0;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.field_146294_l / 2.0f + this.radiusBase), (float)((float)this.field_146295_m / 2.0f - this.radiusBase), (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        float[] mainColor = CyberwareAPI.getHUDColor();
        GL11.glColor3f((float)mainColor[0], (float)mainColor[1], (float)mainColor[2]);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        ClientUtils.drawTexturedModalRect(1, 0, 81, 10, 7, 8);
        ClientUtils.drawTexturedModalRect(0, 9, 88, 10, 8, 8);
        ClientUtils.drawTexturedModalRect(0, 18, 97, 10, 8, 8);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        if (this.color) {
            this.hex.func_146194_f();
            for (int n = 0; n < this.colorOptions.length; ++n) {
                float[] colorOption = this.colorOptions[n];
                GL11.glColor3f((float)colorOption[0], (float)colorOption[1], (float)colorOption[2]);
                int row = n / 5;
                int col = n % 5;
                int xOffset = -10 + (col - 2) * 30;
                int yOffset = -100 + 30 * row;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
                ClientUtils.drawTexturedModalRect(this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset, 0, 236, 20, 20);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int i;
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179103_j((int)7425);
            int centerX = this.field_146294_l / 2;
            int centerY = this.field_146295_m / 2;
            this.field_146297_k = Minecraft.func_71410_x();
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)this.field_146297_k.field_71439_g);
            int piePieces = data.getNumActiveItems();
            if (this.movedWheel && !this.editing) {
                this.selectedPart -= Integer.signum(d);
                while (this.selectedPart < 0) {
                    this.selectedPart += piePieces;
                }
                this.selectedPart %= piePieces;
            }
            float degreesPerPiece = 360.0f / (float)piePieces;
            int maxStepsPerTrial = 5;
            float mouseDist = (float)Math.sqrt((centerX - mouseX) * (centerX - mouseX) + (centerY - mouseY) * (centerY - mouseY));
            float mouseAngle = (float)(Math.atan2(mouseY - centerY, mouseX - centerX) * 180.0 / Math.PI + 360.0) % 360.0f;
            for (int piece = 0; piece < piePieces; ++piece) {
                float rotation = (degreesPerPiece * (float)piece + 270.0f) % 360.0f;
                if (!this.editing) {
                    if (mouseDist > this.innerRadiusBase) {
                        this.movedWheel = false;
                        if (piePieces == 1 || mouseAngle > rotation && mouseAngle < rotation + degreesPerPiece && this.lastMousedOverPart != piece) {
                            this.lastMousedOverPart = piece;
                            this.selectedPart = piece;
                        }
                    } else {
                        this.lastMousedOverPart = -1;
                        if (!this.movedWheel) {
                            this.selectedPart = -1;
                        }
                    }
                }
                boolean selected = piece == this.selectedPart;
                for (int deg = (int)(degreesPerPiece + 0.5f); deg > 0; deg -= maxStepsPerTrial) {
                    float radius = this.radiusBase + (float)(selected ? 10 : 0);
                    float innerRadius = this.innerRadiusBase + (float)(selected ? 10 : 0);
                    int stepsPerTrial = Math.min(maxStepsPerTrial, deg);
                    GL11.glBegin((int)6);
                    float alpha = selected ? 0.8f : 0.5f;
                    ItemStack stack = data.getActiveItems().get(piece);
                    float[] itemColor = ((IMenuItem)stack.func_77973_b()).getColor(stack);
                    float[] color = itemColor == null ? mainColor : itemColor;
                    GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)alpha);
                    double radians = (double)((rotation + (float)deg) / 180.0f) * Math.PI;
                    float xS = (float)centerX + (float)Math.cos(radians) * innerRadius;
                    float yS = (float)centerY + (float)Math.sin(radians) * innerRadius;
                    GL11.glVertex2f((float)xS, (float)yS);
                    for (i = 0; i <= stepsPerTrial; ++i) {
                        radians = (double)((rotation + (float)deg - (float)i) / 180.0f) * Math.PI;
                        float x = (float)centerX + (float)Math.cos(radians) * radius;
                        float y = (float)centerY + (float)Math.sin(radians) * radius;
                        GL11.glVertex2f((float)x, (float)y);
                    }
                    radians = (double)((rotation + (float)deg - (float)stepsPerTrial) / 180.0f) * Math.PI;
                    xS = (float)centerX + (float)Math.cos(radians) * innerRadius;
                    yS = (float)centerY + (float)Math.sin(radians) * innerRadius;
                    GL11.glVertex2f((float)xS, (float)yS);
                    GL11.glEnd();
                }
            }
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
            float scale = (float)piePieces > 8.0f ? ((float)piePieces > 16.0f ? 0.5f : 1.0f) : 2.0f;
            boolean unicode = this.field_146289_q.func_82883_a();
            if (scale < 1.0f) {
                this.field_146289_q.func_78264_a(true);
            }
            float itemRadiusBase = this.innerRadiusBase + (this.radiusBase - this.innerRadiusBase) / 2.0f;
            for (int piece = 0; piece < piePieces; ++piece) {
                String str;
                ItemStack stack = data.getActiveItems().get(piece);
                float itemRadius = piece == this.selectedPart ? itemRadiusBase + 10.0f : itemRadiusBase;
                float rotation = (degreesPerPiece * ((float)piece + 0.5f) + 270.0f) % 360.0f;
                double radians = (double)(rotation / 180.0f) * Math.PI;
                float offset = 8.0f * scale;
                int boundKey = HotkeyHelper.getHotkey(stack);
                float yOffset = boundKey == -1 ? (float)this.field_146289_q.field_78288_b / 2.0f : 0.0f;
                float xS = (float)centerX + (float)Math.cos(radians) * itemRadius;
                float yS = (float)centerY + (float)Math.sin(radians) * itemRadius;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(xS - offset), (float)(yS - offset + yOffset), (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                this.field_146296_j.func_175042_a(data.getActiveItems().get(piece), 0, 0);
                GlStateManager.func_179121_F();
                if (piece == this.selectedPart && this.editing) {
                    if (this.field_146297_k.field_71439_g.field_70173_aa / 4 % 2 == 0) {
                        GlStateManager.func_179094_E();
                        str = "__";
                        i = this.field_146289_q.func_78256_a(str);
                        GlStateManager.func_179109_b((float)(xS - (float)i / 2.0f), (float)(yS + offset), (float)0.0f);
                        this.field_146289_q.func_175063_a(str, 0.0f, 0.0f, 0xFFFFFF);
                        GlStateManager.func_179121_F();
                    }
                } else if (boundKey != -1) {
                    GlStateManager.func_179094_E();
                    str = "";
                    str = boundKey < 0 ? Mouse.getButtonName((int)(boundKey += 100)) : (boundKey > 900 ? "SHIFT + " + Keyboard.getKeyName((int)(boundKey - 900)) : Keyboard.getKeyName((int)boundKey));
                    i = this.field_146289_q.func_78256_a(str);
                    GlStateManager.func_179109_b((float)(xS - (float)i / 2.0f), (float)(yS + offset), (float)0.0f);
                    this.field_146289_q.func_175063_a(str, 0.0f, 0.0f, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                }
                GlStateManager.func_179094_E();
                str = I18n.func_135052_a((String)((IMenuItem)stack.func_77973_b()).getUnlocalizedLabel(stack), (Object[])new Object[0]);
                i = this.field_146289_q.func_78256_a(str);
                GlStateManager.func_179109_b((float)(xS - (float)i / 2.0f), (float)(yS - offset + yOffset - (float)this.field_146289_q.field_78288_b), (float)0.0f);
                this.field_146289_q.func_175063_a(str, 0.0f, 0.0f, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
            this.field_146289_q.func_78264_a(unicode);
            if (this.selectedPart >= 0) {
                GlStateManager.func_179094_E();
                String str = data.getActiveItems().get(this.selectedPart).func_82833_r();
                GlStateManager.func_179109_b((float)((float)(this.field_146294_l - this.field_146289_q.func_78256_a(str)) / 2.0f), (float)((float)this.field_146295_m / 2.0f - 30.0f - this.radiusBase), (float)0.0f);
                this.field_146289_q.func_175063_a(str, 0.0f, 0.0f, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179094_E();
        int sx = (int)((float)this.field_146294_l / 2.0f + this.radiusBase);
        int sy = (int)((float)this.field_146295_m / 2.0f - this.radiusBase);
        if (this.isPointInRegion(sx + 2, sy, 12, 16, mouseX, mouseY)) {
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"cyberware.gui.keybind.0", (Object[])new Object[0]), I18n.func_135052_a((String)"cyberware.gui.keybind.1", (Object[])new Object[0]), I18n.func_135052_a((String)"cyberware.gui.keybind.2", (Object[])new Object[0]), I18n.func_135052_a((String)"cyberware.gui.keybind.3", (Object[])new Object[0]), I18n.func_135052_a((String)"cyberware.gui.keybind.4", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
        } else if (this.isPointInRegion(sx, sy + 18, 16, 16, mouseX, mouseY)) {
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"cyberware.gui.open_hud_config", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
        } else if (this.isPointInRegion(sx, sy + 36, 16, 16, mouseX, mouseY)) {
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"cyberware.gui.open_color_change", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
        }
        GlStateManager.func_179121_F();
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return pointX >= rectX - 1 && pointX < rectX + rectWidth + 1 && pointY >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.hex.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && !this.editing) {
            int sx = (int)((float)this.field_146294_l / 2.0f + this.radiusBase);
            int sy = (int)((float)this.field_146295_m / 2.0f - this.radiusBase);
            if (!this.editing && this.isPointInRegion(sx, sy + 18, 16, 16, mouseX, mouseY)) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiHudConfiguration());
                return;
            }
            if (!this.editing && this.isPointInRegion(sx, sy + 36, 16, 16, mouseX, mouseY)) {
                this.color = !this.color;
                this.hex.func_146184_c(this.color);
                return;
            }
            if (this.color) {
                for (int n = 0; n < this.colorOptions.length; ++n) {
                    float[] colorOption = this.colorOptions[n];
                    int col = n % 5;
                    int xOffset = -10 + (col - 2) * 30;
                    int row = n / 5;
                    int yOffset = -100 + 30 * row;
                    if (!this.isPointInRegion(this.field_146294_l / 2 + xOffset, this.field_146295_m / 2 + yOffset, 20, 20, mouseX, mouseY)) continue;
                    CyberwareAPI.setHUDColor(colorOption);
                    String s = Integer.toHexString(CyberwareAPI.getHUDColorHex()).toUpperCase();
                    while (s.length() < 6) {
                        s = "0" + s;
                    }
                    this.hex.func_146180_a(s);
                    return;
                }
            }
            if (!this.color) {
                this.editing = true;
            }
        }
        if (mouseButton == 1) {
            if (this.editing) {
                this.editing = false;
            } else if (this.selectedPart != -1) {
                ICyberwareUserData data = CyberwareAPI.getCapability((Entity)this.field_146297_k.field_71439_g);
                HotkeyHelper.removeHotkey(data, data.getActiveItems().get(this.selectedPart));
                CyberwarePacketHandler.INSTANCE.sendToServer((IMessage)new SyncHotkeyPacket(this.selectedPart, Integer.MAX_VALUE));
            }
        }
        if (mouseButton > 1 && this.editing && this.selectedPart != -1) {
            this.assignHotkey(mouseButton - 100);
        }
    }

    public void func_73876_c() {
        block9: {
            block12: {
                block11: {
                    block10: {
                        super.func_73876_c();
                        this.hex.func_146178_a();
                        if (this.close) {
                            this.field_146297_k.func_147108_a(null);
                        }
                        if (this.field_146297_k == null || this.field_146297_k.field_71474_y == null) break block9;
                        if (KeyBinds.menu == null) break block10;
                        GameSettings cfr_ignored_0 = this.field_146297_k.field_71474_y;
                        if (!GameSettings.func_100015_a((KeyBinding)KeyBinds.menu) && !this.editing && !this.color) break block11;
                    }
                    if (CyberwareAPI.getCapability((Entity)this.field_146297_k.field_71439_g).getNumActiveItems() >= 1) break block12;
                }
                if (this.selectedPart != -1 && !this.editing) {
                    ICyberwareUserData data = CyberwareAPI.getCapability((Entity)this.field_146297_k.field_71439_g);
                    ItemStack hki = data.getActiveItems().get(this.selectedPart);
                    ClientUtils.useActiveItemClient((Entity)this.field_146297_k.field_71439_g, hki);
                }
                this.field_146297_k.func_147108_a(null);
            }
            ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
            for (KeyBinding keybind : set) {
                boolean ee = false;
                int key = keybind.func_151463_i();
                if (!this.editing) {
                    if (key < 0) {
                        int button = 100 + key;
                        ee = Mouse.isButtonDown((int)button);
                    } else {
                        ee = Keyboard.isKeyDown((int)key);
                    }
                }
                KeyBinding.func_74510_a((int)key, (boolean)ee);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        CyberwareAPI.syncHUDColor();
    }

    private void assignHotkey(int code) {
        ICyberwareUserData data = CyberwareAPI.getCapability((Entity)this.field_146297_k.field_71439_g);
        HotkeyHelper.removeHotkey(data, code);
        HotkeyHelper.assignHotkey(data, data.getActiveItems().get(this.selectedPart), code);
        CyberwarePacketHandler.INSTANCE.sendToServer((IMessage)new SyncHotkeyPacket(this.selectedPart, code));
        this.editing = false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            if (this.editing) {
                this.editing = false;
            } else {
                this.close = true;
            }
        } else if (keyCode != 42 && keyCode != 54 && keyCode != KeyBinds.menu.func_151463_i() && this.selectedPart != -1 && this.editing) {
            boolean shiftPressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            this.assignHotkey(keyCode + (shiftPressed ? 900 : 0));
        }
        this.hex.func_146201_a(typedChar, keyCode);
        if (this.hex.func_146179_b().length() >= 12) {
            this.hex.func_146180_a(this.hex.func_146179_b().substring(6, 12));
        }
        if (this.hex.func_146179_b().length() > 6) {
            this.hex.func_146180_a(this.hex.func_146179_b().substring(0, 6));
        }
        this.hex.func_146180_a(this.hex.func_146179_b().replaceAll("[^0-9AaBbCcDdEeFf]", ""));
        if (this.hex.func_146179_b().length() == 6) {
            CyberwareAPI.setHUDColor(Integer.parseInt(this.hex.func_146179_b(), 16));
        }
    }
}

