/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.api;

import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.UpdateHudColorPacket;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.misc.NNLUtil;
import flaxbeard.cyberware.common.network.CyberwareSyncPacket;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class CyberwareAPI {
    public static final String DATA_TAG = "cyberwareFunctionData";
    public static final String QUALITY_TAG = "cyberwareQuality";
    public static final ICyberware.Quality QUALITY_SCAVENGED = new ICyberware.Quality("cyberware.quality.scavenged", "cyberware.quality.scavenged.name_modifier", "scavenged");
    public static final ICyberware.Quality QUALITY_MANUFACTURED = new ICyberware.Quality("cyberware.quality.manufactured");
    @CapabilityInject(value=ICyberwareUserData.class)
    public static final Capability<ICyberwareUserData> CYBERWARE_CAPABILITY = null;
    public static final IAttribute TOLERANCE_ATTR = new RangedAttribute(null, "cyberware.tolerance", (double)CyberwareConfig.ESSENCE, 0.0, Double.MAX_VALUE).func_111117_a("Tolerance").func_111112_a(true);
    public static Map<ItemStack, ICyberware> linkedWare = new HashMap<ItemStack, ICyberware>();
    private static float[] mainColor = new float[]{0.0f, 1.0f, 1.0f};
    public static SimpleNetworkWrapper PACKET_HANDLER;

    @SideOnly(value=Side.CLIENT)
    public static void setHUDColor(float[] color) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (CyberwareAPI.hasCapability((Entity)p)) {
            CyberwareAPI.getCapability((Entity)p).setHudColor(color);
        }
    }

    public static void syncHUDColor() {
        PACKET_HANDLER.sendToServer((IMessage)new UpdateHudColorPacket(CyberwareAPI.getHUDColorHex()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void setHUDColor(int hexVal) {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (CyberwareAPI.hasCapability((Entity)p)) {
            CyberwareAPI.getCapability((Entity)p).setHudColor(hexVal);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setHUDColor(float r, float g, float b) {
        CyberwareAPI.setHUDColor(new float[]{r, g, b});
    }

    @SideOnly(value=Side.CLIENT)
    public static int getHUDColorHex() {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (CyberwareAPI.hasCapability((Entity)p)) {
            return CyberwareAPI.getCapability((Entity)p).getHudColorHex();
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static float[] getHUDColor() {
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (CyberwareAPI.hasCapability((Entity)p)) {
            return CyberwareAPI.getCapability((Entity)p).getHudColor();
        }
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public static ItemStack writeQualityTag(ItemStack stack, ICyberware.Quality quality) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a(QUALITY_TAG, quality.getUnlocalizedName());
        return stack;
    }

    public static ICyberware.Quality getQualityTag(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(QUALITY_TAG)) {
            return null;
        }
        return ICyberware.Quality.getQualityFromString(stack.func_77978_p().func_74779_i(QUALITY_TAG));
    }

    public static ItemStack sanitize(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(DATA_TAG)) {
                stack.func_77978_p().func_82580_o(DATA_TAG);
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
        return stack;
    }

    public static NBTTagCompound getCyberwareNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(DATA_TAG)) {
            stack.func_77978_p().func_74782_a(DATA_TAG, (NBTBase)new NBTTagCompound());
        }
        return stack.func_77978_p().func_74775_l(DATA_TAG);
    }

    public static boolean areCyberwareStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        ItemStack sanitized1 = CyberwareAPI.sanitize(stack1.func_77946_l());
        ItemStack sanitized2 = CyberwareAPI.sanitize(stack2.func_77946_l());
        return sanitized1.func_77973_b() == sanitized2.func_77973_b() && sanitized1.func_77952_i() == sanitized2.func_77952_i() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void linkCyberware(ItemStack stack, ICyberware link) {
        if (stack.func_190926_b()) {
            return;
        }
        ItemStack key = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
        linkedWare.put(key, link);
    }

    public static void linkCyberware(Item item, ICyberware link) {
        if (item == null) {
            return;
        }
        ItemStack key = new ItemStack(item, 1, Short.MAX_VALUE);
        linkedWare.put(key, link);
    }

    public static boolean isCyberware(ItemStack stack) {
        if (stack != null) {
            return !stack.func_190926_b() && (stack.func_77973_b() instanceof ICyberware || CyberwareAPI.getLinkedWare(stack) != null);
        }
        return false;
    }

    public static ICyberware getCyberware(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ICyberware) {
                return (ICyberware)stack.func_77973_b();
            }
            if (CyberwareAPI.getLinkedWare(stack) != null) {
                return CyberwareAPI.getLinkedWare(stack);
            }
        }
        throw new RuntimeException("Cannot call getCyberware on a non-cyberware item!");
    }

    public static boolean canDeconstruct(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IDeconstructable && ((IDeconstructable)stack.func_77973_b()).canDestroy(stack);
    }

    public static NonNullList<ItemStack> getComponents(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IDeconstructable) {
            return NNLUtil.copyList(((IDeconstructable)stack.func_77973_b()).getComponents(stack));
        }
        throw new RuntimeException("Cannot call getComponents on a non-cyberware item!");
    }

    private static ICyberware getLinkedWare(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemStack test = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
        ICyberware result = CyberwareAPI.getWareFromKey(test);
        if (result != null) {
            return result;
        }
        ItemStack testGeneric = new ItemStack(stack.func_77973_b(), 1, Short.MAX_VALUE);
        result = CyberwareAPI.getWareFromKey(testGeneric);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static ICyberware getWareFromKey(ItemStack key) {
        for (Map.Entry<ItemStack, ICyberware> entry : linkedWare.entrySet()) {
            ItemStack entryKey = entry.getKey();
            if (key.func_77973_b() != entryKey.func_77973_b() || key.func_77952_i() != entryKey.func_77952_i()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean hasCapability(@Nullable Entity targetEntity) {
        if (targetEntity == null) {
            return false;
        }
        return targetEntity.hasCapability(CYBERWARE_CAPABILITY, EnumFacing.EAST);
    }

    public static ICyberwareUserData getCapability(Entity targetEntity) {
        return (ICyberwareUserData)targetEntity.getCapability(CYBERWARE_CAPABILITY, EnumFacing.EAST);
    }

    public static boolean isCyberwareInstalled(@Nullable Entity targetEntity, ItemStack stack) {
        if (!CyberwareAPI.hasCapability(targetEntity)) {
            return false;
        }
        ICyberwareUserData cyberware = CyberwareAPI.getCapability(targetEntity);
        return cyberware.isCyberwareInstalled(stack);
    }

    public static int getCyberwareRank(@Nullable Entity targetEntity, ItemStack stack) {
        if (!CyberwareAPI.hasCapability(targetEntity)) {
            return 0;
        }
        ICyberwareUserData cyberware = CyberwareAPI.getCapability(targetEntity);
        return cyberware.getCyberwareRank(stack);
    }

    public static ItemStack getCyberware(@Nullable Entity targetEntity, ItemStack stack) {
        if (!CyberwareAPI.hasCapability(targetEntity)) {
            return ItemStack.field_190927_a;
        }
        ICyberwareUserData cyberware = CyberwareAPI.getCapability(targetEntity);
        return cyberware.getCyberware(stack);
    }

    public static void updateData(Entity targetEntity) {
        if (!targetEntity.field_70170_p.field_72995_K) {
            WorldServer world = (WorldServer)targetEntity.field_70170_p;
            NBTTagCompound nbt = CyberwareAPI.getCapability(targetEntity).serializeNBT();
            if (targetEntity instanceof EntityPlayer) {
                PACKET_HANDLER.sendTo((IMessage)new CyberwareSyncPacket(nbt, targetEntity.func_145782_y()), (EntityPlayerMP)targetEntity);
            }
            for (EntityPlayer trackingPlayer : world.func_73039_n().getTrackingPlayers(targetEntity)) {
                PACKET_HANDLER.sendTo((IMessage)new CyberwareSyncPacket(nbt, targetEntity.func_145782_y()), (EntityPlayerMP)trackingPlayer);
                if (!(targetEntity instanceof EntityPlayer)) continue;
            }
        }
    }

    public static void useActiveItem(Entity entity, ItemStack stack) {
        ((IMenuItem)stack.func_77973_b()).use(entity, stack);
    }
}

