/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.stream.IntStream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.input.Mouse;
import slimeknights.mantle.client.book.StructureBlockAccess;
import slimeknights.mantle.client.book.StructureInfo;
import slimeknights.mantle.client.book.data.element.BlockData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.ElementButton;
import slimeknights.mantle.client.gui.book.element.IButtonClickHandler;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

public class ElementStructure
extends SizedBookElement
implements IButtonClickHandler {
    public static final int BUTTON_ID_LAYER_UP = 0;
    public static final int BUTTON_ID_LAYER_DOWN = 1;
    public static final int BUTTON_ID_ANIMATE = 2;
    private float scale = 50.0f;
    private float xTranslate = 0.0f;
    private float yTranslate = 0.0f;
    private float w = 0.0f;
    private float h = 0.0f;
    boolean canTick = false;
    int tick = 0;
    float rotX = 0.0f;
    float rotY = 0.0f;
    float rotZ = 0.0f;
    public StructureInfo structureData;
    StructureBlockAccess blockAccess;
    int[] lastClick = null;
    private int fullStructureSteps = 5;
    private int lastX;
    private int lastY;

    public ElementStructure(int x, int y, int width, int height, int[] size, BlockData[] structure) {
        super(x, y, width, height);
        if (size.length == 3) {
            this.scale = 100.0f / (float)IntStream.of(size).max().getAsInt();
            float sx = (float)width / (float)GuiBook.PAGE_WIDTH;
            float sy = (float)height / (float)GuiBook.PAGE_HEIGHT;
            this.scale *= Math.min(sx, sy);
            this.xTranslate = x + width / 2;
            this.yTranslate = y + height / 2;
            this.w = (float)size[0] * this.scale;
            this.h = (float)size[1] * this.scale;
        }
        this.init(size, structure);
    }

    public void init(int[] size, BlockData[] data) {
        boolean yOff = false;
        this.structureData = new StructureInfo(size[0], size[1], size[2], data);
        this.blockAccess = new StructureBlockAccess(this.structureData);
        this.rotX = 25.0f;
        this.rotY = -45.0f;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.lastClick != null) {
            if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
                int dx = mouseX - this.lastClick[0];
                int dy = mouseY - this.lastClick[1];
                float maxSpeed = 10.0f;
                float changeX = Math.min(maxSpeed, (float)dx / 10.0f);
                float changeY = Math.min(maxSpeed, (float)dy / 10.0f);
                this.rotY += changeX;
                this.rotX += changeY;
            } else {
                this.lastClick = null;
            }
        }
        if (this.canTick) {
            if (++this.tick % 20 == 0 && (this.structureData.canStep() || ++this.fullStructureSteps >= 5)) {
                this.structureData.step();
                this.fullStructureSteps = 0;
            }
        } else {
            this.structureData.reset();
            this.structureData.setShowLayer(9);
        }
        int structureLength = this.structureData.structureLength;
        int structureWidth = this.structureData.structureWidth;
        int structureHeight = this.structureData.structureHeight;
        int xHalf = structureWidth * 5 - structureLength * 5;
        int yOffPartial = (structureHeight - 1) * 16 + structureWidth * 8 + structureLength * 8;
        int yOffTotal = Math.max(52, yOffPartial + 16);
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        boolean i = false;
        Object highlighted = null;
        BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
        float f = (float)Math.sqrt(structureHeight * structureHeight + structureWidth * structureWidth + structureLength * structureLength);
        yOffTotal = 10 + Math.max(10 + (structureHeight > 1 ? 36 : 0), (int)(f * this.scale));
        GlStateManager.func_179109_b((float)this.xTranslate, (float)this.yTranslate, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
        GlStateManager.func_179152_a((float)this.scale, (float)(-this.scale), (float)1.0f);
        GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)((float)structureLength / -2.0f), (float)((float)structureHeight / -2.0f), (float)((float)structureWidth / -2.0f));
        GlStateManager.func_179140_f();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        if (structureWidth % 2 == 1) {
            // empty if block
        }
        boolean iterator = false;
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        for (int h = 0; h < this.structureData.structureHeight; ++h) {
            for (int l = 0; l < this.structureData.structureLength; ++l) {
                for (int w = 0; w < this.structureData.structureWidth; ++w) {
                    BlockPos pos = new BlockPos(l, h, w);
                    if (this.blockAccess.func_175623_d(pos)) continue;
                    IBlockState state = this.blockAccess.func_180495_p(pos);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    VertexBuffer buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    blockRender.func_175018_a(state, pos, (IBlockAccess)this.blockAccess, buffer);
                    tessellator.func_78381_a();
                }
            }
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.lastClick = new int[]{mouseX, mouseY};
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton) {
        int dx = mouseX - this.lastX;
        int dy = mouseX - this.lastY;
        float maxSpeed = 1.0f;
        float changeX = Math.min(maxSpeed, (float)dx / 100.0f);
        float changeY = Math.min(maxSpeed, (float)dy / 100.0f);
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int clickedMouseButton) {
        super.mouseReleased(mouseX, mouseY, clickedMouseButton);
        this.lastClick = null;
    }

    @Override
    public void mouseDragged(int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        int dx = mx - lastX;
        int dy = my - lastY;
        this.rotY += (float)dx / 104.0f;
        this.rotX += (float)dy / 100.0f;
    }

    public void changeActiveLayer(int direction) {
    }

    @Override
    public boolean onButtonClick(int buttonId, ElementButton button) {
        switch (buttonId) {
            case 2: {
                this.canTick = !this.canTick;
                return true;
            }
        }
        return false;
    }
}

