/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class JsonElementIO {
    private static final int NULL = 0;
    private static final int ARRAY = 1;
    private static final int OBJECT = 2;
    private static final int STRING = 3;
    private static final int BOOL = 4;
    private static final int BYTE = 5;
    private static final int SHORT = 6;
    private static final int INT = 7;
    private static final int LONG = 8;
    private static final int FLOAT = 9;
    private static final int DOUBLE = 10;

    public static int getID(@Nullable JsonElement e) {
        if (e == null || e.isJsonNull()) {
            return 0;
        }
        if (e.isJsonArray()) {
            return 1;
        }
        if (e.isJsonObject()) {
            return 2;
        }
        JsonPrimitive p = e.getAsJsonPrimitive();
        if (p.isString()) {
            return 3;
        }
        if (p.isBoolean()) {
            return 4;
        }
        Class<?> n = p.getAsNumber().getClass();
        if (n == Integer.class) {
            return 7;
        }
        if (n == Byte.class) {
            return 5;
        }
        if (n == Short.class) {
            return 6;
        }
        if (n == Long.class) {
            return 8;
        }
        if (n == Float.class) {
            return 9;
        }
        if (n == Double.class) {
            return 10;
        }
        return 0;
    }

    public static JsonElement read(DataInput data) throws IOException {
        switch (data.readUnsignedByte()) {
            case 0: {
                return JsonNull.INSTANCE;
            }
            case 1: {
                JsonArray a = new JsonArray();
                int s = data.readInt();
                for (int i = 0; i < s; ++i) {
                    a.add(JsonElementIO.read(data));
                }
                return a;
            }
            case 2: {
                JsonObject o = new JsonObject();
                int s = data.readInt();
                for (int i = 0; i < s; ++i) {
                    String key = data.readUTF();
                    o.add(key, JsonElementIO.read(data));
                }
                return o;
            }
            case 3: {
                return new JsonPrimitive(data.readUTF());
            }
            case 4: {
                return new JsonPrimitive(Boolean.valueOf(data.readBoolean()));
            }
            case 5: {
                return new JsonPrimitive((Number)data.readByte());
            }
            case 6: {
                return new JsonPrimitive((Number)data.readShort());
            }
            case 7: {
                return new JsonPrimitive((Number)data.readInt());
            }
            case 8: {
                return new JsonPrimitive((Number)data.readLong());
            }
            case 9: {
                return new JsonPrimitive((Number)Float.valueOf(data.readFloat()));
            }
            case 10: {
                return new JsonPrimitive((Number)data.readDouble());
            }
        }
        return JsonNull.INSTANCE;
    }

    public static void write(DataOutput data, @Nullable JsonElement e) throws IOException {
        if (e == null || e.isJsonNull()) {
            data.writeByte(0);
        } else if (e.isJsonArray()) {
            data.writeByte(1);
            JsonArray a = e.getAsJsonArray();
            int s = a.size();
            data.writeInt(s);
            for (int i = 0; i < s; ++i) {
                JsonElementIO.write(data, a.get(i));
            }
        } else if (e.isJsonObject()) {
            data.writeByte(2);
            Set set = e.getAsJsonObject().entrySet();
            data.writeInt(set.size());
            for (Map.Entry entry : set) {
                data.writeUTF((String)entry.getKey());
                JsonElementIO.write(data, (JsonElement)entry.getValue());
            }
        } else {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                data.writeByte(3);
                data.writeUTF(p.getAsString());
            } else if (p.isBoolean()) {
                data.writeByte(4);
                data.writeBoolean(p.getAsBoolean());
            } else {
                Class<?> n = p.getAsNumber().getClass();
                if (n == Integer.class) {
                    data.writeByte(7);
                    data.writeInt(p.getAsInt());
                } else if (n == Byte.class) {
                    data.writeByte(5);
                    data.writeByte(p.getAsByte());
                } else if (n == Short.class) {
                    data.writeByte(6);
                    data.writeShort(p.getAsShort());
                } else if (n == Long.class) {
                    data.writeByte(8);
                    data.writeLong(p.getAsLong());
                } else if (n == Float.class) {
                    data.writeByte(9);
                    data.writeFloat(p.getAsFloat());
                } else if (n == Double.class) {
                    data.writeByte(10);
                    data.writeDouble(p.getAsDouble());
                } else {
                    data.writeByte(0);
                }
            }
        }
    }

    public static JsonElement read(ByteBuf data) {
        switch (data.readUnsignedByte()) {
            case 0: {
                return JsonNull.INSTANCE;
            }
            case 1: {
                JsonArray a = new JsonArray();
                int s = data.readInt();
                for (int i = 0; i < s; ++i) {
                    a.add(JsonElementIO.read(data));
                }
                return a;
            }
            case 2: {
                JsonObject o = new JsonObject();
                int s = data.readInt();
                for (int i = 0; i < s; ++i) {
                    String key = ByteBufUtils.readUTF8String((ByteBuf)data);
                    o.add(key, JsonElementIO.read(data));
                }
                return o;
            }
            case 3: {
                return new JsonPrimitive(ByteBufUtils.readUTF8String((ByteBuf)data));
            }
            case 4: {
                return new JsonPrimitive(Boolean.valueOf(data.readBoolean()));
            }
            case 5: {
                return new JsonPrimitive((Number)data.readByte());
            }
            case 6: {
                return new JsonPrimitive((Number)data.readShort());
            }
            case 7: {
                return new JsonPrimitive((Number)data.readInt());
            }
            case 8: {
                return new JsonPrimitive((Number)data.readLong());
            }
            case 9: {
                return new JsonPrimitive((Number)Float.valueOf(data.readFloat()));
            }
            case 10: {
                return new JsonPrimitive((Number)data.readDouble());
            }
        }
        return JsonNull.INSTANCE;
    }

    public static void write(ByteBuf data, @Nullable JsonElement e) {
        if (e == null || e.isJsonNull()) {
            data.writeByte(0);
        } else if (e.isJsonArray()) {
            data.writeByte(1);
            JsonArray a = e.getAsJsonArray();
            int s = a.size();
            data.writeInt(s);
            for (int i = 0; i < s; ++i) {
                JsonElementIO.write(data, a.get(i));
            }
        } else if (e.isJsonObject()) {
            data.writeByte(2);
            Set set = e.getAsJsonObject().entrySet();
            data.writeInt(set.size());
            for (Map.Entry entry : set) {
                ByteBufUtils.writeUTF8String((ByteBuf)data, (String)((String)entry.getKey()));
                JsonElementIO.write(data, (JsonElement)entry.getValue());
            }
        } else {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                data.writeByte(3);
                ByteBufUtils.writeUTF8String((ByteBuf)data, (String)p.getAsString());
            } else if (p.isBoolean()) {
                data.writeByte(4);
                data.writeBoolean(p.getAsBoolean());
            } else {
                Class<?> n = p.getAsNumber().getClass();
                if (n == Integer.class) {
                    data.writeByte(7);
                    data.writeInt(p.getAsInt());
                } else if (n == Byte.class) {
                    data.writeByte(5);
                    data.writeByte((int)p.getAsByte());
                } else if (n == Short.class) {
                    data.writeByte(6);
                    data.writeShort((int)p.getAsShort());
                } else if (n == Long.class) {
                    data.writeByte(8);
                    data.writeLong(p.getAsLong());
                } else if (n == Float.class) {
                    data.writeByte(9);
                    data.writeFloat(p.getAsFloat());
                } else if (n == Double.class) {
                    data.writeByte(10);
                    data.writeDouble(p.getAsDouble());
                } else {
                    data.writeByte(0);
                }
            }
        }
    }
}

