/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.api.info.IInfoTextLineProvider;
import com.feed_the_beast.ftbl.lib.info.InfoExtendedTextLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.info.InfoTextLineString;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class InfoPageHelper {
    public static final Map<String, IInfoTextLineProvider> INFO_TEXT_LINE_PROVIDERS = new HashMap<String, IInfoTextLineProvider>();

    public static String getUnformattedText(InfoPage page) {
        List<IInfoTextLine> text = page.getText();
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int s = text.size();
        for (int i = 0; i < s; ++i) {
            IInfoTextLine c = text.get(i);
            if (c == null) {
                sb.append('\n');
            } else {
                String s1 = c.getUnformattedText();
                sb.append(s1 == null || s1.isEmpty() ? "\n" : s1);
            }
            if (i == s - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    @Nullable
    public static IInfoTextLine createLine(InfoPage page, @Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            String s = json.getAsString();
            return s.trim().isEmpty() ? null : new InfoTextLineString(s);
        }
        if (json.isJsonArray()) {
            return new InfoExtendedTextLine(json);
        }
        JsonObject o = json.getAsJsonObject();
        IInfoTextLineProvider provider = null;
        if (o.has("id")) {
            provider = INFO_TEXT_LINE_PROVIDERS.get(o.get("id").getAsString());
        }
        IInfoTextLine line = provider != null ? provider.create(page, json) : new InfoExtendedTextLine(json);
        return line;
    }
}

