/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.info;

import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IPanel;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api.info.IInfoTextLine;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.WidgetLM;
import com.feed_the_beast.ftbl.lib.info.EmptyInfoPageLine;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.renderer.GlStateManager;

public class InfoHrLine
extends EmptyInfoPageLine {
    public final int height;
    public final int color;

    public InfoHrLine(int h, int c) {
        this.height = h;
        this.color = c;
    }

    public InfoHrLine(JsonElement e) {
        JsonObject o = e.getAsJsonObject();
        this.height = o.has("height") ? Math.max(1, o.get("height").getAsInt()) : 1;
        this.color = o.has("color") ? LMColorUtils.deserialize(o.get("color")) : 0;
    }

    @Override
    public IWidget createWidget(IGui gui, IPanel parent) {
        return new WidgetInfoHr(parent);
    }

    @Override
    public IInfoTextLine copy(InfoPage page) {
        return new InfoHrLine(this.height, this.color);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("hr"));
        o.add("height", (JsonElement)new JsonPrimitive((Number)this.height));
        o.add("color", LMColorUtils.serialize(this.color));
        return o;
    }

    private class WidgetInfoHr
    extends WidgetLM {
        private WidgetInfoHr(IPanel parent) {
            super(0, 1, parent.getWidth(), InfoHrLine.this.height + 2);
        }

        @Override
        public void renderWidget(IGui gui) {
            LMColorUtils.GL_COLOR.set(InfoHrLine.this.color == 0 ? gui.getTextColor() : InfoHrLine.this.color);
            GuiHelper.drawBlankRect(this.getAX(), this.getAY() + 1, this.getWidth(), InfoHrLine.this.height);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

