/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLM;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.PanelLM;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class GuiEditConfig
extends GuiLM
implements IGuiEditConfig {
    public static final Comparator<Map.Entry<IConfigKey, IConfigValue>> COMPARATOR = (o1, o2) -> ((IConfigKey)o1.getKey()).getDisplayName().func_150254_d().compareTo(((IConfigKey)o2.getKey()).getDisplayName().func_150254_d());
    private final IConfigContainer configContainer;
    private final NBTTagCompound extraNBT;
    private final JsonObject modifiedConfig;
    private final String title;
    private final List<ButtonConfigEntry> configEntryButtons;
    private final PanelLM configPanel;
    private final ButtonLM buttonAccept;
    private final ButtonLM buttonCancel;
    private final PanelScrollBar scroll;
    private int shouldClose = 0;

    public GuiEditConfig(@Nullable NBTTagCompound nbt, IConfigContainer cc) {
        super(0, 0);
        this.configContainer = cc;
        ITextComponent title0 = this.configContainer.getTitle().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.extraNBT = nbt;
        this.modifiedConfig = new JsonObject();
        this.configEntryButtons = new ArrayList<ButtonConfigEntry>();
        ArrayList<Map.Entry<IConfigKey, IConfigValue>> list = new ArrayList<Map.Entry<IConfigKey, IConfigValue>>();
        list.addAll(this.configContainer.getConfigTree().getTree().entrySet());
        Collections.sort(list, COMPARATOR);
        for (Map.Entry entry : list) {
            if (((IConfigKey)entry.getKey()).getFlag(2)) continue;
            this.configEntryButtons.add(new ButtonConfigEntry((IConfigKey)entry.getKey(), ((IConfigValue)entry.getValue()).copy()));
        }
        this.configPanel = new PanelLM(0, 20, 0, 20){

            @Override
            public void addWidgets() {
                this.addAll(GuiEditConfig.this.configEntryButtons);
            }

            @Override
            public void updateWidgetPositions() {
                GuiEditConfig.this.scroll.setElementSize(this.alignWidgetsByHeight());
            }
        };
        this.configPanel.addFlags(3);
        this.buttonAccept = new ButtonLM(0, 2, 16, 16, GuiLang.BUTTON_ACCEPT.translate(new Object[0])){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfig.this.shouldClose = 1;
                gui.closeGui();
            }
        };
        this.buttonAccept.setIcon(GuiIcons.ACCEPT);
        this.buttonCancel = new ButtonLM(0, 2, 16, 16, GuiLang.BUTTON_CANCEL.translate(new Object[0])){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfig.this.shouldClose = 2;
                gui.closeGui();
            }
        };
        this.buttonCancel.setIcon(GuiIcons.CANCEL);
        this.scroll = new PanelScrollBar(-16, 20, 16, 0, 10, this.configPanel);
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    @Override
    public void updateWidgetPositions() {
        this.buttonAccept.posX = this.getWidth() - 18;
        this.buttonCancel.posX = this.getWidth() - 38;
        this.configPanel.setHeight(this.getHeight() - 20);
        this.configPanel.setWidth(this.getWidth());
        this.scroll.posX = this.getWidth() - 16;
        this.scroll.setHeight(this.configPanel.getHeight());
        for (ButtonConfigEntry b : this.configEntryButtons) {
            b.setWidth(this.scroll.posX);
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.scroll);
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose == 1 && !this.modifiedConfig.entrySet().isEmpty()) {
            this.configContainer.saveConfig((ICommandSender)this.mc.field_71439_g, this.extraNBT, this.modifiedConfig);
        }
    }

    @Override
    public boolean onClosedByKey() {
        this.buttonCancel.onClicked(this, MouseButton.LEFT);
        return false;
    }

    @Override
    public void onChanged(IConfigKey key, JsonElement val) {
        this.modifiedConfig.add(key.func_176610_l(), val);
    }

    @Override
    public void drawBackground() {
        LMColorUtils.GL_COLOR.set(-1724697805);
        GuiHelper.drawBlankRect(0, 0, this.getWidth(), 20);
        this.getFont().func_78276_b(this.getTitle(this), 6, 6, -1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public String getTitle(IGui gui) {
        return this.title;
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    public class ButtonConfigEntry
    extends ButtonLM {
        public final IConfigKey key;
        public final IConfigValue value;
        public String keyText;
        public List<String> info;

        public ButtonConfigEntry(IConfigKey id, IConfigValue e) {
            super(0, 0, 0, 16);
            this.key = id;
            this.value = e;
            this.keyText = id.getDisplayName().func_150260_c();
            if (this.keyText.startsWith("config.") && this.keyText.endsWith(".name")) {
                this.keyText = id.func_176610_l();
            }
            if (!id.getInfo().isEmpty()) {
                this.info = GuiEditConfig.this.getFont().func_78271_c(id.getInfo(), 230);
            }
        }

        @Override
        public void renderWidget(IGui gui) {
            boolean mouseOver = GuiEditConfig.this.getMouseY() >= 20 && gui.isMouseOver(this);
            int ax = this.getAX();
            int ay = this.getAY();
            if (mouseOver) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.13f);
                GuiHelper.drawBlankRect(ax, ay, this.getWidth(), this.getHeight());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GuiEditConfig.this.getFont().func_78276_b(this.keyText, ax + 4, ay + 4, mouseOver ? -1 : -6710887);
            String s = this.value.getString();
            int slen = GuiEditConfig.this.getFont().func_78256_a(s);
            if (slen > 150) {
                s = GuiEditConfig.this.getFont().func_78269_a(s, 150) + "...";
                slen = 152;
            }
            int textCol = 0xFF000000 | this.value.getColor();
            if (mouseOver) {
                textCol = LMColorUtils.addBrightness(textCol, 60);
            }
            if (mouseOver && GuiEditConfig.this.getMouseX() > ax + this.getWidth() - slen - 9) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.13f);
                GuiHelper.drawBlankRect(ax + this.getWidth() - slen - 8, ay, slen + 8, this.getHeight());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GuiEditConfig.this.getFont().func_78276_b(s, gui.getWidth() - (slen + 20), ay + 4, textCol);
        }

        @Override
        public void onClicked(IGui gui, IMouseButton button) {
            if (GuiEditConfig.this.getMouseY() >= 20 && !this.key.getFlag(4)) {
                GuiHelper.playClickSound();
                this.value.onClicked(GuiEditConfig.this, this.key, button);
            }
        }

        @Override
        public void addMouseOverText(IGui gui, List<String> list) {
            if (GuiEditConfig.this.getMouseY() > 18) {
                if (GuiEditConfig.this.getMouseX() < this.getAX() + GuiEditConfig.this.getFont().func_78256_a(this.keyText) + 10 && this.info != null) {
                    list.addAll(this.info);
                }
                if (GuiEditConfig.this.getMouseX() > gui.getWidth() - (Math.min(150, GuiEditConfig.this.getFont().func_78256_a(this.value.getString())) + 25)) {
                    this.value.addInfo(this.key, list);
                }
            }
        }
    }
}

