/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.ITeamMessage;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.gui.IWidget;
import com.feed_the_beast.ftbl.api_impl.ForgePlayerFake;
import com.feed_the_beast.ftbl.client.teamsgui.MyTeamData;
import com.feed_the_beast.ftbl.client.teamsgui.MyTeamPlayerData;
import com.feed_the_beast.ftbl.lib.MouseButton;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.CentredTextButton;
import com.feed_the_beast.ftbl.lib.gui.CheckBoxListLM;
import com.feed_the_beast.ftbl.lib.gui.ExtendedTextFieldLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLM;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.PanelLM;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.PlayerHeadImage;
import com.feed_the_beast.ftbl.lib.gui.TextBoxLM;
import com.feed_the_beast.ftbl.lib.gui.TextFieldLM;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class GuiMyTeam
extends GuiLM {
    private static final int TOP_PANEL_HEIGHT = 20;
    private static final int BOTTOM_PANEL_HEIGHT = 20;
    private static final int LEFT_PANEL_WIDTH = 90;
    public static GuiMyTeam INSTANCE = null;
    private final MyTeamData teamInfo;
    private final PanelLM panelPlayers;
    private final PanelLM panelText;
    private final ButtonLM buttonTeamsGui;
    private final ButtonLM buttonTeamTitle;
    private final ButtonLM buttonExitTeam;
    private MyTeamPlayerData selectedPlayer;
    private final PanelScrollBar scrollPlayers;
    private final PanelScrollBar scrollText;
    private final List<IWidget> topPanelButtons;
    private final Map<UUID, MyTeamPlayerData> loadedProfiles;
    private final TextBoxLM chatBox;

    public GuiMyTeam(MyTeamData t) {
        super(0, 0);
        INSTANCE = this;
        this.teamInfo = t;
        Collections.sort(this.teamInfo.players);
        this.loadedProfiles = new HashMap<UUID, MyTeamPlayerData>();
        for (MyTeamPlayerData p : this.teamInfo.players) {
            this.loadedProfiles.put(p.playerId, p);
        }
        this.panelPlayers = new PanelLM(1, 20, 89, 0){

            @Override
            public void addWidgets() {
                for (MyTeamPlayerData p : ((GuiMyTeam)GuiMyTeam.this).teamInfo.players) {
                    this.add(new ButtonPlayer(p));
                }
            }

            @Override
            public void updateWidgetPositions() {
                GuiMyTeam.this.scrollPlayers.setElementSize(this.alignWidgetsByHeight(0, 1, 0));
                GuiMyTeam.this.scrollPlayers.setSrollStepFromOneElementSize(13);
            }
        };
        this.panelPlayers.addFlags(3);
        this.panelText = new PanelLM(91, 20, 0, 0){

            @Override
            public void addWidgets() {
                if (GuiMyTeam.this.selectedPlayer == null) {
                    for (ITeamMessage msg : ((GuiMyTeam)GuiMyTeam.this).teamInfo.chatHistory) {
                        boolean sentByServer = msg.getSender().equals(ForgePlayerFake.SERVER.getId());
                        TextComponentString c = new TextComponentString(sentByServer ? "" : "<" + ((MyTeamPlayerData)((GuiMyTeam)GuiMyTeam.this).loadedProfiles.get((Object)msg.getSender())).playerName + "> ");
                        c.func_150257_a(msg.getMessage());
                        if (sentByServer) {
                            c.func_150256_b().func_150238_a(TextFormatting.DARK_AQUA);
                        }
                        this.add(new ExtendedTextFieldLM(1, 0, this.getWidth() - 5, -1, GuiMyTeam.this.getFont(), (ITextComponent)c));
                    }
                } else if (((GuiMyTeam)GuiMyTeam.this).teamInfo.me.status.isEqualOrGreaterThan(EnumTeamStatus.MOD)) {
                    if (((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerId.equals(GuiMyTeam.this.mc.field_71439_g.func_146103_bH().getId())) {
                        this.add(new TextFieldLM(4, 0, this.getWidth() - 5, -1, GuiMyTeam.this.getFont(), "You can't edit yourself!"));
                    } else if (((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerId.equals(((GuiMyTeam)GuiMyTeam.this).teamInfo.owner.playerId)) {
                        this.add(new TextFieldLM(4, 0, this.getWidth() - 5, -1, GuiMyTeam.this.getFont(), "You can't edit owner!"));
                    } else {
                        this.add(new TextFieldLM(4, 0, this.getWidth() - 5, -1, GuiMyTeam.this.getFont(), "ID: " + LMStringUtils.fromUUID(((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerId)));
                        CheckBoxListLM checkBoxes = new CheckBoxListLM(4, 1, true);
                        EnumTeamStatus[] VALUES = ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER) ? new EnumTeamStatus[]{EnumTeamStatus.MEMBER, EnumTeamStatus.MOD} : new EnumTeamStatus[]{EnumTeamStatus.NONE, EnumTeamStatus.INVITED, EnumTeamStatus.ALLY, EnumTeamStatus.ENEMY};
                        for (final EnumTeamStatus status : VALUES) {
                            CheckBoxListLM.CheckBoxEntry entry = new CheckBoxListLM.CheckBoxEntry(status.getColor() + status.getLangKey().translate(new Object[0])){

                                @Override
                                public void onValueChanged() {
                                    if (this.value > 0) {
                                        FTBLibClient.execClientCommand("/ftb team set_status " + ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerId + " " + status.func_176610_l());
                                        ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.status = status;
                                    }
                                }
                            };
                            checkBoxes.addBox((IGui)GuiMyTeam.this, entry);
                            if (status != ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.status) continue;
                            entry.select(1);
                        }
                        this.add(checkBoxes);
                        if (((GuiMyTeam)GuiMyTeam.this).selectedPlayer.status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER)) {
                            this.add(new CentredTextButton(4, 0, 40, 16, "Kick"){

                                @Override
                                public void onClicked(IGui gui, IMouseButton button) {
                                    GuiHelper.playClickSound();
                                    GuiMyTeam.this.mc.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                                        if (result) {
                                            FTBLibClient.execClientCommand("/ftb team kick " + ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerName);
                                            ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.status = EnumTeamStatus.NONE;
                                        }
                                        GuiMyTeam.this.openGui();
                                    }, "Kick " + ((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerName + "?", "", 0));
                                }
                            });
                        }
                    }
                } else {
                    this.add(new TextFieldLM(1, 0, this.getWidth() - 5, -1, GuiMyTeam.this.getFont(), "You don't have permission to manage players!"));
                }
            }

            @Override
            public void updateWidgetPositions() {
                if (GuiMyTeam.this.selectedPlayer == null) {
                    GuiMyTeam.this.scrollText.setElementSize(this.alignWidgetsByHeight(2, 1, 2));
                    GuiMyTeam.this.scrollText.setSrollStepFromOneElementSize(11);
                } else {
                    GuiMyTeam.this.scrollText.setElementSize(this.alignWidgetsByHeight(2, 4, 2));
                }
            }
        };
        this.panelText.addFlags(3);
        this.buttonTeamsGui = new ButtonLM(0, 0, 90, 20){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiMyTeam.this.selectedPlayer = null;
                GuiMyTeam.this.buttonTeamTitle.setTitle(((GuiMyTeam)GuiMyTeam.this).teamInfo.displayName);
                GuiMyTeam.this.scrollText.setValue(gui, 1.0);
                gui.refreshWidgets();
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return gui.getTextColor();
            }
        };
        this.buttonTeamsGui.setTitle("Teams GUI");
        this.buttonTeamTitle = new ButtonLM(91, 1, 0, 18){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
            }

            @Override
            public void addMouseOverText(IGui gui, List<String> list) {
                if (!((GuiMyTeam)GuiMyTeam.this).teamInfo.description.isEmpty()) {
                    list.add(((GuiMyTeam)GuiMyTeam.this).teamInfo.description);
                }
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return gui.getTextColor();
            }
        };
        this.buttonExitTeam = new ButtonLM(1, 0, 89, 18){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiMyTeam.this.mc.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                    if (result) {
                        FTBLibClient.execClientCommand("/ftb team leave");
                        GuiMyTeam.this.closeGui();
                    } else {
                        GuiMyTeam.this.openGui();
                    }
                }, "Exit Team?", TextFormatting.RED + "Warning: You can't rejoin the team, unless you are re-invited!", 0));
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return -1408125;
            }
        };
        this.buttonExitTeam.setTitle("Exit Team");
        this.scrollPlayers = new PanelScrollBar(87, 20, 3, 0, 14, this.panelPlayers);
        this.scrollText = new PanelScrollBar(0, 20, 3, 0, 14, this.panelText);
        this.scrollText.background = this.scrollPlayers.background = new TexturelessRectangle(0x78666666);
        this.scrollText.slider = this.scrollPlayers.slider = new TexturelessRectangle(0x50FFFFFF);
        this.topPanelButtons = new ArrayList<IWidget>();
        if (this.teamInfo.me.status.isEqualOrGreaterThan(EnumTeamStatus.MOD)) {
            ButtonLM b = new ButtonLM(0, 2, 16, 16){

                @Override
                public void onClicked(IGui gui, IMouseButton button) {
                    GuiHelper.playClickSound();
                    FTBLibClient.execClientCommand("/ftb team gui add_player");
                    this.setTitle(GuiLang.BUTTON_REFRESH.translate(new Object[0]));
                    this.setIcon(GuiIcons.REFRESH);
                }
            };
            b.setTitle(GuiLang.BUTTON_ADD.translate(new Object[0]));
            b.setIcon(GuiIcons.ADD);
            this.topPanelButtons.add(b);
            b = new ButtonLM(0, 2, 16, 16){

                @Override
                public void onClicked(IGui gui, IMouseButton button) {
                    GuiHelper.playClickSound();
                    FTBLibClient.execClientCommand("/ftb team config");
                }
            };
            b.setTitle("Team Settings");
            b.setIcon(GuiIcons.SETTINGS);
            this.topPanelButtons.add(b);
        }
        this.chatBox = new TextBoxLM(90, 0, 0, 20){

            @Override
            public void onEnterPressed(IGui gui) {
                FTBLibClient.execClientCommand("/ftb team msg " + this.getText());
                this.setText(gui, "");
                this.setFocused(true);
            }
        };
        this.chatBox.ghostText = TextFormatting.DARK_GRAY.toString() + TextFormatting.ITALIC + "Chat...";
        this.chatBox.charLimit = 86;
        this.buttonTeamsGui.onClicked(this, MouseButton.LEFT);
    }

    @Override
    public void onInit() {
        this.setWidth(this.getScreen().func_78326_a() - 30);
        this.setHeight(this.getScreen().func_78328_b() - 30);
        int width = this.getWidth();
        int height = this.getHeight();
        for (int i = 0; i < this.topPanelButtons.size(); ++i) {
            this.topPanelButtons.get(i).setX(width + (i - this.topPanelButtons.size()) * 20);
        }
        this.buttonExitTeam.setY(height - 20 + 1);
        this.buttonTeamTitle.setWidth(width - 90 - 3 - this.topPanelButtons.size() * 20);
        this.panelPlayers.setHeight(height - 20 - 20);
        this.scrollPlayers.setHeight(this.panelPlayers.getHeight());
        this.scrollText.setHeight(this.panelPlayers.getHeight());
        this.scrollText.setX(width - 4);
        this.panelText.setWidth(width - 90 - 1);
        this.panelText.setHeight(this.panelPlayers.getHeight());
        this.chatBox.setWidth(this.panelText.getWidth());
        this.chatBox.setY(height - 20 + 1);
    }

    @Override
    public void addWidgets() {
        this.add(this.scrollPlayers);
        this.add(this.scrollText);
        this.add(this.buttonTeamsGui);
        this.add(this.buttonTeamTitle);
        this.add(this.panelPlayers);
        this.add(this.panelText);
        this.addAll(this.topPanelButtons);
        this.add(this.buttonExitTeam);
        if (this.selectedPlayer == null) {
            this.add(this.chatBox);
        }
        this.scrollText.onMoved(this);
    }

    @Override
    public void drawBackground() {
        int ax = this.getAX();
        int ay = this.getAY();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean playerGui = this.selectedPlayer != null;
        this.getIcon(this).draw(ax, ay, width, height);
        LMColorUtils.GL_COLOR.set(GuiMyTeam.DEFAULT_BACKGROUND.lineColor);
        GuiHelper.drawBlankRect(ax, ay + 20 - 1, width, 1);
        GuiHelper.drawBlankRect(ax, ay + height - 20, playerGui ? 90 : width, 1);
        if (!this.topPanelButtons.isEmpty()) {
            GuiHelper.drawBlankRect(ax + width - 3 - this.topPanelButtons.size() * 20, ay, 1, 20);
        }
        GuiHelper.drawBlankRect(ax + 90, ay, 1, height);
        if (!playerGui) {
            // empty if block
        }
        if (this.isMouseOver(this.buttonExitTeam)) {
            ButtonLM.DEFAULT_MOUSE_OVER.draw(this.buttonExitTeam);
        }
        if (this.isMouseOver(this.buttonTeamsGui)) {
            ButtonLM.DEFAULT_MOUSE_OVER.draw(this.buttonTeamsGui);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public IDrawableObject getIcon(IGui gui) {
        return DEFAULT_BACKGROUND;
    }

    @Override
    public int getTextColor() {
        return GuiMyTeam.DEFAULT_BACKGROUND.lineColor;
    }

    public void loadAllPlayers(Collection<MyTeamPlayerData> players) {
        for (MyTeamPlayerData d : players) {
            MyTeamPlayerData d1 = this.loadedProfiles.get(d.playerId);
            if (d1 == null) {
                this.loadedProfiles.put(d.playerId, d);
                this.teamInfo.players.add(d);
                continue;
            }
            d1.isOnline = d.isOnline;
            d1.status = d.status;
        }
        Collections.sort(this.teamInfo.players);
        this.refreshWidgets();
    }

    public void printMessage(ITeamMessage message) {
        this.teamInfo.chatHistory.add(message);
        if (this.selectedPlayer == null) {
            this.panelText.refreshWidgets();
            this.scrollText.onMoved(this);
        }
    }

    private class ButtonPlayer
    extends ButtonLM {
        private final MyTeamPlayerData playerInst;

        public ButtonPlayer(MyTeamPlayerData p) {
            super(0, 0, 86, 12);
            this.playerInst = p;
            this.setIcon(new PlayerHeadImage(p.playerName));
        }

        @Override
        public void onClicked(IGui gui, IMouseButton button) {
            GuiMyTeam.this.selectedPlayer = this.playerInst;
            GuiMyTeam.this.buttonTeamTitle.setTitle(((GuiMyTeam)GuiMyTeam.this).selectedPlayer.playerName);
            GuiMyTeam.this.scrollText.setValue(gui, 0.0);
            gui.refreshWidgets();
        }

        @Override
        public void addMouseOverText(IGui gui, List<String> list) {
        }

        @Override
        public void renderWidget(IGui gui) {
            int ax = this.getAX();
            int ay = this.getAY();
            LMColorUtils.GL_COLOR.set(ButtonPlayer.DEFAULT_BACKGROUND.lineColor);
            GuiHelper.drawBlankRect(ax, ay + this.getHeight(), this.getWidth() + 3, 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getIcon(gui).draw(ax + 2, ay + 2, 8, 8);
            gui.drawString(this.playerInst.status.getColor() + this.playerInst.playerName, ax + 12, ay + 2);
            if (GuiMyTeam.this.isMouseOver(this)) {
                ButtonLM.DEFAULT_MOUSE_OVER.draw(ax, ay, this.getWidth() + 3, this.getHeight());
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

