/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api.gui;

import com.feed_the_beast.ftbl.api.gui.IWidget;
import java.util.Collection;

public interface IPanel
extends IWidget {
    public static final int FLAG_ONLY_RENDER_WIDGETS_INSIDE = 1;
    public static final int FLAG_ONLY_INTERACT_WITH_WIDGETS_INSIDE = 2;
    public static final int FLAG_UNICODE_FONT = 4;
    public static final int FLAG_DEFAULTS = 3;

    default public void add(IWidget widget) {
        widget.setParentPanel(this);
        this.getWidgets().add(widget);
        if (widget instanceof IPanel) {
            ((IPanel)widget).refreshWidgets();
        }
    }

    default public void addAll(IWidget ... widgets) {
        for (IWidget w : widgets) {
            this.add(w);
        }
    }

    default public void addAll(Iterable<? extends IWidget> list) {
        for (IWidget iWidget : list) {
            this.add(iWidget);
        }
    }

    public Collection<IWidget> getWidgets();

    public void refreshWidgets();

    default public void updateWidgetPositions() {
    }

    public boolean hasFlag(int var1);

    public void setScrollX(int var1);

    public void setScrollY(int var1);

    default public void setScrollX(double scroll, int elementsWidth) {
        int width = this.getWidth();
        if (elementsWidth < width) {
            this.setScrollX(0);
        } else {
            this.setScrollX((int)(scroll * (double)(elementsWidth - width)));
        }
    }

    default public void setScrollY(double scroll, int elementsHeight) {
        int height = this.getHeight();
        if (elementsHeight < height) {
            this.setScrollY(0);
        } else {
            this.setScrollY((int)(scroll * (double)(elementsHeight - height)));
        }
    }
}

