/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.IWidgetMouseInput;
import com.rwtema.extrautils2.gui.backend.WidgetBase;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureManager;

public class WidgetProgressArrowBase
extends WidgetBase {
    public static final int ARROW_WIDTH = 22;
    public static final int ARROW_HEIGHT = 17;
    public static Consumer<String> setCategory = null;
    byte curWidth;

    public WidgetProgressArrowBase(int x, int y) {
        this(x, y, 0);
    }

    public WidgetProgressArrowBase(int x, int y, byte curWidth) {
        super(x, y, 22, 17);
        this.curWidth = curWidth;
    }

    @Override
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curWidth > 0 && this.curWidth != -1) {
            manager.func_110577_a(gui.getWidgetTexture());
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 98, 16, this.curWidth, 16);
        }
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        if (this.curWidth == -1) {
            manager.func_110577_a(gui.getWidgetTexture());
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 98, 32, 22, 16);
        } else if (this.curWidth < 22) {
            manager.func_110577_a(gui.getWidgetTexture());
            gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 98, 0, 22, 16);
        }
    }

    public List<String> getErrorMessage() {
        return null;
    }

    public IWidget getJEIWidget(String uid) {
        if (setCategory == null) {
            return IWidget.NULL_INSTANCE;
        }
        Runnable runnable = () -> setCategory.accept(uid);
        WidgetProgressArrowBase base = this;
        return WidgetProgressArrowBase.getJEIWidget(runnable, base);
    }

    @Nonnull
    public static IWidget getJEIWidget(final Runnable runnable, final WidgetProgressArrowBase base) {
        if (runnable == null) {
            return IWidget.NULL_INSTANCE;
        }
        return new IWidgetMouseInput(){

            @Override
            public void mouseClicked(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
                if (mouseOver && mouseButton == 0) {
                    runnable.run();
                }
            }

            @Override
            public void mouseReleased(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
            }

            @Override
            public void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastMove, boolean mouseOver) {
            }

            @Override
            public void mouseWheelScroll(int delta, boolean mouseOver) {
            }

            @Override
            public void mouseTick(int mouseX, int mouseY, boolean mouseOver) {
            }

            @Override
            public boolean usesMouseWheel() {
                return false;
            }

            @Override
            public int getX() {
                return base.getX();
            }

            @Override
            public int getY() {
                return base.getY();
            }

            @Override
            public int getW() {
                return base.getW();
            }

            @Override
            public int getH() {
                return base.getH();
            }

            @Override
            public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
            }

            @Override
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
            }

            @Override
            public void addToContainer(DynamicContainer container) {
            }

            @Override
            public List<String> getToolTip() {
                return ImmutableList.of((Object)Lang.translate(ChatFormatting.BLUE + "Click for recipes" + ChatFormatting.RESET));
            }

            @Override
            public void addToGui(DynamicGui gui) {
            }
        };
    }
}

