/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.util;

import edgarallen.mods.scf.blocks.common.BlockBaseFrame;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class CommonUtils {
    public static int getSubFrameIndex(EnumType type, EnumFacing facing, EnumPlacement placement, float hitX, float hitY, float hitZ) {
        switch (type) {
            default: {
                return 0;
            }
            case DOUBLE: {
                return CommonUtils.hitTop(facing, placement, hitX, hitY, hitZ) ? 0 : 1;
            }
            case TRIPLE: {
                return CommonUtils.hitTop(facing, placement, hitX, hitY, hitZ) ? 0 : (CommonUtils.hitLeft(facing, hitX, hitZ) ? 1 : 2);
            }
            case QUAD: 
        }
        return CommonUtils.hitTop(facing, placement, hitX, hitY, hitZ) ? (CommonUtils.hitLeft(facing, hitX, hitZ) ? 0 : 1) : (CommonUtils.hitLeft(facing, hitX, hitZ) ? 2 : 3);
    }

    private static boolean hitTop(EnumFacing facing, EnumPlacement placement, float hitX, float hitY, float hitZ) {
        switch (placement) {
            case FLOOR: {
                switch (facing) {
                    case NORTH: {
                        return hitZ < 0.5f;
                    }
                    case SOUTH: {
                        return hitZ > 0.5f;
                    }
                    case EAST: {
                        return hitX > 0.5f;
                    }
                    case WEST: {
                        return hitX < 0.5f;
                    }
                }
                return true;
            }
            case WALL: {
                return hitY > 0.5f;
            }
            case CEILING: {
                switch (facing) {
                    case NORTH: {
                        return hitZ > 0.5f;
                    }
                    case SOUTH: {
                        return hitZ < 0.5f;
                    }
                    case EAST: {
                        return hitX < 0.5f;
                    }
                    case WEST: {
                        return hitX > 0.5f;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean hitLeft(EnumFacing facing, float hitX, float hitZ) {
        switch (facing) {
            case NORTH: {
                return hitX < 0.5f;
            }
            case SOUTH: {
                return hitX > 0.5f;
            }
            case EAST: {
                return hitZ < 0.5f;
            }
            case WEST: {
                return hitZ > 0.5f;
            }
        }
        return true;
    }

    public static Vec3d getOffsetForSubFrame(EnumFacing facing, EnumPlacement placement, EnumType type, int subFrame) {
        block0 : switch (placement) {
            case FLOOR: {
                switch (facing) {
                    case NORTH: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, 0.0, subFrame == 0 ? (double)-0.1625f : (double)0.1625f);
                            }
                            case TRIPLE: {
                                return new Vec3d((double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? -0.1625f : 0.1625f)), 0.0, subFrame == 0 ? (double)-0.1625f : (double)0.1625f);
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 2 ? (double)-0.1625f : (double)0.1625f, 0.0, subFrame == 0 || subFrame == 1 ? (double)-0.1625f : (double)0.1625f);
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, 0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f);
                            }
                            case TRIPLE: {
                                return new Vec3d((double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? 0.1625f : -0.1625f)), 0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f);
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 2 ? (double)0.1625f : (double)-0.1625f, 0.0, subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f);
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d(subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0, (double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? -0.1625f : 0.1625f)));
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f, 0.0, subFrame == 0 || subFrame == 2 ? (double)-0.1625f : (double)0.1625f);
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(subFrame == 0 ? (double)-0.1625f : (double)0.1625f, 0.0, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d(subFrame == 0 ? (double)-0.1625f : (double)0.1625f, 0.0, (double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? 0.1625f : -0.1625f)));
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 1 ? (double)-0.1625f : (double)0.1625f, 0.0, subFrame == 0 || subFrame == 2 ? (double)0.1625f : (double)-0.1625f);
                            }
                        }
                    }
                }
                break;
            }
            case CEILING: {
                switch (facing) {
                    case NORTH: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, 0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f);
                            }
                            case TRIPLE: {
                                return new Vec3d((double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? -0.1625f : 0.1625f)), 0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f);
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 2 ? (double)-0.1625f : (double)0.1625f, 0.0, subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f);
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, 0.0, subFrame == 0 ? (double)-0.1625f : (double)0.1625f);
                            }
                            case TRIPLE: {
                                return new Vec3d((double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? 0.1625f : -0.1625f)), 0.0, subFrame == 0 ? (double)-0.1625f : (double)0.1625f);
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 2 ? (double)0.1625f : (double)-0.1625f, 0.0, subFrame == 0 || subFrame == 1 ? (double)-0.1625f : (double)0.1625f);
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(subFrame == 0 ? (double)-0.1625f : (double)0.1625f, 0.0, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d(subFrame == 0 ? (double)-0.1625f : (double)0.1625f, 0.0, (double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? -0.1625f : 0.1625f)));
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 1 ? (double)-0.1625f : (double)0.1625f, 0.0, subFrame == 0 || subFrame == 2 ? (double)-0.1625f : (double)0.1625f);
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d(subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0, (double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? 0.1625f : -0.1625f)));
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f, 0.0, subFrame == 0 || subFrame == 2 ? (double)0.1625f : (double)-0.1625f);
                            }
                        }
                    }
                }
                break;
            }
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d((double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? -0.1625f : 0.1625f)), subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 2 ? (double)-0.1625f : (double)0.1625f, subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                        }
                        break block0;
                    }
                    case SOUTH: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d((double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? 0.1625f : -0.1625f)), subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                            case QUAD: {
                                return new Vec3d(subFrame == 0 || subFrame == 2 ? (double)0.1625f : (double)-0.1625f, subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                        }
                        break block0;
                    }
                    case EAST: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d(0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f, (double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? -0.1625f : 0.1625f)));
                            }
                            case QUAD: {
                                return new Vec3d(0.0, subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f, subFrame == 0 || subFrame == 2 ? (double)-0.1625f : (double)0.1625f);
                            }
                        }
                        break block0;
                    }
                    case WEST: {
                        switch (type) {
                            case SINGLE: {
                                return Vec3d.field_186680_a;
                            }
                            case DOUBLE: {
                                return new Vec3d(0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f, 0.0);
                            }
                            case TRIPLE: {
                                return new Vec3d(0.0, subFrame == 0 ? (double)0.1625f : (double)-0.1625f, (double)(subFrame == 0 ? 0.0f : (subFrame == 1 ? 0.1625f : -0.1625f)));
                            }
                            case QUAD: {
                                return new Vec3d(0.0, subFrame == 0 || subFrame == 1 ? (double)0.1625f : (double)-0.1625f, subFrame == 0 || subFrame == 2 ? (double)0.1625f : (double)-0.1625f);
                            }
                        }
                    }
                }
            }
        }
        return Vec3d.field_186680_a;
    }

    public static void ejectItem(World world, BlockPos pos, int subFrame, ItemStack stack) {
        if (stack != null && stack.field_77994_a > 0) {
            Vec3d position = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Vec3d velocity = Vec3d.field_186680_a;
            IBlockState state = world.func_180495_p(pos);
            state = state.func_185899_b((IBlockAccess)world, pos);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBaseFrame.FACING);
            EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b(BlockBaseFrame.PLACEMENT));
            EnumType type = EnumType.SINGLE;
            try {
                type = (EnumType)((Object)state.func_177229_b(BlockBaseFrame.TYPE));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            block1 : switch (placement) {
                case FLOOR: {
                    position = position.func_72441_c(0.0, -0.25, 0.0);
                    velocity = velocity.func_72441_c(0.0, 0.2, 0.0);
                    break;
                }
                case CEILING: {
                    position = position.func_72441_c(0.0, -0.25, 0.0);
                    break;
                }
                case WALL: {
                    switch (facing) {
                        case NORTH: {
                            position = position.func_72441_c(0.0, -0.5, -0.25);
                            velocity = velocity.func_72441_c(0.0, 0.0, 0.2);
                            break block1;
                        }
                        case SOUTH: {
                            position = position.func_72441_c(0.0, -0.5, 0.25);
                            velocity = velocity.func_72441_c(0.0, 0.0, -0.2);
                            break block1;
                        }
                        case EAST: {
                            position = position.func_72441_c(0.25, -0.5, 0.0);
                            velocity = velocity.func_72441_c(-0.2, 0.0, 0.0);
                            break block1;
                        }
                        case WEST: {
                            position = position.func_72441_c(-0.25, -0.5, 0.0);
                            velocity = velocity.func_72441_c(0.2, 0.0, 0.0);
                        }
                    }
                }
            }
            Vec3d offset = CommonUtils.getOffsetForSubFrame(facing, placement, type, subFrame);
            position = position.func_178787_e(offset);
            EntityItem item = new EntityItem(world, position.field_72450_a, position.field_72448_b, position.field_72449_c, stack);
            item.field_70159_w = velocity.field_72450_a;
            item.field_70181_x = velocity.field_72448_b;
            item.field_70179_y = velocity.field_72449_c;
            world.func_72838_d((Entity)item);
        }
    }

    public static IItemHandler getConnectedInventory(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BlockPos offsetPos = CommonUtils.getConnectedPosition(state, pos);
        EnumFacing side = CommonUtils.getConnectedSide(state);
        return CommonUtils.getInventoryAtPosition(world, offsetPos, side);
    }

    private static IItemHandler getInventoryAtPosition(World world, BlockPos blockPos, EnumFacing side) {
        TileEntity tileEntity;
        IBlockState state = world.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state) && (tileEntity = world.func_175625_s(blockPos)).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        return EmptyHandler.INSTANCE;
    }

    private static BlockPos getConnectedPosition(IBlockState state, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBaseFrame.FACING);
        EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b(BlockBaseFrame.PLACEMENT));
        switch (placement) {
            case CEILING: {
                return pos.func_177984_a();
            }
            case FLOOR: {
                return pos.func_177977_b();
            }
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        return pos.func_177978_c();
                    }
                    case SOUTH: {
                        return pos.func_177968_d();
                    }
                    case EAST: {
                        return pos.func_177974_f();
                    }
                    case WEST: {
                        return pos.func_177976_e();
                    }
                }
            }
        }
        return BlockPos.field_177992_a;
    }

    private static EnumFacing getConnectedSide(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBaseFrame.FACING);
        EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b(BlockBaseFrame.PLACEMENT));
        switch (placement) {
            case CEILING: {
                return EnumFacing.DOWN;
            }
            case FLOOR: {
                return EnumFacing.UP;
            }
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        return EnumFacing.SOUTH;
                    }
                    case SOUTH: {
                        return EnumFacing.NORTH;
                    }
                    case EAST: {
                        return EnumFacing.WEST;
                    }
                    case WEST: {
                        return EnumFacing.EAST;
                    }
                }
            }
        }
        return EnumFacing.NORTH;
    }

    public static void renderItem(ItemStack stack, float x, float y, float z) {
        if (stack != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            if (itemRenderer.func_175050_a(stack)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    public static void setAlignmentBasedOnState(EnumFacing facing, EnumPlacement placement) {
        switch (placement) {
            case FLOOR: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.9375f);
                switch (facing) {
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                break;
            }
            case CEILING: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                switch (facing) {
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.9375f);
                break;
            }
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.9375f);
            }
        }
    }
}

