/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.network.messages;

import edgarallen.mods.scf.blocks.itemframe.TileEntityItemFrame;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageExtractItem
implements IMessage {
    private BlockPos pos;
    private boolean fullStack;
    private int subFrameIndex;

    public MessageExtractItem() {
    }

    public MessageExtractItem(BlockPos pos, int subFrameIndex, boolean fullStack) {
        this.pos = pos;
        this.fullStack = fullStack;
        this.subFrameIndex = subFrameIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.subFrameIndex = buf.readInt();
        this.fullStack = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.subFrameIndex);
        buf.writeBoolean(this.fullStack);
    }

    public static class Handler
    implements IMessageHandler<MessageExtractItem, IMessage> {
        public IMessage onMessage(MessageExtractItem message, MessageContext ctx) {
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
            if (thread.func_152345_ab()) {
                this.handle(message, ctx);
            } else {
                thread.func_152344_a(() -> this.handle(message, ctx));
            }
            return null;
        }

        private void handle(MessageExtractItem message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_175625_s(message.pos);
            if (te != null && te instanceof TileEntityItemFrame) {
                TileEntityItemFrame tile = (TileEntityItemFrame)te;
                if (message.fullStack) {
                    tile.extractStack(message.subFrameIndex);
                } else {
                    tile.extractItem(message.subFrameIndex);
                }
            }
        }
    }
}

