/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe.nbt;

import edgarallen.mods.scf.util.EnumType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TeleportationFrameNBTWriter {
    public static void writeToNBT(EnumType type, ItemStack[] destinations, NBTTagCompound compound) {
        NBTTagList frameTagList = new NBTTagList();
        NBTTagCompound rootCompound = new NBTTagCompound();
        TeleportationFrameNBTWriter.writeVersionToNBT(rootCompound);
        TeleportationFrameNBTWriter.writeTypeToNBT(type, rootCompound);
        TeleportationFrameNBTWriter.writeDestinationsToNBT(destinations, rootCompound);
        frameTagList.func_74742_a((NBTBase)rootCompound);
        compound.func_74782_a("tpFrame", (NBTBase)frameTagList);
    }

    private static void writeVersionToNBT(NBTTagCompound compound) {
        compound.func_74774_a("version", (byte)1);
    }

    private static void writeTypeToNBT(EnumType type, NBTTagCompound compound) {
        compound.func_74774_a("type", (byte)type.getIndex());
    }

    private static void writeDestinationsToNBT(ItemStack[] destinations, NBTTagCompound rootCompound) {
        NBTTagList filtersTagList = new NBTTagList();
        for (int i = 0; i < destinations.length; ++i) {
            ItemStack stack = destinations[i];
            if (stack == null) continue;
            NBTTagCompound filterCompound = new NBTTagCompound();
            filterCompound.func_74774_a("index", (byte)i);
            TeleportationFrameNBTWriter.writeItemStackToNBT(stack, filterCompound);
            filtersTagList.func_74742_a((NBTBase)filterCompound);
        }
        rootCompound.func_74782_a("destinations", (NBTBase)filtersTagList);
    }

    public static void writeItemStackToNBT(ItemStack stack, NBTTagCompound compound) {
        NBTTagList itemRoot = new NBTTagList();
        NBTTagCompound itemCompound = new NBTTagCompound();
        stack.func_77955_b(itemCompound);
        itemRoot.func_74742_a((NBTBase)itemCompound);
        compound.func_74782_a("destination", (NBTBase)itemRoot);
    }
}

