/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe;

import edgarallen.mods.scf.blocks.common.BlockBaseFrame;
import edgarallen.mods.scf.blocks.teleportationframe.TileEntityTeleportationFrame;
import edgarallen.mods.scf.blocks.teleportationframe.TileEntityTeleportationFrameRenderer;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.TeleportationFrameNBTReader;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.TeleportationFrameNBTWriter;
import edgarallen.mods.scf.blocks.teleportationframe.recipes.TeleportationFrameShapelessRecipe;
import edgarallen.mods.scf.items.ModItems;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;

public class BlockTeleportationFrame
extends BlockBaseFrame
implements ITileEntityProvider {
    public static final String NAME = "super_teleportation_frame";

    public BlockTeleportationFrame() {
        super(Material.field_151575_d);
        this.func_149663_c(NAME);
        this.setRegistryName(NAME);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.registerTileEntity(TileEntityTeleportationFrame.class, (String)NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.teleportationFrameItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTeleportationFrame.class, (TileEntitySpecialRenderer)new TileEntityTeleportationFrameRenderer());
    }

    public void registerRecipes() {
        RecipeSorter.register((String)"supercraftingframe:teleportation_shapeless", TeleportationFrameShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this, 1), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), Items.field_151079_bi});
        ArrayList<Object> ingredients = new ArrayList<ItemStack>();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 1), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 2), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 2), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 2));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 1));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new TeleportationFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityTeleportationFrame) {
            TileEntityTeleportationFrame tileFrame = (TileEntityTeleportationFrame)tile;
            if (stack.func_77942_o()) {
                TeleportationFrameNBTReader.readFromNBT(tileFrame, stack.func_77978_p());
            } else {
                EnumType type = EnumType.getType(stack.func_77960_j());
                tileFrame.initFrame(type);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileEntityTeleportationFrame tile = (TileEntityTeleportationFrame)worldIn.func_175625_s(pos);
            EnumType type = tile.getType();
            int subframeIndex = CommonUtils.getSubFrameIndex(type, (EnumFacing)state.func_177229_b((IProperty)FACING), (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT)), hitX, hitY, hitZ);
            if (playerIn.func_70093_af() && heldItem == null) {
                tile.removeDestination(subframeIndex);
            } else if (!tile.setDestinationAndUpdate(heldItem, subframeIndex)) {
                tile.teleportPlayer(worldIn, playerIn, subframeIndex);
            }
        }
        return true;
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityTeleportationFrame tile;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntityTeleportationFrame tileEntityTeleportationFrame = tile = world.func_175625_s(pos) instanceof TileEntityTeleportationFrame ? (TileEntityTeleportationFrame)world.func_175625_s(pos) : null;
        if (tile != null) {
            int meta = tile.getType().ordinal();
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, meta);
            if (tile.areAnyDestinationsSet()) {
                NBTTagCompound compound = new NBTTagCompound();
                TeleportationFrameNBTWriter.writeToNBT(tile.getType(), tile.getDestinations(), compound);
                stack.func_77982_d(compound);
            }
            list.add(stack);
        }
        return list;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTeleportationFrame();
    }
}

