/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.itemframe.nbt;

import edgarallen.mods.scf.util.EnumType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemFrameNBTWriter {
    public static void writeToNBT(EnumType type, ItemStack[] filters, NBTTagCompound compound) {
        NBTTagList itemFrameTagList = new NBTTagList();
        NBTTagCompound rootCompound = new NBTTagCompound();
        ItemFrameNBTWriter.writeVersionToNBT(rootCompound);
        ItemFrameNBTWriter.writeTypeToNBT(type, rootCompound);
        ItemFrameNBTWriter.writeFiltersToNBT(filters, rootCompound);
        itemFrameTagList.func_74742_a((NBTBase)rootCompound);
        compound.func_74782_a("itemFrame", (NBTBase)itemFrameTagList);
    }

    private static void writeVersionToNBT(NBTTagCompound compound) {
        compound.func_74774_a("version", (byte)1);
    }

    private static void writeTypeToNBT(EnumType type, NBTTagCompound compound) {
        compound.func_74774_a("type", (byte)type.getIndex());
    }

    private static void writeFiltersToNBT(ItemStack[] filters, NBTTagCompound rootCompound) {
        NBTTagList filtersTagList = new NBTTagList();
        for (int i = 0; i < filters.length; ++i) {
            ItemStack stack = filters[i];
            if (stack == null) continue;
            NBTTagCompound filterCompound = new NBTTagCompound();
            filterCompound.func_74774_a("index", (byte)i);
            ItemFrameNBTWriter.writeItemStackToNBT(stack, filterCompound);
            filtersTagList.func_74742_a((NBTBase)filterCompound);
        }
        rootCompound.func_74782_a("filters", (NBTBase)filtersTagList);
    }

    public static void writeItemStackToNBT(ItemStack stack, NBTTagCompound compound) {
        NBTTagList itemRoot = new NBTTagList();
        NBTTagCompound itemCompound = new NBTTagCompound();
        stack.func_77955_b(itemCompound);
        itemRoot.func_74742_a((NBTBase)itemCompound);
        compound.func_74782_a("item", (NBTBase)itemRoot);
    }
}

