/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe;

import edgarallen.mods.scf.blocks.common.BlockBaseFrame;
import edgarallen.mods.scf.blocks.common.TileEntityBaseFrame;
import edgarallen.mods.scf.blocks.craftingframe.TileEntityCraftingFrame;
import edgarallen.mods.scf.blocks.craftingframe.TileEntityCraftingFrameRenderer;
import edgarallen.mods.scf.blocks.craftingframe.core.PlayerInteractAction;
import edgarallen.mods.scf.blocks.craftingframe.nbt.CraftingFrameNBTReader;
import edgarallen.mods.scf.blocks.craftingframe.nbt.CraftingFrameNBTWriter;
import edgarallen.mods.scf.blocks.craftingframe.recipes.CraftingFrameShapelessRecipe;
import edgarallen.mods.scf.config.Config;
import edgarallen.mods.scf.items.ModItems;
import edgarallen.mods.scf.network.ThePacketeer;
import edgarallen.mods.scf.network.messages.MessageCraftItem;
import edgarallen.mods.scf.network.messages.MessageInstantBreak;
import edgarallen.mods.scf.network.messages.MessageOpenRecipeGui;
import edgarallen.mods.scf.util.CommonUtils;
import edgarallen.mods.scf.util.EnumPlacement;
import edgarallen.mods.scf.util.EnumType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;

public class BlockCraftingFrame
extends BlockBaseFrame
implements ITileEntityProvider {
    public static final String NAME = "super_crafting_frame";

    public BlockCraftingFrame() {
        super(Material.field_151575_d);
        this.func_149663_c(NAME);
        this.setRegistryName(NAME);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.registerTileEntity(TileEntityCraftingFrame.class, (String)NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)ModItems.craftingFrameItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCraftingFrame.class, (TileEntitySpecialRenderer)new TileEntityCraftingFrameRenderer());
    }

    public void registerRecipes() {
        RecipeSorter.register((String)"supercraftingframe:crafting_shapeless", CraftingFrameShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this, 1, 0), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), Blocks.field_150462_ai});
        ArrayList<Object> ingredients = new ArrayList<ItemStack>();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 1), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 2), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 2), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 0));
        ingredients.add(new ItemStack((Block)this, 1, 2));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        ingredients = new ArrayList();
        ingredients.add(new ItemStack((Block)this, 1, 1));
        ingredients.add(new ItemStack((Block)this, 1, 1));
        GameRegistry.addRecipe((IRecipe)new CraftingFrameShapelessRecipe(new ItemStack((Block)this, 1, 3), ingredients));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 0), (Object[])new Object[]{new ItemStack((Block)this, 1, 0)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 1), (Object[])new Object[]{new ItemStack((Block)this, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 2), (Object[])new Object[]{new ItemStack((Block)this, 1, 2)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this, 1, 3), (Object[])new Object[]{new ItemStack((Block)this, 1, 3)});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityCraftingFrame) {
            TileEntityCraftingFrame tileFrame = (TileEntityCraftingFrame)te;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("craftingFrame")) {
                CraftingFrameNBTReader.readFromNBT(tileFrame, stack.func_77978_p());
            } else {
                EnumType type = EnumType.getType(stack.func_77960_j());
                tileFrame.initFrame(type);
            }
        }
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            RayTraceResult ray = Minecraft.func_71410_x().field_71476_x;
            BlockPos hitPos = ray.func_178782_a();
            float hitX = (float)(ray.field_72307_f.field_72450_a - (double)hitPos.func_177958_n());
            float hitY = (float)(ray.field_72307_f.field_72448_b - (double)hitPos.func_177956_o());
            float hitZ = (float)(ray.field_72307_f.field_72449_c - (double)hitPos.func_177952_p());
            IBlockState state = worldIn.func_180495_p(pos);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            EnumPlacement placement = (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT));
            TileEntityBaseFrame tile = (TileEntityBaseFrame)worldIn.func_175625_s(pos);
            EnumType type = tile.getType();
            if (playerIn.func_70093_af()) {
                this.performBlockClickAction(Config.craftingFrameSneakLeftClickAction, pos, CommonUtils.getSubFrameIndex(type, facing, placement, hitX, hitY, hitZ));
            } else {
                this.performBlockClickAction(Config.craftingFrameLeftClickAction, pos, CommonUtils.getSubFrameIndex(type, facing, placement, hitX, hitY, hitZ));
            }
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            TileEntityCraftingFrame tile = (TileEntityCraftingFrame)worldIn.func_175625_s(pos);
            EnumType type = tile.getType();
            if (playerIn.func_70093_af()) {
                this.performBlockClickAction(Config.craftingFrameSneakRightClickAction, pos, CommonUtils.getSubFrameIndex(type, (EnumFacing)state.func_177229_b((IProperty)FACING), (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT)), hitX, hitY, hitZ));
            } else {
                this.performBlockClickAction(Config.craftingFrameRightClickAction, pos, CommonUtils.getSubFrameIndex(type, (EnumFacing)state.func_177229_b((IProperty)FACING), (EnumPlacement)((Object)state.func_177229_b((IProperty)PLACEMENT)), hitX, hitY, hitZ));
            }
        }
        return true;
    }

    private void performBlockClickAction(PlayerInteractAction action, BlockPos pos, int subFrameIndex) {
        switch (action) {
            case OPEN_GUI: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageOpenRecipeGui(pos, subFrameIndex));
                break;
            }
            case CRAFT_ITEM: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageCraftItem(pos, subFrameIndex, false));
                break;
            }
            case CRAFT_STACK: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageCraftItem(pos, subFrameIndex, true));
                break;
            }
            case INSTANT_BREAK: {
                ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageInstantBreak(pos));
                break;
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityCraftingFrame tileFrame;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntityCraftingFrame tileEntityCraftingFrame = tileFrame = world.func_175625_s(pos) instanceof TileEntityCraftingFrame ? (TileEntityCraftingFrame)world.func_175625_s(pos) : null;
        if (tileFrame != null) {
            int meta = tileFrame.getType().ordinal();
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, meta);
            if (tileFrame.areAnySubFramesSet()) {
                NBTTagCompound compound = new NBTTagCompound();
                CraftingFrameNBTWriter.writeToNBT(tileFrame.getType(), tileFrame.getSubFrames(), compound);
                if (!compound.func_82582_d()) {
                    stack.func_77982_d(compound);
                }
            }
            list.add(stack);
        }
        return list;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCraftingFrame();
    }
}

