/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotContainer;
import ic2.core.block.invslot.InvSlotCrafting;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.container.ContainerBatchCrafter;
import ic2.core.block.machine.gui.GuiBatchCrafter;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import ic2.core.util.StackUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBatchCrafter
extends TileEntityElectricMachine
implements IHasGui,
IUpgradableBlock,
IGuiValueProvider {
    protected static final Set<UpgradableProperty> UPGRADES = EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing);
    public static final int defaultTier = 1;
    public static final int defaultEnergyConsume = 2;
    public static final int defaultOperationLength = 40;
    public static final int defaultEnergyStorage = 20000;
    public final InvSlotCrafting craftingGrid = new InvSlotCrafting(this, InvSlot.Access.I);
    public final InvSlotOutput craftingOutput = new InvSlotOutput((TileEntityInventory)this, "output", 1, InvSlot.InvSide.SIDE);
    public final InvSlotOutput containerOutput = new InvSlotOutput((TileEntityInventory)this, "containersOut", 9, InvSlot.InvSide.NOTSIDE);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, "upgrade", 4);
    public int energyConsume = 2;
    public int operationLength = 40;
    public int operationsPerTick = 1;
    protected short progress = 0;
    protected float guiProgress = 0.0f;

    public TileEntityBatchCrafter() {
        super(20000, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("progress", this.progress);
        return nbt;
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        if (!this.func_145831_w().field_72995_K) {
            this.setOverclockRates();
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (!this.func_145831_w().field_72995_K) {
            this.setOverclockRates();
        }
    }

    @Override
    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.craftingGrid.shouldCraft() && this.craftingOutput.canAdd(this.craftingGrid.getRecipeOutput()) && this.energy.useEnergy(this.energyConsume)) {
            this.setActive(true);
            this.progress = (short)(this.progress + 1);
            if (this.progress >= this.operationLength) {
                this.doCrafting();
                needsInvUpdate = true;
                this.craftingGrid.skipNextHash();
                this.progress = 0;
            }
        } else {
            if (!this.craftingGrid.hasValidRecipe()) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        for (ItemStack stack : this.upgradeSlot) {
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
            needsInvUpdate |= ((IUpgradeItem)stack.func_77973_b()).onTick(stack, this);
        }
        this.guiProgress = (float)this.progress / (float)this.operationLength;
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    protected void doCrafting() {
        for (int operation = 0; operation < this.operationsPerTick; ++operation) {
            List<ItemStack> outputs = Collections.singletonList(this.craftingGrid.getRecipeOutput());
            for (ItemStack stack : this.upgradeSlot) {
                if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem)) continue;
                ((IUpgradeItem)stack.func_77973_b()).onProcessEnd(stack, this, outputs);
            }
            this.craftingGrid.skipAllHash();
            this.craft();
            this.craftingGrid.watchHash();
            if (!this.craftingGrid.hasValidRecipe() || !this.craftingOutput.canAdd(this.craftingGrid.getRecipeOutput())) break;
        }
    }

    protected void craft() {
        assert (this.craftingOutput.canAdd(this.craftingGrid.getRecipeOutput()));
        this.craftingOutput.add(this.craftingGrid.getRecipeOutput());
        ItemStack[] stacks = this.craftingGrid.getRecipeOutputRemains();
        World world = this.func_145831_w();
        for (int slot = 0; slot < stacks.length; ++slot) {
            boolean isContainer;
            ItemStack oldStack = this.craftingGrid.get(slot);
            ItemStack newStack = stacks[slot];
            boolean bl = isContainer = newStack != null && InvSlotContainer.isSingleContainer(newStack);
            if (oldStack != null && !isContainer) {
                this.craftingGrid.stackSyntheticClone.func_70298_a(slot, 1);
                oldStack = this.craftingGrid.get(slot);
            }
            if (newStack == null) continue;
            if (oldStack != null && !isContainer && StackUtil.checkItemEqualityStrict(oldStack, newStack)) {
                newStack.field_77994_a += oldStack.field_77994_a;
                this.craftingGrid.stackSyntheticClone.func_70299_a(slot, newStack);
                continue;
            }
            if (isContainer) {
                this.craftingGrid.stackSyntheticClone.func_70299_a(slot, newStack);
                continue;
            }
            if (this.containerOutput.canAdd(newStack)) {
                this.containerOutput.add(newStack);
                continue;
            }
            StackUtil.dropAsEntity(world, this.field_174879_c, newStack);
        }
    }

    @Override
    protected int getComparatorInputOverride() {
        return this.progress * 15 / this.operationLength;
    }

    protected void setOverclockRates() {
        this.upgradeSlot.onChanged();
        double previousProgress = (double)this.progress / (double)this.operationLength;
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(40);
        this.operationLength = this.upgradeSlot.getOperationLength(40);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(2);
        int tier = this.upgradeSlot.getTier(1);
        this.energy.setSinkTier(tier);
        this.dischargeSlot.setTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(20000, 40, 2));
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return UPGRADES;
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        return this.energy.useEnergy(amount);
    }

    public ContainerBase<TileEntityBatchCrafter> getGuiContainer(EntityPlayer player) {
        return new ContainerBatchCrafter(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiBatchCrafter(new ContainerBatchCrafter(player, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public double getGuiValue(String name) {
        if ("progress".equals(name)) {
            return this.guiProgress;
        }
        throw new IllegalArgumentException("Unexpected value requested: " + name);
    }
}

