/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeWrapper;

public class AlloyRecipeCategory
implements IRecipeCategory<AlloyRecipeWrapper> {
    public static String CATEGORY = Util.prefix("alloy");
    public static ResourceLocation background_loc = Util.getResource("textures/gui/jei/smeltery.png");
    protected final IDrawable background;
    protected final IDrawableAnimated arrow;

    public AlloyRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(background_loc, 0, 60, 160, 60);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(background_loc, 160, 60, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return CATEGORY;
    }

    @Nonnull
    public String getTitle() {
        return Util.translate("gui.jei.alloy.title", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 76, 22);
    }

    @Deprecated
    public void setRecipe(IRecipeLayout recipeLayout, AlloyRecipeWrapper recipeWrapper) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlloyRecipeWrapper recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        List<FluidStack> inputs = recipe.inputs;
        List outputs = ingredients.getOutputs(FluidStack.class);
        float w = 36.0f / (float)inputs.size();
        int max_amount = 0;
        for (FluidStack fs : inputs) {
            if (fs.amount <= max_amount) continue;
            max_amount = fs.amount;
        }
        for (FluidStack fs : outputs) {
            if (fs.amount <= max_amount) continue;
            max_amount = fs.amount;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            int x = 21 + (int)((float)i * w);
            int _w = (int)((float)(i + 1) * w - (float)i * w);
            fluids.init(i + 1, true, x, 11, _w, 32, max_amount, false, null);
        }
        fluids.init(0, false, 118, 11, 18, 32, max_amount, false, null);
        fluids.set(ingredients);
    }

    public IDrawable getIcon() {
        return null;
    }
}

