/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.IConfigCardAccess;
import mekanism.api.Range4D;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.PacketHandler;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityOredictionificator
extends TileEntityContainerBlock
implements IRedstoneControl,
IConfigCardAccess.ISpecialConfigData,
ISustainedData,
ISecurityTile {
    public static final int MAX_LENGTH = 24;
    public HashList<OredictionificatorFilter> filters = new HashList();
    public static List<String> possibleFilters = Arrays.asList("ingot", "ore", "dust", "nugget");
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public boolean didProcess;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityOredictionificator() {
        super(BlockStateMachine.MachineType.OREDICTIONIFICATOR.machineName);
        this.inventory = new ItemStack[2];
        this.doAutoSync = false;
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getGenericPacket(new ArrayList<Object>())), (EntityPlayerMP)player);
                }
            }
            this.didProcess = false;
            if (MekanismUtils.canFunction(this) && this.inventory[0] != null && this.getValidName(this.inventory[0]) != null && (result = this.getResult(this.inventory[0])) != null) {
                if (this.inventory[1] == null) {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                    this.inventory[1] = result;
                    this.didProcess = true;
                } else if (this.inventory[1].func_77969_a(result) && this.inventory[1].field_77994_a < this.inventory[1].func_77976_d()) {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                    ++this.inventory[1].field_77994_a;
                    this.didProcess = true;
                }
                this.func_70296_d();
            }
        }
    }

    public String getValidName(ItemStack stack) {
        List<String> def = OreDictCache.getOreDictName(stack);
        for (String s : def) {
            for (String pre : possibleFilters) {
                if (!s.startsWith(pre)) continue;
                return s;
            }
        }
        return null;
    }

    public ItemStack getResult(ItemStack stack) {
        String s = this.getValidName(stack);
        if (s == null) {
            return null;
        }
        List ores = OreDictionary.getOres((String)s);
        for (OredictionificatorFilter filter : this.filters) {
            if (!filter.filter.equals(s)) continue;
            if (ores.size() - 1 >= filter.index) {
                return MekanismUtils.size((ItemStack)ores.get(filter.index), 1);
            }
            return null;
        }
        return null;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{1};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 1;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && this.getResult(itemstack) != null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        NBTTagList filterTags = new NBTTagList();
        for (OredictionificatorFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        block2: {
            int type;
            block4: {
                block3: {
                    super.handlePacketData(dataStream);
                    if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) break block2;
                    type = dataStream.readInt();
                    if (type != 0) break block3;
                    this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                    this.didProcess = dataStream.readBoolean();
                    this.filters.clear();
                    int amount = dataStream.readInt();
                    for (int i = 0; i < amount; ++i) {
                        this.filters.add(OredictionificatorFilter.readFromPacket(dataStream));
                    }
                    break block2;
                }
                if (type != 1) break block4;
                this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
                this.didProcess = dataStream.readBoolean();
                break block2;
            }
            if (type != 2) break block2;
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(OredictionificatorFilter.readFromPacket(dataStream));
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.controlType.ordinal());
        data.add(this.didProcess);
        data.add(this.filters.size());
        for (OredictionificatorFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public ArrayList getGenericPacket(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.controlType.ordinal());
        data.add(this.didProcess);
        return data;
    }

    public ArrayList getFilterPacket(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (OredictionificatorFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getFilterPacket(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        }
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        NBTTagList filterTags = new NBTTagList();
        for (OredictionificatorFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setBoolean(itemStack, "hasOredictionificatorConfig", true);
        NBTTagList filterTags = new NBTTagList();
        for (OredictionificatorFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "hasOredictionificatorConfig") && ItemDataUtils.hasData(itemStack, "filters")) {
            NBTTagList tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(OredictionificatorFilter.readFromNBT(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIG_CARD_CAPABILITY || capability == Capabilities.SPECIAL_CONFIG_DATA_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    public static class OredictionificatorFilter {
        public String filter;
        public int index;

        public void write(NBTTagCompound nbtTags) {
            nbtTags.func_74778_a("filter", this.filter);
            nbtTags.func_74768_a("index", this.index);
        }

        protected void read(NBTTagCompound nbtTags) {
            this.filter = nbtTags.func_74779_i("filter");
            this.index = nbtTags.func_74762_e("index");
        }

        public void write(ArrayList<Object> data) {
            data.add(this.filter);
            data.add(this.index);
        }

        protected void read(ByteBuf dataStream) {
            this.filter = PacketHandler.readString(dataStream);
            this.index = dataStream.readInt();
        }

        public static OredictionificatorFilter readFromNBT(NBTTagCompound nbtTags) {
            OredictionificatorFilter filter = new OredictionificatorFilter();
            filter.read(nbtTags);
            return filter;
        }

        public static OredictionificatorFilter readFromPacket(ByteBuf dataStream) {
            OredictionificatorFilter filter = new OredictionificatorFilter();
            filter.read(dataStream);
            return filter;
        }

        public OredictionificatorFilter clone() {
            OredictionificatorFilter newFilter = new OredictionificatorFilter();
            newFilter.filter = this.filter;
            newFilter.index = this.index;
            return newFilter;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.filter.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof OredictionificatorFilter && ((OredictionificatorFilter)obj).filter.equals(this.filter);
        }
    }
}

