/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Pos3D;
import mekanism.api.util.StackUtils;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityFlame
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int LIFESPAN = 80;
    public static final int DAMAGE = 10;
    public Entity owner = null;
    public ItemFlamethrower.FlamethrowerMode mode = ItemFlamethrower.FlamethrowerMode.COMBAT;

    public EntityFlame(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFlame(EntityPlayer player) {
        this(player.field_70170_p);
        Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.6, 0.0);
        Pos3D flameVec = new Pos3D(1.0, 1.0, 1.0);
        flameVec = flameVec.multiply(new Pos3D(player.func_70040_Z())).rotateYaw(6.0f);
        Pos3D mergedVec = playerPos.translate(flameVec);
        this.func_70107_b(mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c);
        Pos3D motion = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(player.func_70040_Z()));
        this.setHeading(motion);
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
        this.owner = player;
        this.mode = ((ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b()).getMode(player.field_71071_by.func_70448_g());
    }

    public void setHeading(Pos3D motion) {
        float d = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motion.field_72450_a, motion.field_72449_c) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motion.field_72448_b, d) * 180.0 / Math.PI);
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        ++this.field_70173_aa;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.calculateVector();
        if (this.field_70173_aa > 80) {
            this.func_70106_y();
            return;
        }
    }

    private void calculateVector() {
        Vec3d localVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d motionVec = new Vec3d(this.field_70165_t + this.field_70159_w * 2.0, this.field_70163_u + this.field_70181_x * 2.0, this.field_70161_v + this.field_70179_y * 2.0);
        RayTraceResult mop = this.field_70170_p.func_147447_a(localVec, motionVec, true, false, false);
        localVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        motionVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (mop != null) {
            motionVec = new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double entityDist = 0.0;
        for (Entity entity1 : list) {
            double dist;
            if (!(entity1 instanceof EntityItem) && !entity1.func_70067_L() || entity1 == this.owner) continue;
            float boundsScale = 0.3f;
            AxisAlignedBB newBounds = entity1.func_174813_aQ().func_72314_b((double)boundsScale, (double)boundsScale, (double)boundsScale);
            RayTraceResult RayTraceResult1 = newBounds.func_72327_a(localVec, motionVec);
            if (RayTraceResult1 == null || !((dist = localVec.func_72438_d(RayTraceResult1.field_72307_f)) < entityDist) && entityDist != 0.0) continue;
            entity = entity1;
            entityDist = dist;
        }
        if (entity != null) {
            mop = new RayTraceResult(entity);
        }
        if (mop != null && mop.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)mop.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.owner instanceof EntityPlayer && !((EntityPlayer)this.owner).func_96122_a(entityplayer)) {
                mop = null;
            }
        }
        if (mop != null) {
            if (mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g != null && !mop.field_72308_g.func_70045_F()) {
                if (mop.field_72308_g instanceof EntityItem && this.mode != ItemFlamethrower.FlamethrowerMode.COMBAT) {
                    if (mop.field_72308_g.field_70173_aa > 100 && !this.smeltItem((EntityItem)mop.field_72308_g)) {
                        this.burn(mop.field_72308_g);
                    }
                } else {
                    this.burn(mop.field_72308_g);
                }
            } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState state = this.field_70170_p.func_180495_p(mop.func_178782_a());
                Block block = state.func_177230_c();
                boolean fluid = MekanismUtils.isFluid(this.field_70170_p, new Coord4D(mop, this.field_70170_p)) || MekanismUtils.isDeadFluid(this.field_70170_p, new Coord4D(mop, this.field_70170_p));
                Coord4D sideCoord = new Coord4D(mop.func_178782_a().func_177972_a(mop.field_178784_b), this.field_70170_p);
                if (MekanismConfig.general.aestheticWorldDamage && !fluid && (sideCoord.isAirBlock((IBlockAccess)this.field_70170_p) || sideCoord.isReplaceable(this.field_70170_p)) && this.mode != ItemFlamethrower.FlamethrowerMode.COMBAT && !this.smeltBlock(new Coord4D(mop, this.field_70170_p)) && this.mode == ItemFlamethrower.FlamethrowerMode.INFERNO && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_175656_a(sideCoord.getPos(), Blocks.field_150480_ab.func_176223_P());
                }
                if (fluid) {
                    this.spawnParticlesAt(new Pos3D(this));
                    this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
                }
            }
            this.func_70106_y();
        }
    }

    private boolean smeltItem(EntityItem item) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(item.func_92059_d());
        if (result != null) {
            item.func_92058_a(StackUtils.size(result, item.func_92059_d().field_77994_a));
            item.field_70173_aa = 0;
            this.spawnParticlesAt(new Pos3D((Entity)item));
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private boolean smeltBlock(Coord4D block) {
        ItemStack stack = block.getStack((IBlockAccess)this.field_70170_p);
        if (stack == null) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(block.getStack((IBlockAccess)this.field_70170_p));
        if (result != null && result.func_77973_b() != null) {
            if (!this.field_70170_p.field_72995_K) {
                IBlockState state = block.getBlockState((IBlockAccess)this.field_70170_p);
                Block b = state.func_177230_c();
                Block newBlock = Block.func_149634_a((Item)result.func_77973_b());
                if (newBlock != null && newBlock != Blocks.field_150350_a) {
                    this.field_70170_p.func_180501_a(block.getPos(), Block.func_149634_a((Item)result.func_77973_b()).func_176203_a(result.func_77952_i()), 3);
                } else {
                    this.field_70170_p.func_175698_g(block.getPos());
                    EntityItem item = new EntityItem(this.field_70170_p, (double)block.xCoord + 0.5, (double)block.yCoord + 0.5, (double)block.zCoord + 0.5, result.func_77946_l());
                    item.field_70159_w = 0.0;
                    item.field_70181_x = 0.0;
                    item.field_70179_y = 0.0;
                    this.field_70170_p.func_72838_d((Entity)item);
                }
                this.field_70170_p.func_180498_a(null, 2001, block.getPos(), Block.func_176210_f((IBlockState)state));
            }
            this.spawnParticlesAt(new Pos3D(block).translate(0.5, 0.5, 0.5));
            return true;
        }
        return false;
    }

    private void burn(Entity entity) {
        entity.func_70015_d(20);
        entity.func_70097_a(this.getFlamethrowerDamage(), 10.0f);
    }

    private DamageSource getFlamethrowerDamage() {
        if (this.owner == null) {
            return DamageSource.func_76356_a((Entity)this, (Entity)this);
        }
        return DamageSource.func_76356_a((Entity)this, (Entity)this.owner);
    }

    private void spawnParticlesAt(Pos3D pos) {
        for (int i = 0; i < 10; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, pos.field_72450_a + ((double)this.field_70146_Z.nextFloat() - 0.5), pos.field_72448_b + ((double)this.field_70146_Z.nextFloat() - 0.5), pos.field_72449_c + ((double)this.field_70146_Z.nextFloat() - 0.5), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbtTags) {
        this.mode = ItemFlamethrower.FlamethrowerMode.values()[nbtTags.func_74762_e("mode")];
    }

    protected void func_70014_b(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("mode", this.mode.ordinal());
    }

    public void writeSpawnData(ByteBuf dataStream) {
        dataStream.writeInt(this.mode.ordinal());
    }

    public void readSpawnData(ByteBuf dataStream) {
        this.mode = ItemFlamethrower.FlamethrowerMode.values()[dataStream.readInt()];
    }
}

