/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.awt.Rectangle;
import java.util.List;
import mekanism.api.ObfuscatedNames;
import mekanism.api.util.ReflectionUtils;
import mekanism.client.gui.IGuiWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiElement {
    public static Minecraft mc = Minecraft.func_71410_x();
    public ResourceLocation RESOURCE;
    public IGuiWrapper guiObj;
    public ResourceLocation defaultLocation;

    public GuiElement(ResourceLocation resource, IGuiWrapper gui, ResourceLocation def) {
        this.RESOURCE = resource;
        this.guiObj = gui;
        this.defaultLocation = def;
    }

    public void displayTooltip(String s, int xAxis, int yAxis) {
        this.guiObj.displayTooltip(s, xAxis, yAxis);
    }

    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
        this.guiObj.displayTooltips(list, xAxis, yAxis);
    }

    public void offsetX(int xSize) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int size = (Integer)ReflectionUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_xSize);
                ReflectionUtils.setPrivateValue(this.guiObj, size + xSize, GuiContainer.class, ObfuscatedNames.GuiContainer_xSize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void offsetY(int ySize) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int size = (Integer)ReflectionUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_ySize);
                ReflectionUtils.setPrivateValue(this.guiObj, size + ySize, GuiContainer.class, ObfuscatedNames.GuiContainer_ySize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void offsetLeft(int guiLeft) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int left = (Integer)ReflectionUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
                System.out.println(left + " " + guiLeft);
                ReflectionUtils.setPrivateValue(this.guiObj, left + guiLeft, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void offsetTop(int guiTop) {
        if (this.guiObj instanceof GuiContainer) {
            try {
                int top = (Integer)ReflectionUtils.getPrivateValue(this.guiObj, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
                ReflectionUtils.setPrivateValue(this.guiObj, top + guiTop, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.getFontRenderer().func_78256_a(text);
        if (length <= maxX) {
            this.getFontRenderer().func_78276_b(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.getFontRenderer().func_78276_b(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            GlStateManager.func_179121_F();
        }
    }

    public FontRenderer getFontRenderer() {
        return this.guiObj.getFont();
    }

    public void mouseClickMove(int mouseX, int mouseY, int button, long ticks) {
    }

    public void mouseReleased(int x, int y, int type) {
    }

    public abstract Rectangle4i getBounds(int var1, int var2);

    public abstract void renderBackground(int var1, int var2, int var3, int var4);

    public abstract void renderForeground(int var1, int var2);

    public abstract void preMouseClicked(int var1, int var2, int var3);

    public abstract void mouseClicked(int var1, int var2, int var3);

    public static class Rectangle4i {
        public int x;
        public int y;
        public int width;
        public int height;

        public Rectangle4i(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
    }

    public static interface IInfoHandler {
        public List<String> getInfo();
    }
}

