/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ListUtils {
    public static <V> List<V> inverse(List<V> list) {
        ArrayList<V> toReturn = new ArrayList<V>();
        for (int i = list.size() - 1; i >= 0; --i) {
            toReturn.add(list.get(i));
        }
        return toReturn;
    }

    public static <V> List<V> cap(List<V> list, int cap) {
        List<Object> toReturn = new ArrayList();
        if (list.size() <= cap) {
            toReturn = ListUtils.copy(list);
        } else {
            int count = 0;
            for (V obj : list) {
                toReturn.add(obj);
                if (++count != cap) continue;
                break;
            }
        }
        return toReturn;
    }

    public static <V> List<V> copy(List<V> list) {
        ArrayList<V> toReturn = new ArrayList<V>();
        for (V obj : list) {
            toReturn.add(obj);
        }
        return toReturn;
    }

    public static <V> List<V> merge(List<V> listOne, List<V> listTwo) {
        ArrayList<V> newList = new ArrayList<V>();
        for (V obj : listOne) {
            newList.add(obj);
        }
        for (V obj : listTwo) {
            newList.add(obj);
        }
        return newList;
    }

    public static <V> List<V> capRemains(List<V> list, int cap) {
        ArrayList<V> toReturn = new ArrayList<V>();
        if (list.size() <= cap) {
            return toReturn;
        }
        List<V> inverse = ListUtils.inverse(list);
        int iterNeeded = list.size() - cap;
        int count = 0;
        for (V obj : list) {
            toReturn.add(obj);
            if (++count != iterNeeded) continue;
            break;
        }
        return toReturn;
    }

    public static <V> ArrayList<List<V>> split(List<V> list, int divide) {
        int remain = list.size() % divide;
        int size = (list.size() - remain) / divide;
        ArrayList<List<V>> toReturn = new ArrayList<List<V>>();
        for (int i = 0; i < divide; ++i) {
            toReturn.add(i, new ArrayList());
        }
        for (List list2 : toReturn) {
            ArrayList<V> removed = new ArrayList<V>();
            int toAdd = size;
            if (remain > 0) {
                --remain;
                ++toAdd;
            }
            for (Object obj : list) {
                if (toAdd == 0) break;
                list2.add(obj);
                removed.add(obj);
                --toAdd;
            }
            for (Object obj : removed) {
                list.remove(obj);
            }
        }
        return toReturn;
    }

    public static <V> V getTop(List<V> list) {
        Iterator<V> iterator = list.iterator();
        if (iterator.hasNext()) {
            V obj = iterator.next();
            return obj;
        }
        return null;
    }

    public static <V> List<V> asList(Set<V> set) {
        return Arrays.asList(set.toArray());
    }

    public static <V> List<V> asList(V ... values) {
        return Arrays.asList(values);
    }

    public static double[] splitDouble(int size, double num) {
        double[] split = new double[size];
        for (int i = 0; i < size; ++i) {
            double remain = num % (double)size;
            double ret = (num - remain) / (double)size;
            split[i] = ret += remain;
            num -= remain;
        }
        return split;
    }

    public static double[] percent(double[] values) {
        double[] ret = new double[values.length];
        double total = 0.0;
        for (double d : values) {
            total += d;
        }
        for (int i = 0; i < values.length; ++i) {
            ret[i] = values[i] / total;
        }
        return ret;
    }

    public static int[] calcPercentInt(double[] percent, int val) {
        int[] ret = new int[percent.length];
        for (int i = 0; i < percent.length; ++i) {
            ret[i] = (int)Math.round((double)val * percent[i]);
        }
        int newTotal = 0;
        for (int i : ret) {
            newTotal += i;
        }
        int diff = val - newTotal;
        if (diff != val) {
            for (int i = 0; i < ret.length; ++i) {
                int num = ret[i];
                if (diff < 0 && num == 0) continue;
                if (diff > 0) {
                    int n = i;
                    ret[n] = ret[n] + 1;
                    --diff;
                } else if (diff < 0) {
                    int n = i;
                    ret[n] = ret[n] - 1;
                    ++diff;
                }
                if (diff != 0) continue;
                return ret;
            }
        }
        return ret;
    }

    public static int[] splitInt(int size, int num) {
        int[] split = new int[size];
        for (int i = 0; i < size; ++i) {
            int remain = num % size;
            int ret = (num - remain) / size;
            split[i] = ret += remain;
            num -= remain;
        }
        return split;
    }

    public static double[] percent(int[] values) {
        double[] ret = new double[values.length];
        double total = 0.0;
        int[] nArray = values;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = nArray[i];
            total += d;
        }
        for (int i = 0; i < values.length; ++i) {
            ret[i] = (double)values[i] / total;
        }
        return ret;
    }
}

