/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.config;

import com.enderio.core.EnderCore;
import com.enderio.core.common.config.AbstractConfigHandler;
import com.enderio.core.common.config.ConfigProcessor;
import com.enderio.core.common.config.ITweakConfigHandler;
import com.enderio.core.common.config.JsonConfigReader;
import com.enderio.core.common.config.annot.Comment;
import com.enderio.core.common.config.annot.Config;
import com.enderio.core.common.config.annot.NoSync;
import com.enderio.core.common.config.annot.Range;
import com.enderio.core.common.config.annot.RestartReq;
import com.enderio.core.common.handlers.RightClickCropHandler;
import com.enderio.core.common.tweaks.Tweak;
import com.enderio.core.common.tweaks.Tweaks;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraftforge.common.config.ConfigCategory;

public class ConfigHandler
extends AbstractConfigHandler
implements ITweakConfigHandler,
ConfigProcessor.IReloadCallback {
    private static final String sectionGeneral = "general";
    private static final String sectionEnchants = "enchants";
    @Config
    @Comment(value={"Control the behavior of invisible mode (disables all gameplay features). Having this setting be different between client and server could cause some desync, but otherwise is harmless.", "0 - Default. Lets other mods request invisible mode. If none do, invisible mode is off.", "-1 (or below) - Never invisible, even if mods request it.", "1 (or above) - Always invisible, even if no mods request it."})
    public static int invisibleMode = 0;
    @Config
    @Comment(value={"Show oredictionary names of every item in its tooltip.", "0 - Off", "1 - Always on", "2 - Only with shift", "3 - Only in debug mode"})
    @Range(min=0.0, max=3.0)
    @NoSync
    public static int showOredictTooltips = 2;
    @Config
    @Comment(value={"Show item registry names in tooltips.", "0 - Off", "1 - Always on", "2 - Only with shift", "3 - Only in debug mode"})
    @Range(min=0.0, max=3.0)
    @NoSync
    public static int showRegistryNameTooltips = 3;
    @Config
    @Comment(value={"Show durability on item tooltips.", "0 - Off", "1 - Always on", "2 - Only with shift", "3 - Only in debug mode"})
    @Range(min=0.0, max=3.0)
    @NoSync
    public static int showDurabilityTooltips = 1;
    @Config
    @Comment(value={"The max amount of XP levels an anvil recipe can use."})
    @InvisIgnore
    public static int anvilMaxLevel = 40;
    @Config
    @Comment(value={"The way the game should have been made (Yes this is the fireworks thing)."})
    public static boolean betterAchievements = false;
    @Config
    @Comment(value={"Fireworks display on new years eve"})
    public static boolean newYearsFireworks = true;
    @Config
    @Comment(value={"Disabling this option will prevent any crops added to the config json from being right clickable."})
    public static boolean allowCropRC = true;
    @Config
    @Comment(value={"Disabling this option will prevent tick speedup (i.e. torcherino) on any TE that uses the base TE class from EnderCore"})
    @InvisIgnore
    public static boolean allowExternalTickSpeedup = true;
    @Config(value="enchants")
    @Comment(value={"Allow the XP Boost enchant to be registered."})
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    public static boolean allowXPBoost = true;
    @Config(value="enchants")
    @Comment(value={"Allow the Auto Smelt enchant to be registered."})
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    public static boolean allowAutoSmelt = true;
    private static ConfigHandler INSTANCE;
    public static File configFolder;
    public static File enderConfigFolder;
    public static File configFile;
    public static ConfigProcessor processor;

    public static ConfigHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigHandler();
        }
        return INSTANCE;
    }

    protected ConfigHandler() {
        super("endercore");
    }

    @Override
    public void init() {
        this.addSection(sectionGeneral);
        this.addSection(sectionEnchants);
        this.addSection("tweaks");
        this.addSection("invisibility");
        processor = new ConfigProcessor(this.getClass(), this, (ConfigProcessor.IReloadCallback)this){

            @Override
            protected Object getConfigValue(String section, String[] commentLines, Field f, Object defVal) {
                Object res = super.getConfigValue(section, commentLines, f, defVal);
                if (f.getName() == "invisibleMode") {
                    if (res.equals(0)) {
                        return EnderCore.instance.invisibilityRequested() ? 1 : -1;
                    }
                } else if (invisibleMode == 1 && !f.isAnnotationPresent(InvisIgnore.class)) {
                    if (f.getType() == Integer.TYPE) {
                        return 0;
                    }
                    if (f.getType() == Boolean.TYPE) {
                        return false;
                    }
                }
                return res;
            }
        };
        processor.process(true);
    }

    @Override
    protected void reloadIngameConfigs() {
        Tweaks.loadIngameTweaks();
    }

    @Override
    protected void reloadNonIngameConfigs() {
        Tweaks.loadNonIngameTweaks();
    }

    @Override
    public void callback(ConfigProcessor inst) {
        Tweaks.loadIngameTweaks();
    }

    @Override
    public boolean addBooleanFor(Tweak tweak) {
        this.activateSection("tweaks");
        boolean ret = this.getValue(tweak.getName(), tweak.getComment(), true);
        return invisibleMode == 1 ? false : ret;
    }

    public boolean showInvisibleWarning() {
        this.activateSection("invisibility");
        ConfigCategory cat = this.config.getCategory("invisibility");
        boolean ret = false;
        if (!cat.containsKey("invisibilityWarning")) {
            ret = true;
        }
        boolean val = this.getValue("invisibilityWarning", "If set to true, the invisibility warning will show every time the user logs in.", false);
        this.saveConfigFile();
        return ret ? ret : val;
    }

    public void loadRightClickCrops() {
        JsonConfigReader<RightClickCropHandler.PlantInfo> reader = new JsonConfigReader<RightClickCropHandler.PlantInfo>(new JsonConfigReader.ModToken(EnderCore.class, "endercore".toLowerCase(Locale.US) + "/config"), enderConfigFolder.getAbsolutePath() + "/cropConfig.json", RightClickCropHandler.PlantInfo.class);
        for (RightClickCropHandler.PlantInfo i : reader) {
            i.init();
            RightClickCropHandler.INSTANCE.addCrop(i);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface InvisIgnore {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface InvisibleInt {
    }
}

