/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.debuginfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DebugClassWriter {
    private static final Pattern anyPattern = Pattern.compile(".*");
    private static final Pattern classPattern = Pattern.compile(".*.class");

    public static void output(OutputStream output) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(output));
        for (Class<?> c : DebugClassWriter.getClasses(anyPattern)) {
            bw.write("> " + c);
            bw.newLine();
            for (Field field : c.getDeclaredFields()) {
                bw.write("    " + field);
                bw.newLine();
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                bw.write("    " + accessibleObject);
                bw.newLine();
            }
            bw.flush();
        }
    }

    private static ArrayList<Class<?>> getClasses(Pattern patternPath) {
        ArrayList cls = new ArrayList();
        patternPath = Pattern.compile(patternPath.pattern() + ".class");
        for (String cl : DebugClassWriter.getResources(patternPath)) {
            char[] table = cl.substring(0, cl.length() - 6).toCharArray();
            for (int i = 0; i < table.length; ++i) {
                if (table[i] != '/' && table[i] != '\\') continue;
                table[i] = 46;
            }
            cl = new String(table);
            try {
                cls.add(Class.forName(cl, false, ClassLoader.getSystemClassLoader()));
            }
            catch (Throwable throwable) {}
        }
        return cls;
    }

    private static ArrayList<String> getResources(Pattern pattern) {
        String[] classPathElements;
        ArrayList<String> retval = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(System.getProperty("path.separator"))) {
            retval.addAll(DebugClassWriter.getResources(element, pattern));
        }
        return retval;
    }

    private static ArrayList<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(element);
        if (file.isDirectory()) {
            retval.addAll(DebugClassWriter.getResourcesFromDirectory(file, pattern, file.getAbsolutePath() + "/"));
        } else {
            retval.addAll(DebugClassWriter.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private static ArrayList<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (FileNotFoundException e) {
            return retval;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retval;
    }

    private static ArrayList<String> getResourcesFromDirectory(File directory, Pattern pattern, String begin) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(DebugClassWriter.getResourcesFromDirectory(file, pattern, begin));
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                char[] cs = fileName.toCharArray();
                for (int i = 0; i < cs.length; ++i) {
                    if (cs[i] != File.separatorChar) continue;
                    cs[i] = 47;
                }
                fileName = new String(cs);
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(fileName.substring(begin.length()));
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return retval;
    }
}

