/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.inventory;

import com.mrdimka.hammercore.common.InterItemStack;
import com.mrdimka.hammercore.common.inventory.IInventoryListener;
import com.mrdimka.hammercore.common.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class InventoryNonTile
implements IInventory {
    public IInventoryListener listener;
    public ItemStack[] inventory = new ItemStack[27];
    private final int[] allSlots;
    public int inventoryStackLimit = 64;
    public NBTTagCompound boundCompound = new NBTTagCompound();

    public InventoryNonTile(int inventorySize, NBTTagCompound boundNBT) {
        this.inventory = new ItemStack[inventorySize];
        this.allSlots = new int[this.inventory.length];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
        this.boundCompound = boundNBT;
    }

    public InventoryNonTile(NBTTagCompound boundNBT, ItemStack ... items) {
        int i;
        this.inventory = new ItemStack[items.length];
        for (i = 0; i < items.length; ++i) {
            this.inventory[i] = items[i];
        }
        this.allSlots = new int[items.length];
        for (i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
        this.boundCompound = boundNBT;
    }

    public InventoryNonTile(int inventorySize) {
        this.inventory = new ItemStack[inventorySize];
        this.allSlots = new int[inventorySize];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public InventoryNonTile(ItemStack ... items) {
        int i;
        this.inventory = new ItemStack[items.length];
        for (i = 0; i < items.length; ++i) {
            this.inventory[i] = items[i];
        }
        this.allSlots = new int[items.length];
        for (i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public int[] getAllAvaliableSlots() {
        return this.allSlots;
    }

    public String func_70005_c_() {
        return "Inventory Non Tile Entity";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        try {
            return this.inventory[index];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public ItemStack func_70298_a(int slot, int count) {
        try {
            if (!InterItemStack.isStackNull(this.inventory[slot])) {
                if (InterItemStack.getStackSize(this.inventory[slot]) <= count) {
                    ItemStack is = this.inventory[slot];
                    this.inventory[slot] = InterItemStack.NULL_STACK;
                    if (this.listener != null) {
                        this.listener.slotChange(count, this.inventory[slot]);
                    }
                    return is;
                }
                ItemStack is = this.inventory[slot].func_77979_a(count);
                if (InterItemStack.getStackSize(this.inventory[slot]) == 0) {
                    this.inventory[slot] = InterItemStack.NULL_STACK;
                }
                if (this.listener != null) {
                    this.listener.slotChange(count, this.inventory[slot]);
                }
                return is;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        try {
            this.inventory[index] = stack;
            if (this.listener != null) {
                this.listener.slotChange(index, stack);
            }
            if (InterItemStack.getStackSize(this.inventory[index]) > Math.min(this.inventory[index].func_77976_d(), this.func_70297_j_())) {
                this.inventory[index].field_77994_a = Math.min(this.inventory[index].func_77976_d(), this.func_70297_j_());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int func_70297_j_() {
        return this.inventoryStackLimit;
    }

    public void func_70296_d() {
        this.writeToNBT();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        int i;
        for (i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = InterItemStack.NULL_STACK;
        }
        if (this.listener != null) {
            for (i = 0; i < this.inventory.length; ++i) {
                this.listener.slotChange(i, this.inventory[i]);
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("InvSize", this.inventory.length);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (InterItemStack.isStackNull(this.inventory[i])) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Slot", i);
                this.inventory[i].func_77955_b(tag);
                list.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("Inventory", (NBTBase)list);
        }
    }

    public void writeToNBT() {
        this.writeToNBT(this.boundCompound);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.inventory = new ItemStack[nbt.func_74762_e("InvSize")];
            NBTTagList list = nbt.func_150295_c("Inventory", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                this.inventory[tag.func_74762_e((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
    }

    public void readFromNBT() {
        this.readFromNBT(this.boundCompound);
    }

    public void drop(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (ItemStack s : this.inventory) {
                if (InterItemStack.isStackNull(s)) continue;
                WorldUtil.spawnItemStack(world, pos, s);
            }
        }
        this.func_174888_l();
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack s = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        if (this.listener != null) {
            this.listener.slotChange(slot, null);
        }
        return s;
    }

    public boolean isUsableByPlayer(EntityPlayer player, BlockPos from) {
        return player.func_174818_b(from) <= 64.0;
    }

    @Deprecated
    public boolean isUseableByPlayer(EntityPlayer player, BlockPos from) {
        return player.func_174818_b(from) <= 64.0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }
}

