/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.utils;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class UtilsFX {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");

    public static ResourceLocation getMCParticleTexture() {
        return PARTICLE_TEXTURES;
    }

    public static void drawBeam(Vec3d S, Vec3d E, Vec3d P, float width, int bright) {
        UtilsFX.drawBeam(S, E, P, width, bright, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawBeam(Vec3d S, Vec3d E, Vec3d P, float width, int bright, float r, float g, float b, float a) {
        Vec3d PS = UtilsFX.Sub(S, P);
        Vec3d SE = UtilsFX.Sub(E, S);
        Vec3d normal = UtilsFX.Cross(PS, SE);
        normal = normal.func_72432_b();
        Vec3d half = UtilsFX.Mul(normal, width);
        Vec3d p1 = UtilsFX.Add(S, half);
        Vec3d p2 = UtilsFX.Sub(S, half);
        Vec3d p3 = UtilsFX.Add(E, half);
        Vec3d p4 = UtilsFX.Sub(E, half);
        UtilsFX.drawQuad(Tessellator.func_178181_a().func_178180_c(), p1, p3, p4, p2, bright, r, g, b, a);
    }

    public static void drawQuad(VertexBuffer buf, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4, int bright, float r, float g, float b, float a) {
        int j = bright >> 16 & 0xFFFF;
        int k = bright & 0xFFFF;
        buf.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.0, 0.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_187315_a(1.0, 0.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_187315_a(1.0, 1.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(p4.field_72450_a, p4.field_72448_b, p4.field_72449_c).func_187315_a(0.0, 1.0).func_187314_a(j, k).func_181666_a(r, g, b, a).func_181675_d();
    }

    private static Vec3d Cross(Vec3d a, Vec3d b) {
        double xCoord = a.field_72448_b * b.field_72449_c - a.field_72449_c * b.field_72448_b;
        double yCoord = a.field_72449_c * b.field_72450_a - a.field_72450_a * b.field_72449_c;
        double zCoord = a.field_72450_a * b.field_72448_b - a.field_72448_b * b.field_72450_a;
        return new Vec3d(xCoord, yCoord, zCoord);
    }

    public static Vec3d Sub(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72450_a - b.field_72450_a, a.field_72448_b - b.field_72448_b, a.field_72449_c - b.field_72449_c);
    }

    private static Vec3d Add(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72450_a + b.field_72450_a, a.field_72448_b + b.field_72448_b, a.field_72449_c + b.field_72449_c);
    }

    private static Vec3d Mul(Vec3d a, float f) {
        return new Vec3d(a.field_72450_a * (double)f, a.field_72448_b * (double)f, a.field_72449_c * (double)f);
    }
}

