/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.model;

import com.mrdimka.hammercore.client.model.SimpleModel;
import com.mrdimka.hammercore.client.model.SimpleModelLoader;
import com.mrdimka.hammercore.client.model.file.ModelPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CasedModel {
    public Map<ModelPart, String> PREDICATES = new HashMap<ModelPart, String>();
    public int textureHeight;
    public int textureWidth;

    public void addBox(ModelPart box, String condition) {
        this.PREDICATES.put(box, condition);
    }

    public SimpleModel produce(String[] arguments) {
        return this.produce(Arrays.asList((Object[])arguments));
    }

    public SimpleModel produce(List arguments) {
        SimpleModel model = new SimpleModel();
        model.field_78090_t = this.textureWidth;
        model.field_78089_u = this.textureHeight;
        for (ModelPart mr : this.PREDICATES.keySet()) {
            try {
                if (!CasedModel.conditionsMatch(CasedModel.generateConditions(this.PREDICATES.get(mr)), arguments)) continue;
                model.addBox(SimpleModelLoader.toRenderer(model, mr));
            }
            catch (Throwable throwable) {}
        }
        return model;
    }

    public static boolean conditionsMatch(String[] conditions, List arguments_) {
        String c;
        ArrayList<String> arguments = new ArrayList<String>();
        if (conditions == null || conditions.length == 0) {
            return true;
        }
        for (Object o : arguments_) {
            arguments.add((o + "").toLowerCase());
        }
        if (conditions[0] == "o") {
            for (int i = 1; i < conditions.length; ++i) {
                c = conditions[i];
                if (c.startsWith("!") && !arguments.contains(c.substring(1))) {
                    return true;
                }
                if (!arguments.contains(c)) continue;
                return true;
            }
        } else if (conditions[0] == "a" || conditions[0] == "s") {
            for (int i = 1; i < conditions.length; ++i) {
                c = conditions[i];
                if (c.startsWith("!") && arguments.contains(c.substring(1))) {
                    return false;
                }
                if (arguments.contains(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String[] generateConditions(String condition) {
        if (condition == null || condition.isEmpty()) {
            return new String[0];
        }
        condition = condition.trim();
        String parsed = null;
        if (condition.contains(" or ")) {
            String[] conds;
            parsed = "o;";
            for (String c : conds = condition.split(" or ")) {
                parsed = parsed + c + ";";
            }
        } else if (condition.contains(" and ")) {
            String[] conds;
            parsed = "a;";
            for (String c : conds = condition.split(" and ")) {
                parsed = parsed + c + ";";
            }
        } else {
            parsed = "s;" + condition;
        }
        if (parsed.endsWith(";")) {
            parsed = parsed.substring(0, parsed.length() - 1);
        }
        return parsed.split(";");
    }
}

