/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.item.ItemBlockVault;
import shetiphian.multistorage.common.tileentity.IVaultWall;

public class FluidConcrete
extends Fluid {
    public static final ResourceLocation resource = new ResourceLocation("multistorage:fluids/concrete");

    public FluidConcrete() {
        super("multistorage:concrete", resource, resource);
        this.setUnlocalizedName("multistorage.concrete");
    }

    public boolean pourWall(World world, BlockPos pos, EntityPlayer player) {
        if (Values.blockVault == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null) {
            return false;
        }
        BlockVault.EnumType setType = null;
        ItemStack blockItem = null;
        if (block instanceof BlockVault) {
            BlockVault.EnumType baseType = BlockVault.getEnumType(state = block.func_176221_a(state, (IBlockAccess)world, pos));
            if (baseType.getValue() == 14) {
                setType = BlockVault.EnumType.byValue(baseType.getBaseValue());
                blockItem = new ItemStack(block, 1, baseType.getBaseValue() + 20);
            }
        } else {
            blockItem = block.getPickBlock(state, Function.rayTrace((EntityPlayer)player, (double)5.0, (float)0.0f), world, pos, player);
            setType = FluidConcrete.getTypeFromStack(blockItem);
        }
        if (setType == null) {
            return false;
        }
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockVault.func_176203_a((int)setType.getValue()), (boolean)true);
        TileEntity wallTile = world.func_175625_s(pos);
        if (wallTile instanceof IVaultWall) {
            ((IVaultWall)wallTile).wallPoured(setType, blockItem);
            Function.syncTile((TileEntity)wallTile);
        }
        world.func_184133_a(player, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public static BlockVault.EnumType getTypeFromStack(ItemStack stack) {
        if (stack != null) {
            int meta;
            if (stack.func_77973_b() instanceof ItemBlockVault && (meta = stack.func_77952_i()) >= 1 && meta <= 33) {
                return BlockVault.EnumType.byValue(meta < 20 ? meta : meta - 20);
            }
            for (BlockVault.EnumType type : BlockVault.EnumType.values()) {
                ArrayList<Object> baseItems;
                if (type.getValue() < 1 || type.getValue() > 13 || (baseItems = Settings.INSTANCE.wallBaseItems.get((Object)type)) == null) continue;
                for (Object object : baseItems) {
                    if (!(object instanceof String ? OreDictionary.containsMatch((boolean)false, (List)OreDictionary.getOres((String)((String)object)), (ItemStack[])new ItemStack[]{stack}) : object instanceof ItemStack && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)object), (boolean)true))) continue;
                    return type;
                }
            }
        }
        return null;
    }
}

