/*
 * Decompiled with CFR 0.152.
 */
package cyano.orespawn.init;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cyano.orespawn.worldgen.OreSpawnData;
import cyano.orespawn.worldgen.OreSpawner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class WorldGen {
    private static final Map<Integer, List<OreSpawnData>> oreSpawnRegistry = new HashMap<Integer, List<OreSpawnData>>();
    private static int weight = 100;

    public static void loadConfig(Path jsonFile) throws IOException {
        JsonParser parser = new JsonParser();
        BufferedReader fileReader = Files.newBufferedReader(jsonFile, Charset.forName("UTF-8"));
        JsonObject settings = parser.parse((Reader)fileReader).getAsJsonObject();
        fileReader.close();
        WorldGen.parseConfig(settings);
    }

    public static void init() {
        Random prng = new Random();
        for (Integer dim : oreSpawnRegistry.keySet()) {
            List<OreSpawnData> ores = oreSpawnRegistry.get(dim);
            for (OreSpawnData ore : ores) {
                WorldGen.addOreSpawner(ore, dim, prng.nextLong());
            }
        }
    }

    private static void parseConfig(JsonObject root) {
        JsonArray dimensions = root.get("dimensions").getAsJsonArray();
        for (int n = 0; n < dimensions.size(); ++n) {
            JsonObject dim = dimensions.get(n).getAsJsonObject();
            Integer dimIndex = dim.get("dimension").getAsString().equals("+") ? null : Integer.valueOf(dim.get("dimension").getAsInt());
            JsonArray ores = dim.get("ores").getAsJsonArray();
            for (int i = 0; i < ores.size(); ++i) {
                OreSpawnData ore = OreSpawnData.parseOreSpawnData(ores.get(i).getAsJsonObject());
                FMLLog.info((String)("Parsed ore spawn setting for dimension " + dimIndex + ": " + ore), (Object[])new Object[0]);
                if (!oreSpawnRegistry.containsKey(dimIndex)) {
                    oreSpawnRegistry.put(dimIndex, new LinkedList());
                }
                oreSpawnRegistry.get(dimIndex).add(ore);
            }
        }
    }

    public static void addOreSpawner(OreSpawnData spawnParameters, Integer dimension, long randomHash) {
        OreSpawner spawner = new OreSpawner(spawnParameters, dimension, randomHash);
        GameRegistry.registerWorldGenerator((IWorldGenerator)spawner, (int)weight++);
    }
}

