/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.blocks.BlockFertileLilypad;
import xreliquary.init.ModItems;
import xreliquary.items.ItemHarvestRod;
import xreliquary.reference.Settings;

public class PedestalHarvestRodWrapper
implements IPedestalActionItemWrapper {
    private static final int NO_JOB_COOL_DOWN_CYCLES = 10;
    private static final ItemHarvestRod harvestRod = ModItems.harvestRod;
    private int hoeCoolDown = 0;
    private int plantCoolDown = 0;
    private int boneMealCoolDown = 0;
    private int breakCoolDown = 0;
    private Queue<BlockPos> queueToHoe = new ArrayDeque<BlockPos>();
    private Queue<BlockPos> queueToPlant = new ArrayDeque<BlockPos>();
    private Queue<BlockPos> queueToBoneMeal = new ArrayDeque<BlockPos>();
    private Queue<BlockPos> queueToBreak = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        FakePlayer player = pedestal.getFakePlayer();
        int range = Settings.HarvestRod.pedestalRange;
        byte cooldown = Settings.HarvestRod.pedestalCooldown;
        this.hoeLand(world, (EntityPlayer)player, pos, range);
        this.plantSeeds(world, (EntityPlayer)player, pos, stack, range);
        this.boneMealCrops(world, (EntityPlayer)player, pos, stack, range);
        this.breakCrops(world, pos, stack, range);
        pedestal.setActionCoolDown(cooldown);
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    private void breakCrops(World world, BlockPos pos, ItemStack stack, int range) {
        if (this.breakCoolDown > 0) {
            --this.breakCoolDown;
        } else {
            BlockPos nextBlockToBreak = this.getNextBlockToBreak(world, pos, range);
            if (nextBlockToBreak != null) {
                this.doHarvestBlockBreak(world, stack, nextBlockToBreak);
                return;
            }
            this.breakCoolDown = 10;
        }
    }

    public void doHarvestBlockBreak(World world, ItemStack ist, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        List drops = block.getDrops((IBlockAccess)world, pos, blockState, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ist));
        Random rand = new Random();
        for (ItemStack stack : drops) {
            float f = 0.7f;
            double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    private void boneMealCrops(World world, EntityPlayer player, BlockPos pos, ItemStack stack, int range) {
        if (this.boneMealCoolDown > 0) {
            --this.boneMealCoolDown;
        } else {
            BlockPos blockToBoneMeal;
            if (harvestRod.getBoneMealCount(stack) >= harvestRod.getBonemealCost() && (blockToBoneMeal = this.getNextBlockToBoneMeal(world, pos, range)) != null) {
                this.boneMealBlock(stack, player, world, blockToBoneMeal, EnumFacing.UP);
                return;
            }
            this.boneMealCoolDown = 10;
        }
    }

    private void boneMealBlock(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        ItemStack fakeItemStack = new ItemStack(Items.field_151100_aR, 1, 15);
        ItemDye fakeItemDye = (ItemDye)fakeItemStack.func_77973_b();
        boolean boneMealUsed = false;
        for (int repeatedUses = 0; repeatedUses <= harvestRod.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.field_73012_v.nextInt(100) > harvestRod.getLuckPercent() || fakeItemDye.func_180614_a(fakeItemStack, player, world, pos, EnumHand.MAIN_HAND, side, 0.0f, 0.0f, 0.0f) != EnumActionResult.SUCCESS) continue;
            boneMealUsed = true;
        }
        if (boneMealUsed) {
            harvestRod.setBoneMealCount(ist, harvestRod.getBoneMealCount(ist) - harvestRod.getBonemealCost());
        }
    }

    private void plantSeeds(World world, EntityPlayer player, BlockPos pos, ItemStack stack, int range) {
        if (this.plantCoolDown > 0) {
            --this.plantCoolDown;
        } else {
            BlockPos blockToPlantOn;
            int quantity;
            byte plantableSlot = 1;
            if (harvestRod.getCountPlantable(stack) > 0 && (quantity = harvestRod.getPlantableQuantity(stack, plantableSlot)) > 0 && (blockToPlantOn = this.getNextBlockToPlantOn(world, pos, range, (IPlantable)harvestRod.getPlantableInSlot(stack, plantableSlot).func_77973_b())) != null) {
                this.plantItem(world, player, blockToPlantOn, stack, plantableSlot);
                return;
            }
            this.plantCoolDown = 10;
        }
    }

    private void plantItem(World world, EntityPlayer player, BlockPos pos, ItemStack stack, byte idx) {
        ItemStack fakePlantableStack = harvestRod.getPlantableInSlot(stack, idx).func_77946_l();
        fakePlantableStack.field_77994_a = 1;
        if (fakePlantableStack.func_179546_a(player, world, pos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS) {
            harvestRod.setPlantableQuantity(stack, idx, harvestRod.getPlantableQuantity(stack, idx) - 1);
            harvestRod.shiftModeOnEmptyPlantable(stack, idx);
        }
    }

    private void hoeLand(World world, EntityPlayer player, BlockPos pos, int range) {
        if (this.hoeCoolDown > 0) {
            --this.hoeCoolDown;
        } else {
            ItemStack fakeHoe = new ItemStack(Items.field_151017_I);
            BlockPos blockToHoe = this.getNextBlockToHoe(world, pos, range);
            if (blockToHoe != null) {
                Items.field_151017_I.func_180614_a(fakeHoe, player, world, blockToHoe, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
            } else {
                this.hoeCoolDown = 10;
            }
        }
    }

    private BlockPos getNextBlockToBreak(World world, BlockPos pos, int range) {
        if (this.queueToBreak.isEmpty()) {
            this.fillQueueToBreak(world, pos, range);
        }
        return this.queueToBreak.poll();
    }

    private void fillQueueToBreak(World world, BlockPos pos, int range) {
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(currentPos);
                    Block block = state.func_177230_c();
                    if (!(block instanceof IPlantable) && !(block instanceof BlockCrops) && block != Blocks.field_150440_ba && block != Blocks.field_150423_aK || block instanceof BlockFertileLilypad || block == Blocks.field_150393_bb || block == Blocks.field_150394_bc || block instanceof BlockCrops && ((BlockCrops)block).func_176473_a(world, pos, state, false) || block instanceof BlockNetherWart && (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) < 3) continue;
                    this.queueToBreak.add(currentPos);
                }
            }
        }
    }

    private BlockPos getNextBlockToHoe(World world, BlockPos pos, int range) {
        if (this.queueToHoe.isEmpty()) {
            this.fillQueueToHoe(world, pos, range);
        }
        return this.queueToHoe.poll();
    }

    private void fillQueueToHoe(World world, BlockPos pos, int range) {
        this.queueToHoe.clear();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    Block block = blockState.func_177230_c();
                    if (!world.func_175623_d(currentPos.func_177984_a()) || block != Blocks.field_150349_c && (block != Blocks.field_150346_d || blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT && blockState.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.COARSE_DIRT)) continue;
                    this.queueToHoe.add(currentPos);
                }
            }
        }
    }

    private BlockPos getNextBlockToPlantOn(World world, BlockPos pos, int range, IPlantable plantable) {
        if (this.queueToPlant.isEmpty()) {
            this.fillQueueToPlant(world, pos, range, plantable);
        }
        return this.queueToPlant.poll();
    }

    private void fillQueueToPlant(World world, BlockPos pos, int range, IPlantable plantable) {
        this.queueToPlant.clear();
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Items.field_151080_bb || plantable == Items.field_151081_bc) {
            checkerboard = true;
            boolean xEven = pos.func_177958_n() % 2 == 0;
            boolean zEven = pos.func_177952_p() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    if (checkerboard && bothOddOrEven != (currentPos.func_177958_n() % 2 == 0 == (currentPos.func_177952_p() % 2 == 0)) || !blockState.func_177230_c().canSustainPlant(blockState, (IBlockAccess)world, pos, EnumFacing.UP, plantable) || !world.func_175623_d(currentPos.func_177984_a())) continue;
                    this.queueToPlant.add(currentPos);
                }
            }
        }
    }

    private BlockPos getNextBlockToBoneMeal(World world, BlockPos pos, int range) {
        if (this.queueToBoneMeal.isEmpty()) {
            this.fillQueueToBoneMeal(world, pos, range);
        }
        return this.queueToBoneMeal.poll();
    }

    private void fillQueueToBoneMeal(World world, BlockPos pos, int range) {
        this.queueToBoneMeal.clear();
        for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range; ++x) {
            for (int y = pos.func_177956_o() - range; y <= pos.func_177956_o() + range; ++y) {
                for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(currentPos);
                    if (blockState.func_177230_c() == Blocks.field_150349_c || !(blockState.func_177230_c() instanceof IGrowable) || !((IGrowable)blockState.func_177230_c()).func_176473_a(world, currentPos, blockState, world.field_72995_K)) continue;
                    this.queueToBoneMeal.add(currentPos);
                }
            }
        }
    }
}

