/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.items.util.FilteredItemStackHandler;

public class PacketContainerItemHandlerSync
implements IMessage,
IMessageHandler<PacketContainerItemHandlerSync, IMessage> {
    private int slot;
    private NBTTagCompound itemHandlerNBT;
    private int windowId;
    private static final int INVALID_SLOT = -1;

    public PacketContainerItemHandlerSync() {
    }

    public PacketContainerItemHandlerSync(int slot, NBTTagCompound itemHandlerNBT, int windowId) {
        this.slot = slot;
        this.itemHandlerNBT = itemHandlerNBT;
        this.windowId = windowId;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.windowId = buf.readInt();
        try {
            this.itemHandlerNBT = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeInt(this.windowId);
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.itemHandlerNBT, (DataOutput)new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketContainerItemHandlerSync message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> this.handleMessage(message, ctx));
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleMessage(PacketContainerItemHandlerSync message, MessageContext ctx) {
        FilteredItemStackHandler filteredHandler;
        IItemHandler itemHandler;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71070_bA == null || player.field_71070_bA.field_75152_c != message.windowId) {
            return;
        }
        Slot s = player.field_71070_bA.func_75139_a(message.slot);
        if (s == null) {
            return;
        }
        ItemStack stack = s.func_75211_c();
        if (stack != null && (itemHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && itemHandler instanceof FilteredItemStackHandler && (filteredHandler = (FilteredItemStackHandler)itemHandler) != null) {
            filteredHandler.deserializeNBT(message.itemHandlerNBT);
        }
    }
}

