/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.blocks.BlockPedestalPassive;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.init.ModBlocks;
import xreliquary.pedestal.PedestalRegistry;

public class BlockPedestal
extends BlockPedestalPassive {
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");

    public BlockPedestal() {
        this.func_149663_c("pedestal");
    }

    @Override
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack((Block)ModBlocks.pedestal, 1, i));
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(worldIn.field_73011_w.getDimension(), pos, 160);
        for (BlockPos pedestalPosition : pedestalPositions) {
            TileEntity te = worldIn.func_175625_s(pedestalPosition);
            if (te == null || !(te instanceof TileEntityPedestal)) continue;
            ((TileEntityPedestal)te).updateRedstone();
        }
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPedestal();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR, ENABLED});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            i |= 4;
        }
        return i |= super.func_176201_c(state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, worldIn, pos, neighborBlock);
        ((TileEntityPedestal)worldIn.func_175625_s(pos)).neighborUpdate();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false));
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue() && rand.nextInt(3) == 1) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double xMiddle = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 4.0 / 16.0;
            double zMiddle = (double)pos.func_177952_p() + 0.5;
            double sideOffset = 0.27;
            double randomOffset = rand.nextDouble() * 0.3 - 0.15;
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, xMiddle + sideOffset, y, zMiddle + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, xMiddle - sideOffset, y, zMiddle + randomOffset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, xMiddle + randomOffset, y, zMiddle + sideOffset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, xMiddle + randomOffset, y, zMiddle - sideOffset, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float xOff, float yOff, float zOff) {
        if (world.field_72995_K) {
            return player.func_184586_b(hand) != null || player.func_70093_af();
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityPedestal)) {
            return false;
        }
        if (heldItem == null && !player.func_70093_af() && hand == EnumHand.MAIN_HAND && this.switchClicked(side, xOff, yOff, zOff)) {
            TileEntityPedestal pedestal = (TileEntityPedestal)world.func_175625_s(pos);
            pedestal.toggleSwitch();
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, xOff, yOff, zOff);
    }

    private boolean switchClicked(EnumFacing side, float xOff, float yOff, float zOff) {
        if ((double)yOff < 0.3 || (double)yOff > 0.65) {
            return false;
        }
        if (side == EnumFacing.NORTH && ((double)xOff < 0.35 || (double)xOff > 0.65 || (double)zOff != 0.125)) {
            return false;
        }
        if (side == EnumFacing.SOUTH && ((double)xOff < 0.35 || (double)xOff > 0.65 || (double)zOff != 0.875)) {
            return false;
        }
        if (side == EnumFacing.WEST && ((double)zOff < 0.35 || (double)zOff > 0.65 || (double)xOff != 0.125)) {
            return false;
        }
        return side != EnumFacing.EAST || !((double)zOff < 0.35) && !((double)zOff > 0.65) && (double)xOff == 0.875;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityPedestal pedestal = (TileEntityPedestal)world.func_175625_s(pos);
        PedestalRegistry.unregisterPosition(world.field_73011_w.getDimension(), pos);
        pedestal.removeItemsFromLists();
        super.func_180663_b(world, pos, state);
    }

    public void setEnabled(World world, BlockPos pos, boolean enabled) {
        IBlockState state = world.func_180495_p(pos);
        if ((Boolean)state.func_177229_b((IProperty)ENABLED) != enabled) {
            state = state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(enabled));
            world.func_175656_a(pos, state);
        }
    }
}

