/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.tile.TileEntityAltar;
import xreliquary.init.ModBlocks;
import xreliquary.items.ItemAlkahestryTome;
import xreliquary.reference.Settings;
import xreliquary.util.NBTHelper;

public class BlockAlkahestryAltar
extends BlockBase {
    private final boolean isActive;

    public BlockAlkahestryAltar(boolean isActive) {
        super(Material.field_151576_e, isActive ? "altar" : "altar_idle", 1.5f, 5.0f);
        this.isActive = isActive;
        this.func_149715_a(this.isActive ? this.getAltarActiveLightLevel() : 0.0f);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityAltar();
    }

    private float getAltarActiveLightLevel() {
        return (float)Settings.Altar.outputLightLevelWhileActive / 16.0f;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemBlock.func_150898_a((Block)ModBlocks.alkahestryAltar);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!this.isActive) {
            return;
        }
        int worldTime = (int)(world.func_72820_D() % 24000L);
        if (worldTime >= 12000) {
            return;
        }
        if (!world.func_175710_j(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()))) {
            return;
        }
        if (rand.nextInt(3) != 0) {
            return;
        }
        world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)pos.func_177958_n() + 0.5 + rand.nextGaussian() / 8.0, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5 + rand.nextGaussian() / 8.0, 0.9, 0.9, 0.0, new int[0]);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float xOff, float yOff, float zOff) {
        if (this.isActive) {
            return true;
        }
        TileEntityAltar altar = (TileEntityAltar)world.func_175625_s(pos);
        if (altar == null) {
            return true;
        }
        if (heldItem == null) {
            return true;
        }
        if (heldItem.func_77973_b() == Items.field_151137_ax) {
            int slot = this.getSlotWithRedstoneDust(player);
            if (slot == -1) {
                return true;
            }
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(world.field_73012_v.nextGaussian() / 8.0));
            for (int particles = world.field_73012_v.nextInt(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, 1.0, 0.0, 0.0, new int[0]);
            }
            if (world.field_72995_K) {
                return true;
            }
            player.field_71071_by.func_70298_a(slot, 1);
            altar.addRedstone();
        } else if (heldItem.func_77973_b() instanceof ItemAlkahestryTome && NBTHelper.getInteger("redstone", heldItem) > 0) {
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(world.field_73012_v.nextGaussian() / 8.0));
            for (int particles = world.field_73012_v.nextInt(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 5.0, 1.0, 0.0, 0.0, new int[0]);
            }
            if (world.field_72995_K) {
                return true;
            }
            NBTHelper.setInteger("redstone", heldItem, NBTHelper.getInteger("redstone", heldItem) - 1);
            altar.addRedstone();
        }
        return true;
    }

    private int getSlotWithRedstoneDust(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != Items.field_151137_ax) continue;
            return slot;
        }
        return -1;
    }

    public static void updateAltarBlockState(boolean active, World world, BlockPos pos) {
        if (active) {
            world.func_175656_a(pos, ModBlocks.alkahestryAltarActive.func_176223_P());
            TileEntityAltar te = (TileEntityAltar)world.func_175625_s(pos);
            if (te != null) {
                te.startCycle();
            }
        } else {
            world.func_175656_a(pos, ModBlocks.alkahestryAltar.func_176223_P());
        }
    }
}

