/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.util;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Page;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.page.PageItemStack;
import amerifrance.guideapi.page.PageText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.WordUtils;

public class PageHelper {
    public static List<IPage> setPagesToUnicode(List<IPage> pages) {
        for (IPage page : pages) {
            if (!(page instanceof Page)) continue;
            ((Page)page).setUnicodeFlag(true);
        }
        return pages;
    }

    public static List<IPage> pagesForLongText(String locText, int maxLength) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        for (String s : WordUtils.wrap((String)locText, (int)maxLength, (String)"/cut", (boolean)false).split("/cut")) {
            pageList.add(new PageText(s));
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(String locText) {
        return PageHelper.pagesForLongText(locText, 450);
    }

    public static List<IPage> pagesForLongText(String locText, ItemStack stack) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        String[] strings = WordUtils.wrap((String)locText, (int)450, (String)"/cut", (boolean)false).split("/cut");
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                pageList.add(new PageItemStack(strings[i], stack));
                continue;
            }
            pageList.add(new PageText(strings[i]));
        }
        return pageList;
    }

    public static void drawFormattedText(int x, int y, GuiBase guiBase, String toDraw) {
        String[] lines;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        toDraw = StringEscapeUtils.unescapeJava((String)toDraw).replaceAll("\\t", "     ");
        for (String line : lines = toDraw.split("\n")) {
            List cutLines = fontRenderer.func_78271_c(line, 3 * guiBase.xSize / 5);
            for (String cut : cutLines) {
                fontRenderer.func_78276_b(cut, x, y, 0);
                y += 10;
            }
        }
    }

    public static List<IPage> pagesForLongText(String locText, Item item) {
        return PageHelper.pagesForLongText(locText, new ItemStack(item));
    }

    public static List<IPage> pagesForLongText(String locText, Block block) {
        return PageHelper.pagesForLongText(locText, new ItemStack(block));
    }

    public static boolean areIRecipesEqual(IRecipe recipe1, IRecipe recipe2) {
        if (recipe1 == recipe2) {
            return true;
        }
        if (recipe1 == null || recipe2 == null || recipe1.getClass() != recipe2.getClass()) {
            return false;
        }
        if (recipe1.equals(recipe2)) {
            return true;
        }
        if (!recipe1.func_77571_b().func_77969_a(recipe2.func_77571_b())) {
            return false;
        }
        return recipe1.func_77570_a() == recipe2.func_77570_a();
    }
}

