/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import xyz.vsngamer.elevator.ElevatorModTab;
import xyz.vsngamer.elevator.init.ModBlocks;
import xyz.vsngamer.elevator.init.ModConfig;
import xyz.vsngamer.elevator.init.ModCrafting;
import xyz.vsngamer.elevator.init.ModItems;
import xyz.vsngamer.elevator.init.ModSounds;
import xyz.vsngamer.elevator.network.NetworkHandler;
import xyz.vsngamer.elevator.proxy.CommonProxy;

@Mod(modid="elevatorid", name="Elevator Mod", version="1.3.0", acceptedMinecraftVersions="[1.10.2]", guiFactory="xyz.vsngamer.elevator.gui.GuiFactory")
public class ElevatorMod {
    @Mod.Instance
    public static ElevatorMod instance;
    @SidedProxy(clientSide="xyz.vsngamer.elevator.proxy.ClientProxy", serverSide="xyz.vsngamer.elevator.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs CREATIVE_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModBlocks.init();
        ModItems.init();
        proxy.preInit();
        ModSounds.registerSounds();
        NetworkHandler.init();
        File configDir = new File(event.getModConfigurationDirectory(), "ElevatorMod");
        ModConfig.init(new File(configDir, "ElevatorMod.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCrafting.register();
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            EnumDyeColor color = null;
            if (mapping.name.equals("elevatorid:BlockElevator")) {
                color = EnumDyeColor.WHITE;
            } else if (mapping.name.startsWith("elevatorid:BlockElevator")) {
                String name = mapping.name.substring("elevatorid:BlockElevator".length());
                for (EnumDyeColor candidate : EnumDyeColor.values()) {
                    if (!candidate.func_176762_d().equalsIgnoreCase(name)) continue;
                    color = candidate;
                    break;
                }
            }
            if (color == null) continue;
            switch (mapping.type) {
                case BLOCK: {
                    mapping.remap((Block)ModBlocks.elevators.get(color));
                    break;
                }
                case ITEM: {
                    mapping.remap((Item)ModItems.elevators.get(color));
                }
            }
        }
    }

    static {
        CREATIVE_TAB = new ElevatorModTab();
    }
}

