/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.SPConfig;
import shetiphian.platforms.common.helpers.CraftHelper;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public SPConfig config;
    private boolean firstrun;
    public ArrayList<ItemStack> listWood = new ArrayList();
    public ArrayList<ItemStack> listStone = new ArrayList();

    void setupConfig(File file) {
        this.config = new SPConfig(file);
        this.config.load();
        this.firstrun = true;
    }

    public void load() {
        this.syncConfig();
        this.firstrun = false;
    }

    public void syncConfig() {
        this.config.addCustomCategoryComment("ADDITIONAL-BLOCKS", "By default Wood and Stone Platforms only use blocks registered to the Forge Ore Dictionary but additional blocks can be added here.\n\nFormat = \u00a79modId\u00a7r:\u00a72nameId\u00a73@meta\n\u00a79modId\u00a7r can be left off for vanilla blocks, and 'ore' can be used to indicate a dictionary entry\n\u00a72nameId\u00a7r can contain [*] or [#-#] to replace an incrementing number or a number range\n\u00a73@meta\u00a7r can be left off to indicate any meta");
        String[] woodBlocks = new String[]{};
        woodBlocks = this.config.getStringList("woodBlocks", "ADDITIONAL-BLOCKS", woodBlocks, "Listed blocks will be used in addition to any registered as 'plankWood'");
        String[] stoneBlocks = new String[]{"stone", "lapis_block", "brick_block", "mossy_cobblestone", "diamond_block", "stonebrick", "end_stone", "nether_brick", "emerald_block", "quartz_block", "stained_hardened_clay", "prismarine", "hardened_clay", "packed_ice", "purpur_block", "purpur_pillar", "end_bricks", "red_nether_brick", "flatcoloredblocks:flatcoloredblock[*]"};
        stoneBlocks = this.config.getStringList("stoneBlocks", "ADDITIONAL-BLOCKS", stoneBlocks, "Listed blocks will be used in addition to any registered as 'stone', 'cobblestone', or 'sandstone'");
        if (this.firstrun) {
            this.listWood = this.process(woodBlocks);
            this.listStone = this.process(stoneBlocks);
        }
        if (this.config.hasChanged()) {
            this.config.save();
            if (!this.firstrun) {
                CraftHelper.generateUserPlanks(this.process(woodBlocks));
                CraftHelper.generateUserStone(this.process(stoneBlocks));
            }
        }
    }

    private ArrayList<ItemStack> process(String[] names) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String name : names) {
            String nameId;
            if (Strings.isNullOrEmpty((String)name)) continue;
            int meta = Short.MAX_VALUE;
            if (name.contains("@")) {
                try {
                    meta = Integer.valueOf(name.split("@")[1]);
                    name = name.substring(0, name.lastIndexOf(64));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
            String string = nameId = name.contains(":") ? name.split(":")[1] : name;
            if (modId.equalsIgnoreCase("ore") || modId.equalsIgnoreCase("oredictionary")) {
                List ores = OreDictionary.getOres((String)nameId);
                for (ItemStack ore : ores) {
                    this.addToList(ore, list);
                }
                continue;
            }
            if (nameId.contains("[") && nameId.contains("]")) {
                String find = "[*]";
                ItemStack stack = null;
                if (nameId.contains(find)) {
                    for (int index = 0; index < 1 || stack != null; ++index) {
                        stack = this.getStack(modId, nameId.replace(find, "" + index), meta);
                        this.addToList(stack, list);
                    }
                    continue;
                }
                Pattern pattern = Pattern.compile("(\\[(\\d*)-(\\d*)\\])");
                Matcher matcher = pattern.matcher(nameId);
                if (!matcher.find()) continue;
                find = matcher.group(1);
                int start = this.getInt(matcher.group(2));
                int end = this.getInt(matcher.group(3));
                for (int index = start; index <= end; ++index) {
                    stack = this.getStack(modId, nameId.replace(find, "" + index), meta);
                    this.addToList(stack, list);
                }
                continue;
            }
            this.addToList(this.getStack(modId, nameId, meta), list);
        }
        return list;
    }

    private int getInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private ItemStack getStack(String modId, String nameId, int meta) {
        ResourceLocation resource = new ResourceLocation(modId, nameId);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)resource);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Block block = (Block)Block.field_149771_c.getObjectBypass((Object)resource);
        if (block != null) {
            return new ItemStack(block, 1, meta);
        }
        return null;
    }

    private void addToList(ItemStack stack, ArrayList<ItemStack> list) {
        if (stack == null || list == null || !(stack.func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (list.contains(stack)) {
            return;
        }
        list.add(stack);
    }
}

