/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.item;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.input.Keyboard;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.block.BlockPlatform;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;
import shetiphian.platforms.common.helpers.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class ItemBlockPlatform
extends ItemBlock
implements IColored {
    private String[] materials = new String[]{".wood", ".stone", ".metal"};
    private String[] types = new String[]{".flat", ".ramp", ".floor", ".frame", ".rise", ".rail", "", "", "", ""};

    public ItemBlockPlatform(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Item)this, 1, 50));
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_FLAT);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_RAMP);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_FLOOR);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_FRAME);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_RISE);
        this.addStack(list, EnumHelper.EnumPlatform.WOOD_RAIL);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_FLAT);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_RAMP);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_FLOOR);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_FRAME);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_RISE);
        this.addStack(list, EnumHelper.EnumPlatform.STONE_RAIL);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_FLAT);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_RAMP);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_FLOOR);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_FRAME);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_RISE);
        this.addStack(list, EnumHelper.EnumPlatform.METAL_RAIL);
    }

    private void addStack(List<ItemStack> list, EnumHelper.EnumPlatform platform) {
        ItemStack stack = PlatformHelper.getStack(platform, "", "");
        if (stack != null) {
            list.add(stack);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        String name = this.func_77658_a();
        int metadata = itemStack.func_77952_i();
        if (metadata == 50) {
            return name + ".platformer";
        }
        try {
            name = name + this.materials[metadata / 10];
        }
        catch (Exception e) {
            name = name + "material";
        }
        try {
            name = name + this.types[metadata % 10];
        }
        catch (Exception e) {
            name = name + "type";
        }
        return name;
    }

    public int func_77647_b(int dmg) {
        return dmg == 50 || dmg % 10 > 4 ? 15 : dmg / 10 * 5 + dmg % 10;
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        int type = stack.func_77952_i() % 10;
        boolean hasPlacementOverride = type == 3 && player.func_70093_af() || type == 4 && side.func_176740_k() == EnumFacing.Axis.Y && world.func_175623_d(pos.func_177972_a(side));
        return hasPlacementOverride || super.func_179222_a(world, pos, side, player, stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        int type = stack.func_77952_i() % 10;
        if (type == 3 && player.func_70093_af() && (state = world.func_180495_p(pos)).func_177230_c() instanceof BlockPlatform && BlockPlatform.getEnumPlatform((IBlockState)state).TYPE == EnumHelper.EnumPlatformType.FRAME) {
            BlockPos sPos = pos;
            for (int scan = 1; scan < 17; scan = (int)((byte)(scan + 1))) {
                if (world.func_175623_d(sPos = sPos.func_177984_a())) {
                    if (this.placePlatform(stack, world, sPos, player.func_174811_aO(), 0) && !player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    SoundType soundtype = this.field_150939_a.func_185467_w();
                    world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    return EnumActionResult.FAIL;
                }
                state = world.func_180495_p(sPos);
                if (!(state.func_177230_c() instanceof BlockPlatform) || BlockPlatform.getEnumPlatform((IBlockState)state).TYPE != EnumHelper.EnumPlatformType.FRAME) break;
            }
        }
        if (type == 4 && facing.func_176740_k() == EnumFacing.Axis.Y && world.func_175623_d(pos.func_177972_a(facing))) {
            if (this.placeBlockAt(stack, player, world, pos.func_177972_a(facing), facing, hitX, hitY, hitZ, Values.blockPlatform.func_176223_P()) && !player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            SoundType soundtype = this.field_150939_a.func_185467_w();
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        int dmg = stack.func_77952_i();
        if (dmg == 50) {
            return Function.setBlock((World)world, (BlockPos)pos, (IBlockState)this.func_179223_d().func_176223_P().func_177226_a(BlockPlatform.VARIANT, (Comparable)((Object)BlockPlatform.EnumType.PLATFORMER)), (boolean)false);
        }
        if (dmg > 50) {
            return false;
        }
        EnumFacing direction = player.func_174811_aO();
        int platformType = dmg % 10;
        if (platformType > 4) {
            return false;
        }
        Triple<BlockPos, EnumFacing, Integer> placement = ItemBlockPlatform.getPlacementData(platformType, direction, world, pos, side, hitX, hitZ);
        return placement != null && this.placePlatform(stack, world, (BlockPos)placement.getLeft(), (EnumFacing)placement.getMiddle(), (Integer)placement.getRight());
    }

    public static Triple<BlockPos, EnumFacing, Integer> getPlacementData(int platformType, EnumFacing direction, World world, BlockPos pos, EnumFacing side, double hitX, double hitZ) {
        TileEntityTypeBase oTile;
        int partType = 0;
        boolean setDirection = true;
        if (((platformType == 0 || platformType == 2) && side.func_176740_k() != EnumFacing.Axis.Y || platformType == 4) && (oTile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177972_a(side.func_176734_d()))) != null) {
            boolean zAxis = direction.func_176740_k() == EnumFacing.Axis.Z;
            byte oType = TileHelper.getType(oTile);
            if (oTile.func_145832_p() == platformType) {
                if ((platformType == 0 || platformType == 2) && oType == 4 || platformType == 4 || zAxis && side.func_176740_k() != EnumFacing.Axis.Z || !zAxis && side.func_176740_k() != EnumFacing.Axis.X) {
                    direction = oTile.getFacing();
                    partType = oType;
                    setDirection = false;
                }
            } else if (side == EnumFacing.UP && platformType == 4 && oTile instanceof TileEntityTypeBaseWithRail) {
                direction = oTile.getFacing();
                EnumHelper.EnumPlatform rail = TileHelper.getRail(oTile);
                if (rail != null && rail.TYPE == EnumHelper.EnumPlatformType.RISE) {
                    if (oTile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
                        if (oType > 3) {
                            return null;
                        }
                        partType = oType;
                    } else {
                        IBlockState stateup = world.func_180495_p(pos.func_177984_a());
                        if (oType > 1 || !stateup.func_177230_c().func_149688_o(stateup).func_76222_j()) {
                            return null;
                        }
                        pos = pos.func_177984_a();
                        partType = oType;
                    }
                    setDirection = false;
                }
            }
        }
        if (setDirection) {
            boolean zAxis = direction.func_176740_k() == EnumFacing.Axis.Z;
            switch (platformType) {
                case 0: 
                case 2: {
                    if (zAxis) {
                        if (hitX > (double)0.4f && hitX < (double)0.6f) {
                            partType = 10;
                            break;
                        }
                        if (direction == EnumFacing.SOUTH) {
                            partType = hitX > 0.5 ? 0 : 1;
                            break;
                        }
                        partType = hitX > 0.5 ? 1 : 0;
                        break;
                    }
                    if (hitZ > (double)0.4f && hitZ < (double)0.6f) {
                        partType = 10;
                        break;
                    }
                    if (direction == EnumFacing.WEST) {
                        partType = hitZ > 0.5 ? 0 : 1;
                        break;
                    }
                    partType = hitZ > 0.5 ? 1 : 0;
                    break;
                }
                case 1: {
                    if (zAxis) {
                        if (hitX > (double)0.4f && hitX < (double)0.6f) {
                            partType = 2;
                            break;
                        }
                        if (direction == EnumFacing.SOUTH) {
                            partType = hitX > 0.5 ? 0 : 1;
                            break;
                        }
                        partType = hitX > 0.5 ? 1 : 0;
                        break;
                    }
                    if (hitZ > (double)0.4f && hitZ < (double)0.6f) {
                        partType = 2;
                        break;
                    }
                    if (direction == EnumFacing.WEST) {
                        partType = hitZ > 0.5 ? 0 : 1;
                        break;
                    }
                    partType = hitZ > 0.5 ? 1 : 0;
                    break;
                }
                case 4: {
                    partType = 0;
                    if (side.func_176740_k() == EnumFacing.Axis.Y) {
                        if (hitX <= 0.5 && hitZ < 0.5) {
                            direction = hitX < hitZ ? EnumFacing.SOUTH : EnumFacing.WEST;
                            break;
                        }
                        if (hitX > 0.5 && hitZ <= 0.5) {
                            direction = 1.0 - hitX < hitZ ? EnumFacing.NORTH : EnumFacing.WEST;
                            break;
                        }
                        if (hitX <= 0.5 && hitZ > 0.5) {
                            direction = hitX < 1.0 - hitZ ? EnumFacing.SOUTH : EnumFacing.EAST;
                            break;
                        }
                        if (!(hitX > 0.5) || !(hitZ >= 0.5)) break;
                        direction = hitX > hitZ ? EnumFacing.NORTH : EnumFacing.EAST;
                        break;
                    }
                    direction = side.func_176734_d().func_176735_f();
                }
            }
        }
        if (platformType < 3 && side.func_176740_k() != EnumFacing.Axis.Y && side.func_176740_k() != direction.func_176740_k()) {
            partType = partType == 0 ? 1 : (partType == 1 ? 0 : partType);
        }
        return Triple.of((Object)pos, (Object)direction, (Object)partType);
    }

    private boolean placePlatform(ItemStack stack, World world, BlockPos pos, EnumFacing direction, int partType) {
        NBTTagCompound nbtTag;
        EnumHelper.EnumPlatform platform = EnumHelper.getPlatform(stack);
        IBlockState newState = this.func_179223_d().func_176223_P().func_177226_a(BlockPlatform.VARIANT, (Comparable)((Object)BlockPlatform.EnumType.byPlatform(platform)));
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)newState, (boolean)false)) {
            return false;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile == null) {
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
            return false;
        }
        if (stack.func_77942_o() && (nbtTag = stack.func_77978_p()) != null && nbtTag.func_74764_b("texture1") && nbtTag.func_74764_b("texture2")) {
            tile.setTextures(nbtTag.func_74779_i("texture1"), nbtTag.func_74779_i("texture2"));
        }
        TileHelper.setType(tile, partType);
        tile.setFacing(direction);
        Values.blockPlatform.func_189540_a(newState, world, pos, Values.blockPlatform);
        world.func_175685_c(pos, Values.blockPlatform);
        return true;
    }

    public int getColorFor(IColored.Data data, int index) {
        NBTTagCompound nbtTag;
        int tint = 0xFFFFFF;
        if (index > 0 && index < 5 && data.stack != null && data.stack.func_77942_o() && (nbtTag = data.stack.func_77978_p()) != null) {
            index = index > 2 ? index - 2 : index;
            ItemStack stack = CraftHelper.getDeconStack(nbtTag.func_74779_i("texture" + index));
            if (stack != null) {
                return Platforms.proxy.getTint(stack);
            }
        }
        return tint;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        if (stack.func_77942_o()) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String[] lines = PlatformHelper.getTooltip(stack).split("<br>");
                Collections.addAll(tooltip, lines);
            } else {
                tooltip.add(Localization.get((String)"info.shetiphian.holdshift.txt"));
            }
        }
    }
}

