/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.asm.Hooks;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.block.properties.UnlistedPropertyTile;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.helpers.CraftHelper;
import shetiphian.platforms.common.helpers.EnumHelper;
import shetiphian.platforms.common.helpers.PlatformHelper;
import shetiphian.platforms.common.helpers.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatFormer;
import shetiphian.platforms.common.tileentity.TileEntityPlatformTypes;
import shetiphian.platforms.common.tileentity.TileEntityTypeBase;
import shetiphian.platforms.common.tileentity.TileEntityTypeBaseWithRail;

public class BlockPlatform
extends Block
implements Hooks.IParticleOverride,
IColored {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final UnlistedPropertyTile EIBS = UnlistedPropertyTile.create((String)"eibs", TileEntityTypeBase.class);
    private static final AxisAlignedBB AABB_FLAT = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB AABB_FLOOR = new AxisAlignedBB(0.0, 0.125, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_FRAME = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockPlatform() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabPlatforms);
        this.func_149711_c(3.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT}, new IUnlistedProperty[]{EIBS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockPlatform.getEnumType(state).getValue();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, pos);
        state = this.func_176221_a(state, world, pos);
        IExtendedBlockState estate = (IExtendedBlockState)state;
        if (tile != null) {
            estate = estate.withProperty((IUnlistedProperty)EIBS, (Object)tile);
        }
        return estate;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        EnumType platform = BlockPlatform.getEnumType(state);
        if (platform == EnumType.PLATFORMER) {
            return new TileEntityPlatFormer();
        }
        switch (platform.platform.TYPE) {
            case FLAT: {
                return new TileEntityPlatformTypes.TileEntityPlatformFlat();
            }
            case RAMP: {
                return new TileEntityPlatformTypes.TileEntityPlatformRamp();
            }
            case FLOOR: {
                return new TileEntityPlatformTypes.TileEntityPlatformFloor();
            }
            case FRAME: {
                return new TileEntityPlatformTypes.TileEntityPlatformFrame();
            }
            case RISE: {
                return new TileEntityPlatformTypes.TileEntityPlatformRise();
            }
        }
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return BlockPlatform.getEnumType(state) == EnumType.PLATFORMER;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return BlockPlatform.getEnumType(world.func_180495_p(pos)) != EnumType.PLATFORMER;
    }

    public int func_180651_a(IBlockState state) {
        return -1;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return BlockPlatform.getEnumPlatform((IBlockState)world.func_180495_p((BlockPos)pos)).MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD ? 2.0f : 3.0f;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        if (BlockPlatform.getEnumPlatform((IBlockState)world.func_180495_p((BlockPos)pos)).MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD) {
            return true;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, pos);
        EnumHelper.EnumPlatform rail = TileHelper.getRail(tile);
        return rail != null && rail.MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD;
    }

    public Material func_149688_o(IBlockState state) {
        EnumHelper.EnumPlatformMaterial material = BlockPlatform.getEnumPlatform((IBlockState)state).MATERIAL;
        return material == EnumHelper.EnumPlatformMaterial.METAL ? Material.field_151573_f : (material == EnumHelper.EnumPlatformMaterial.STONE ? Material.field_151576_e : Material.field_151575_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            return Block.field_185505_j;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, pos);
        return tile != null ? this.getBounds(tile, platform) : Block.field_185505_j;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntityTypeBase tile;
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        if (!(platform.TYPE != EnumHelper.EnumPlatformType.FLAT && platform.TYPE != EnumHelper.EnumPlatformType.RISE || (tile = TileHelper.getPlatformTile((IBlockAccess)world, pos)) == null || platform.TYPE != EnumHelper.EnumPlatformType.RISE && !TileHelper.hasRail(tile))) {
            RayTraceResult areaHit = null;
            tile.rayTracing = true;
            double hitDist = 100.0;
            for (int check = 1; check < 3; check = (int)((byte)(check + 1))) {
                tile.traceBlock = check;
                RayTraceResult mop = this.func_185503_a(pos, start, end, this.getBounds(tile, platform));
                if (mop == null) continue;
                mop.subHit = check;
                double ringDist = mop.field_72307_f.func_72436_e(start);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = mop;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                tile.traceBlock = areaHit.subHit;
                return areaHit;
            }
            tile.rayTracing = false;
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    private AxisAlignedBB getBounds(TileEntityTypeBase tile, EnumHelper.EnumPlatform platform) {
        int type = TileHelper.getType(tile);
        EnumFacing facing = tile.getFacing();
        switch (platform.TYPE) {
            case FLAT: {
                if (type < 10 && TileHelper.hasRail(tile) && tile.rayTracing && tile.traceBlock > 0) {
                    type = type >= 2 && type <= 5 ? 2 : (type >= 6 && type <= 9 ? 3 : (int)type);
                } else {
                    return AABB_FLAT;
                }
            }
            case RISE: {
                if (type == 3) {
                    type = 0;
                    if (tile.traceBlock == 2) {
                        facing = facing.func_176735_f();
                    }
                }
                double[] railBounds = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
                if (type != 1) {
                    railBounds[0] = facing == EnumFacing.NORTH ? 0.8125 : 0.0;
                    railBounds[3] = facing == EnumFacing.SOUTH ? 0.1875 : 1.0;
                    railBounds[2] = facing == EnumFacing.EAST ? 0.8125 : 0.0;
                    double d = railBounds[5] = facing == EnumFacing.WEST ? 0.1875 : 1.0;
                    if (type == 2) {
                        railBounds[0] = facing == EnumFacing.EAST ? 0.8125 : railBounds[0];
                        railBounds[3] = facing == EnumFacing.WEST ? 0.1875 : railBounds[3];
                        railBounds[2] = facing == EnumFacing.SOUTH ? 0.8125 : railBounds[2];
                        railBounds[5] = facing == EnumFacing.NORTH ? 0.1875 : railBounds[5];
                    }
                } else {
                    railBounds[0] = facing == EnumFacing.SOUTH ? 0.8125 : 0.0;
                    railBounds[3] = facing == EnumFacing.NORTH ? 0.1875 : 1.0;
                    railBounds[2] = facing == EnumFacing.WEST ? 0.8125 : 0.0;
                    railBounds[5] = facing == EnumFacing.EAST ? 0.1875 : 1.0;
                }
                return new AxisAlignedBB(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]);
            }
            case FLOOR: {
                return AABB_FLOOR;
            }
        }
        return Block.field_185505_j;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)Block.field_185505_j);
            return;
        }
        if (platform.TYPE == EnumHelper.EnumPlatformType.FRAME) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)AABB_FRAME);
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile == null) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)Block.field_185505_j);
            return;
        }
        double minX = world.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockPlatform ? 0.0 : 0.0625;
        double minZ = world.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockPlatform ? 0.0 : 0.0625;
        double maxX = world.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockPlatform ? 1.0 : 0.9375;
        double maxZ = world.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockPlatform ? 1.0 : 0.9375;
        EnumHelper.EnumPlatform railType = TileHelper.getRail(tile);
        EnumFacing facing = tile.getFacing();
        int type = TileHelper.getType(tile);
        switch (platform.TYPE) {
            case FLOOR: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(minX, 0.0, minZ, maxX, 1.0, maxZ));
            }
            case FLAT: {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(minX, -0.125, minZ, maxX, 0.125, maxZ));
                if (railType == null || type > 9) break;
                type = type >= 6 && type <= 9 ? 3 : (type >= 2 && type <= 5 ? 2 : (int)type);
            }
            case RISE: {
                if (type >= 4 || tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToRamp()) break;
                double[] railBounds = new double[]{minX, 0.8125, minZ, maxX, 1.0, maxZ};
                if (type == 3) {
                    railBounds[0] = facing == EnumFacing.EAST ? 0.8125 : minX;
                    railBounds[3] = facing == EnumFacing.WEST ? 0.1875 : maxX;
                    railBounds[2] = facing == EnumFacing.SOUTH ? 0.8125 : minZ;
                    railBounds[5] = facing == EnumFacing.NORTH ? 0.1875 : maxZ;
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]));
                }
                if (type != 1) {
                    railBounds[0] = facing == EnumFacing.NORTH ? 0.8125 : minX;
                    railBounds[3] = facing == EnumFacing.SOUTH ? 0.1875 : maxX;
                    railBounds[2] = facing == EnumFacing.EAST ? 0.8125 : minZ;
                    double d = railBounds[5] = facing == EnumFacing.WEST ? 0.1875 : maxZ;
                    if (type == 2) {
                        railBounds[0] = facing == EnumFacing.EAST ? 0.8125 : railBounds[0];
                        railBounds[3] = facing == EnumFacing.WEST ? 0.1875 : railBounds[3];
                        railBounds[2] = facing == EnumFacing.SOUTH ? 0.8125 : railBounds[2];
                        railBounds[5] = facing == EnumFacing.NORTH ? 0.1875 : railBounds[5];
                    }
                } else {
                    railBounds[0] = facing == EnumFacing.SOUTH ? 0.8125 : minX;
                    railBounds[3] = facing == EnumFacing.NORTH ? 0.1875 : maxX;
                    railBounds[2] = facing == EnumFacing.WEST ? 0.8125 : minZ;
                    double d = railBounds[5] = facing == EnumFacing.EAST ? 0.1875 : maxZ;
                }
                if (platform.TYPE == EnumHelper.EnumPlatformType.RISE) {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(railBounds[0], 0.0, railBounds[2], railBounds[3], 1.0, railBounds[5]));
                    break;
                }
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]));
                break;
            }
            case RAMP: {
                boolean altRail = railType != null && railType.TYPE == EnumHelper.EnumPlatformType.RISE;
                double[] stepBounds = new double[]{minX, 0.0, minZ, maxX, 0.125, maxZ};
                double[] railBounds = new double[]{minX, 1.0, minZ, maxX, 1.125, maxZ};
                for (int step = 0; step < 4; step = (int)((byte)(step + 1))) {
                    if (step > 0) {
                        switch (facing) {
                            case SOUTH: {
                                stepBounds[2] = stepBounds[2] + 0.25;
                                railBounds[2] = stepBounds[2];
                                break;
                            }
                            case WEST: {
                                stepBounds[3] = stepBounds[3] - 0.25;
                                railBounds[3] = stepBounds[3];
                                break;
                            }
                            case NORTH: {
                                stepBounds[5] = stepBounds[5] - 0.25;
                                railBounds[5] = stepBounds[5];
                                break;
                            }
                            case EAST: {
                                stepBounds[0] = stepBounds[0] + 0.25;
                                railBounds[0] = stepBounds[0];
                            }
                        }
                    }
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(stepBounds[0], stepBounds[1], stepBounds[2], stepBounds[3], stepBounds[4], stepBounds[5]));
                    if (railType != null && type != 2 && !altRail) {
                        if (facing.func_176740_k() == EnumFacing.Axis.Z) {
                            railBounds[0] = facing == EnumFacing.SOUTH && type == 1 || facing == EnumFacing.NORTH && type == 0 ? 0.8125 : minX;
                            railBounds[3] = facing == EnumFacing.SOUTH && type == 0 || facing == EnumFacing.NORTH && type == 1 ? 0.1875 : maxX;
                        } else {
                            railBounds[2] = facing == EnumFacing.WEST && type == 1 || facing == EnumFacing.EAST && type == 0 ? 0.8125 : minZ;
                            railBounds[5] = facing == EnumFacing.WEST && type == 0 || facing == EnumFacing.EAST && type == 1 ? 0.1875 : maxZ;
                        }
                        railBounds[1] = step == 0 ? 0.0 : stepBounds[1] + 1.0;
                        railBounds[4] = stepBounds[4] + 1.0;
                        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]));
                    }
                    stepBounds[1] = stepBounds[1] + 0.25;
                    stepBounds[4] = stepBounds[4] + 0.25;
                }
                if (railType == null || type == 2 || !altRail) break;
                if (type != 1) {
                    railBounds[0] = facing == EnumFacing.NORTH ? 0.8125 : minX;
                    railBounds[3] = facing == EnumFacing.SOUTH ? 0.1875 : maxX;
                    railBounds[2] = facing == EnumFacing.EAST ? 0.8125 : minZ;
                    railBounds[5] = facing == EnumFacing.WEST ? 0.1875 : maxZ;
                } else {
                    railBounds[0] = facing == EnumFacing.SOUTH ? 0.8125 : minX;
                    railBounds[3] = facing == EnumFacing.NORTH ? 0.1875 : maxX;
                    railBounds[2] = facing == EnumFacing.WEST ? 0.8125 : minZ;
                    railBounds[5] = facing == EnumFacing.EAST ? 0.1875 : maxZ;
                }
                railBounds[4] = 2.0;
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)new AxisAlignedBB(railBounds[0], railBounds[1], railBounds[2], railBounds[3], railBounds[4], railBounds[5]));
                break;
            }
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        return platform == EnumHelper.EnumPlatform.PLATFORMER || (platform.TYPE == EnumHelper.EnumPlatformType.FRAME || platform.TYPE == EnumHelper.EnumPlatformType.FLOOR) && side == EnumFacing.UP;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        EnumHelper.EnumPlatformTorch torch;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPlatFormer) {
            ((TileEntityPlatFormer)tile).dropItems();
        } else if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFrame && ((torch = ((TileEntityPlatformTypes.TileEntityPlatformFrame)tile).getTorchType()) == EnumHelper.EnumPlatformTorch.REDSTONE_ON || torch == EnumHelper.EnumPlatformTorch.LAMP_ON)) {
            world.func_175685_c(pos, (Block)this);
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                world.func_175685_c(pos.func_177984_a(), (Block)this);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            ret.add(new ItemStack((Block)this, 1, 50));
            return ret;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, pos);
        if (tile != null) {
            EnumHelper.EnumPlatformTorch torch;
            EnumHelper.EnumPlatform rail;
            ItemStack stack = this.getBaseStack(tile);
            if (stack != null) {
                ret.add(stack);
            }
            if ((rail = TileHelper.getRail(tile)) != null && (stack = this.getRailStack((TileEntityTypeBaseWithRail)tile)) != null) {
                ret.add(stack);
            }
            if ((torch = TileHelper.getTorch(tile)) != null && torch != EnumHelper.EnumPlatformTorch.NONE) {
                ret.add(torch.getItemStack());
                if (torch.isUpgrade()) {
                    ret.add(torch.getBaseItemStack());
                }
            }
        }
        return ret;
    }

    private ItemStack getBaseStack(TileEntityTypeBase tile) {
        if (tile != null) {
            EnumHelper.EnumPlatform enumplatform = BlockPlatform.getEnumPlatform(tile.func_145831_w().func_180495_p(tile.func_174877_v()));
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isRail()) {
                enumplatform = EnumHelper.getPlatform(enumplatform.MATERIAL, EnumHelper.EnumPlatformType.RAIL);
            }
            return PlatformHelper.getStack(enumplatform, tile.getTextures()[0], tile.getTextures()[1]);
        }
        return null;
    }

    private ItemStack getRailStack(TileEntityTypeBaseWithRail tile) {
        if (tile != null) {
            return PlatformHelper.getStack(tile.getRail(), tile.getTextures()[2], tile.getTextures()[3]);
        }
        return null;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (player == null || !player.func_70093_af()) {
            return;
        }
        ItemStack currentItem = player.func_184614_ca();
        if (currentItem == null) {
            return;
        }
        if (currentItem.func_77973_b().getHarvestLevel(currentItem, "wrench") < 0) {
            return;
        }
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((IBlockState)world.func_180495_p((BlockPos)pos)).TYPE;
        if (platformType == EnumHelper.EnumPlatformType.RAIL || platformType == EnumHelper.EnumPlatformType.RISE) {
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile == null || !TileHelper.hasRail(tile) && !TileHelper.hasTorch(tile)) {
            return;
        }
        ItemStack stack = null;
        if (platformType == EnumHelper.EnumPlatformType.FRAME) {
            EnumHelper.EnumPlatformTorch torchType = TileHelper.getTorch(tile);
            stack = torchType != null ? torchType.getItemStack() : null;
        } else if (tile instanceof TileEntityTypeBaseWithRail) {
            stack = this.getRailStack((TileEntityTypeBaseWithRail)tile);
        }
        if (stack != null) {
            Function.giveItem((EntityPlayer)player, (ItemStack)stack);
            if (platformType == EnumHelper.EnumPlatformType.FRAME) {
                TileHelper.removeTorch(tile);
                world.func_180496_d(pos, (Block)this);
            } else {
                TileHelper.removeRail(tile);
                if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
                    this.editRampRail((TileEntityPlatformTypes.TileEntityPlatformRamp)tile);
                }
                if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFloor) {
                    this.editFloorRail((TileEntityPlatformTypes.TileEntityPlatformFloor)tile);
                }
            }
            Function.syncTile((TileEntity)tile);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean isGlowstone;
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            if (!world.field_72995_K) {
                player.openGui((Object)Platforms.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        if (heldItem == null) {
            return false;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        boolean bl = isGlowstone = heldItem.func_77973_b() == Items.field_151114_aO;
        if (heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA) || heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || isGlowstone) {
            if (platform.TYPE == EnumHelper.EnumPlatformType.FRAME) {
                EnumHelper.EnumPlatformTorch torch;
                boolean placed = false;
                if (!TileHelper.hasTorch(tile) && !isGlowstone) {
                    placed = heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150429_aA) ? TileHelper.setTorch(tile, this.isPowered(world, pos) ? EnumHelper.EnumPlatformTorch.REDSTONE_OFF : EnumHelper.EnumPlatformTorch.REDSTONE_ON) : TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LIGHT);
                } else if (isGlowstone && (torch = TileHelper.getTorch(tile)) != null) {
                    switch (torch) {
                        case REDSTONE_OFF: {
                            placed = TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_ON);
                            break;
                        }
                        case REDSTONE_ON: {
                            placed = TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_OFF);
                            break;
                        }
                        case LIGHT: {
                            placed = TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.GLOWSTONE);
                        }
                    }
                }
                if (placed) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --heldItem.field_77994_a;
                    }
                    world.func_184133_a(player, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    world.func_175685_c(pos, (Block)this);
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                        world.func_175685_c(pos.func_177984_a(), (Block)this);
                    }
                    Function.syncTile((TileEntity)tile);
                    return true;
                }
            }
            return false;
        }
        if (heldItem.func_77973_b() == Item.func_150898_a((Block)this) && BlockPlatform.canPlaceRailOn(tile) && TileHelper.setRail(tile, heldItem)) {
            EnumHelper.EnumPlatform rail;
            if (!player.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
            }
            if ((rail = TileHelper.getRail(tile)) != null) {
                SoundEvent sound = rail.MATERIAL == EnumHelper.EnumPlatformMaterial.METAL ? SoundEvents.field_187772_dn : (rail.MATERIAL == EnumHelper.EnumPlatformMaterial.STONE ? SoundEvents.field_187845_fY : SoundEvents.field_187891_gV);
                world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                Function.syncTile((TileEntity)tile);
                if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp && TileHelper.getType(tile) < 2) {
                    this.editRampRail((TileEntityPlatformTypes.TileEntityPlatformRamp)tile);
                }
                if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFloor && TileHelper.getType(tile) < 9) {
                    this.editFloorRail((TileEntityPlatformTypes.TileEntityPlatformFloor)tile);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canPlaceRailOn(TileEntityTypeBase tile) {
        if (tile instanceof TileEntityTypeBaseWithRail && !TileHelper.hasRail(tile)) {
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat || tile instanceof TileEntityPlatformTypes.TileEntityPlatformFloor) {
                return TileHelper.getType(tile) < 10;
            }
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp && TileHelper.getType(tile) != 2) {
                IBlockState stateUp = tile.func_145831_w().func_180495_p(tile.func_174877_v().func_177984_a());
                return stateUp.func_185904_a().func_76222_j();
            }
        }
        return false;
    }

    private void editRampRail(TileEntityPlatformTypes.TileEntityPlatformRamp tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (tile.getRampType() < 2 && tile.hasRail()) {
            TileEntityTypeBase oTile;
            if (above != this && above.func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                EnumHelper.EnumPlatform platform = EnumHelper.getPlatform(tile.getRail().MATERIAL.VALUE, 4);
                Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)world.func_180495_p(pos).func_177226_a(VARIANT, (Comparable)((Object)EnumType.byPlatform(platform))), (boolean)false);
            }
            if ((oTile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177984_a())) instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
                oTile.setFacing(tile.getFacing());
                oTile.setTextures(tile.getTextures()[2], tile.getTextures()[3]);
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setRiseType(tile.getRampType());
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setLinkedToRamp(true);
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setIsRail(tile.getRail().TYPE == EnumHelper.EnumPlatformType.RAIL);
                Function.syncTile((TileEntity)oTile);
            }
        } else {
            TileEntityTypeBase oTile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177984_a());
            if (oTile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).isLinkedToRamp()) {
                Function.removeBlock((World)world, (BlockPos)pos.func_177984_a(), (boolean)true);
            }
        }
    }

    private void editFloorRail(TileEntityPlatformTypes.TileEntityPlatformFloor tile) {
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        byte type = tile.getFloorType();
        if (type < 10 && tile.hasRail()) {
            TileEntityTypeBase oTile;
            if (above != this && above.func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                EnumHelper.EnumPlatform platform = EnumHelper.getPlatform(tile.getRail().MATERIAL.VALUE, 4);
                Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)world.func_180495_p(pos).func_177226_a(VARIANT, (Comparable)((Object)EnumType.byPlatform(platform))), (boolean)false);
            }
            if ((oTile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177984_a())) instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
                oTile.setFacing(tile.getFacing());
                oTile.setTextures(tile.getTextures()[2], tile.getTextures()[3]);
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setRiseType(type >= 6 && type <= 9 ? 3 : (type >= 2 && type <= 5 ? 2 : (int)type));
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setLinkedToFloor(true);
                ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).setIsRail(tile.getRail().TYPE == EnumHelper.EnumPlatformType.RAIL);
                Function.syncTile((TileEntity)oTile);
            }
        } else {
            TileEntityTypeBase oTile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177984_a());
            if (oTile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)oTile).isLinkedToFloor()) {
                Function.removeBlock((World)world, (BlockPos)pos.func_177984_a(), (boolean)true);
            }
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        ForgeModContainer.fullBoundingBoxLadders = true;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
    }

    private boolean resetAndReturn(boolean isLadder, Entity entity) {
        if (!entity.func_70093_af()) {
            ForgeModContainer.fullBoundingBoxLadders = false;
        }
        return isLadder;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer) || entity.func_184218_aH()) {
            return this.resetAndReturn(false, (Entity)entity);
        }
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(state);
        if (platform == EnumHelper.EnumPlatform.PLATFORMER) {
            return this.resetAndReturn(false, (Entity)entity);
        }
        EnumHelper.EnumPlatformType platformType = platform.TYPE;
        if (platformType == EnumHelper.EnumPlatformType.FRAME || platformType == EnumHelper.EnumPlatformType.FLOOR) {
            return this.resetAndReturn(true, (Entity)entity);
        }
        if (platformType == EnumHelper.EnumPlatformType.RISE) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            EnumHelper.EnumPlatformType typeDown = BlockPlatform.getEnumPlatform((IBlockState)world.func_180495_p((BlockPos)pos.func_177977_b())).TYPE;
            if (typeDown == EnumHelper.EnumPlatformType.FLAT || typeDown == EnumHelper.EnumPlatformType.RAMP) {
                return this.isLadder(state, world, pos.func_177977_b(), entity);
            }
            if (entity.field_70122_E && typeDown == EnumHelper.EnumPlatformType.FLOOR) {
                return this.resetAndReturn(false, (Entity)entity);
            }
            if (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() != this) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            typeDown = BlockPlatform.getEnumPlatform((IBlockState)world.func_180495_p((BlockPos)pos.func_177979_c((int)2))).TYPE;
            if (entity.field_70122_E && (typeDown == EnumHelper.EnumPlatformType.FLAT || typeDown == EnumHelper.EnumPlatformType.RAMP || typeDown == EnumHelper.EnumPlatformType.FLOOR)) {
                return this.resetAndReturn(false, (Entity)entity);
            }
            return this.resetAndReturn(true, (Entity)entity);
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile(world, pos);
        if (tile == null) {
            return this.resetAndReturn(false, (Entity)entity);
        }
        double vY = entity.field_70163_u - entity.func_70033_W();
        int[] adj = Function.getBlockXZ((double)entity.field_70165_t, (double)entity.field_70161_v);
        boolean onPlatform = world.func_180495_p(new BlockPos(adj[0], pos.func_177956_o(), adj[1])).func_177230_c() instanceof BlockPlatform;
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            if (!onPlatform && vY - (double)((int)vY) < (double)0.1f && world.func_175625_s(pos.func_177977_b()) instanceof TileEntityPlatformTypes.TileEntityPlatformFrame) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            if (!TileHelper.hasRail(tile)) {
                return this.resetAndReturn(false, (Entity)entity);
            }
        }
        boolean atNorth = !onPlatform && entity.field_70161_v - (double)adj[1] > (double)0.7f;
        boolean atSouth = !onPlatform && entity.field_70161_v - (double)adj[1] < (double)0.3f;
        boolean atWest = !onPlatform && entity.field_70165_t - (double)adj[0] > (double)0.7f;
        boolean atEast = !onPlatform && entity.field_70165_t - (double)adj[0] < (double)0.3f;
        EnumFacing facing = tile.getFacing();
        int type = TileHelper.getType(tile);
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            int n = type >= 2 && type <= 5 ? 2 : (type >= 6 && type <= 9 ? 3 : (type == 10 ? 4 : (type = type >= 11 && type <= 14 ? 5 : type)));
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            if (!onPlatform && vY - (double)((int)vY) < (double)0.1f && world.func_175625_s(pos.func_177977_b()) instanceof TileEntityPlatformTypes.TileEntityPlatformFrame && (atNorth && facing == EnumFacing.SOUTH || atEast && facing == EnumFacing.WEST || atSouth && facing == EnumFacing.NORTH || atWest && facing == EnumFacing.EAST)) {
                return this.resetAndReturn(true, (Entity)entity);
            }
            if (!TileHelper.hasRail(tile)) {
                return this.resetAndReturn(false, (Entity)entity);
            }
        }
        boolean isLadder = false;
        if (atNorth && (facing == EnumFacing.WEST && type == 0 || facing == EnumFacing.EAST && type == 1)) {
            isLadder = true;
        }
        if (atSouth && (facing == EnumFacing.WEST && type == 1 || facing == EnumFacing.EAST && type == 0)) {
            isLadder = true;
        }
        if (atWest && (facing == EnumFacing.SOUTH && type == 0 || facing == EnumFacing.NORTH && type == 1)) {
            isLadder = true;
        }
        if (atEast && (facing == EnumFacing.SOUTH && type == 1 || facing == EnumFacing.NORTH && type == 0)) {
            isLadder = true;
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFlat) {
            if (atNorth && (facing == EnumFacing.WEST && type == 3 || facing == EnumFacing.NORTH && type == 3)) {
                isLadder = true;
            }
            if (atSouth && (facing == EnumFacing.SOUTH && type == 3 || facing == EnumFacing.EAST && type == 3)) {
                isLadder = true;
            }
            if (atWest && (facing == EnumFacing.SOUTH && type == 3 || facing == EnumFacing.WEST && type == 3)) {
                isLadder = true;
            }
            if (atEast && (facing == EnumFacing.NORTH && type == 3 || facing == EnumFacing.EAST && type == 3)) {
                isLadder = true;
            }
        }
        return this.resetAndReturn(isLadder, (Entity)entity);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((IBlockState)state).TYPE;
        if (platformType == EnumHelper.EnumPlatformType.RAMP) {
            BlockPos posForward;
            IBlockState stateForward;
            int altSupport;
            if (TileHelper.hasRail(tile) && TileHelper.getType(tile) < 2 && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                TileHelper.removeRail(tile);
                Function.syncTile((TileEntity)tile);
            }
            if (world.func_175623_d(pos.func_177977_b())) {
                altSupport = 2;
            } else {
                IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
                Block blockDown = stateDown.func_177230_c();
                if (blockDown instanceof BlockFence) {
                    altSupport = 1;
                } else {
                    AxisAlignedBB aabbDown = stateDown.func_185900_c((IBlockAccess)world, pos.func_177977_b());
                    altSupport = aabbDown.field_72337_e >= 1.0 ? (aabbDown.field_72340_a > 0.0625 || aabbDown.field_72339_c > 0.0625 || aabbDown.field_72336_d < 0.9375 || aabbDown.field_72334_f < 0.9375 ? 1 : 0) : 2;
                }
            }
            if (tile != null && !world.func_175623_d(pos.func_177972_a(tile.getFacing())) && !(stateForward = world.func_180495_p(posForward = pos.func_177972_a(tile.getFacing()))).func_185904_a().func_76222_j()) {
                AxisAlignedBB aabbForward = stateForward.func_185900_c((IBlockAccess)world, posForward);
                altSupport += state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_72326_a(aabbForward.func_186670_a(posForward).func_186662_g(0.1)) ? 3 : 0;
            }
            TileHelper.setAltSupport(tile, altSupport);
            Function.syncTile((TileEntity)tile);
        } else if (platformType == EnumHelper.EnumPlatformType.FLOOR) {
            int altSupport;
            if (TileHelper.hasRail(tile) && TileHelper.getType(tile) < 9 && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                TileHelper.removeRail(tile);
                Function.syncTile((TileEntity)tile);
            }
            if (world.func_175623_d(pos.func_177977_b())) {
                altSupport = 2;
            } else {
                IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
                Block blockDown = stateDown.func_177230_c();
                if (blockDown instanceof BlockFence) {
                    altSupport = 1;
                } else {
                    AxisAlignedBB aabbDown = stateDown.func_185900_c((IBlockAccess)world, pos.func_177977_b());
                    altSupport = aabbDown.field_72337_e >= 1.0 ? (aabbDown.field_72340_a > 0.0625 || aabbDown.field_72339_c > 0.0625 || aabbDown.field_72336_d < 0.9375 || aabbDown.field_72334_f < 0.9375 ? 1 : 0) : 2;
                }
            }
            TileHelper.setAltSupport(tile, altSupport);
            Function.syncTile((TileEntity)tile);
        } else if (platformType == EnumHelper.EnumPlatformType.FRAME) {
            if (tile != null && TileHelper.hasTorch(tile)) {
                boolean notify = false;
                EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(tile);
                if (torch == EnumHelper.EnumPlatformTorch.REDSTONE_OFF || torch == EnumHelper.EnumPlatformTorch.REDSTONE_ON) {
                    if (this.isPowered(world, pos)) {
                        if (torch != EnumHelper.EnumPlatformTorch.REDSTONE_OFF) {
                            TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.REDSTONE_OFF);
                            notify = true;
                            Function.syncTile((TileEntity)tile);
                        }
                    } else if (torch != EnumHelper.EnumPlatformTorch.REDSTONE_ON) {
                        TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.REDSTONE_ON);
                        notify = true;
                        Function.syncTile((TileEntity)tile);
                    }
                } else if (torch == EnumHelper.EnumPlatformTorch.LAMP_OFF || torch == EnumHelper.EnumPlatformTorch.LAMP_ON) {
                    if (this.isPowered(world, pos)) {
                        if (torch != EnumHelper.EnumPlatformTorch.LAMP_ON) {
                            TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_ON);
                            notify = true;
                            Function.syncTile((TileEntity)tile);
                        }
                    } else if (torch != EnumHelper.EnumPlatformTorch.LAMP_OFF) {
                        TileHelper.setTorch(tile, EnumHelper.EnumPlatformTorch.LAMP_OFF);
                        notify = true;
                        Function.syncTile((TileEntity)tile);
                    }
                }
                if (notify) {
                    world.func_175685_c(pos, (Block)this);
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                        world.func_175685_c(pos.func_177984_a(), (Block)this);
                    }
                }
            }
        } else if (platformType == EnumHelper.EnumPlatformType.RISE) {
            TileEntityTypeBase oTile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177977_b());
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToRamp() && !(oTile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp)) {
                Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            }
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToFloor() && !(oTile instanceof TileEntityPlatformTypes.TileEntityPlatformFloor)) {
                Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            }
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public boolean rotateBlock(TileEntityTypeBase tile, boolean changeType) {
        TileEntityTypeBase oTile;
        if (tile == null) {
            return false;
        }
        EnumHelper.EnumPlatform platform = BlockPlatform.getEnumPlatform(tile.func_145831_w().func_180495_p(tile.func_174877_v()));
        if (platform == null || platform == EnumHelper.EnumPlatform.PLATFORMER) {
            return false;
        }
        if (platform.TYPE == EnumHelper.EnumPlatformType.FRAME) {
            changeType = false;
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise && ((oTile = TileHelper.getPlatformTile((IBlockAccess)tile.func_145831_w(), tile.func_174877_v().func_177977_b())) instanceof TileEntityPlatformTypes.TileEntityPlatformRamp || oTile instanceof TileEntityPlatformTypes.TileEntityPlatformFloor && ((TileEntityPlatformTypes.TileEntityPlatformRise)tile).isLinkedToFloor())) {
            return this.rotateBlock(oTile, changeType);
        }
        if (!changeType) {
            tile.setFacing(tile.getFacing().func_176746_e());
        } else {
            int type = TileHelper.getType(tile);
            switch (platform.TYPE) {
                case FLAT: 
                case FLOOR: {
                    type = type >= (TileHelper.hasRail(tile) ? 9 : 14) ? 0 : type + 1;
                    break;
                }
                case RAMP: {
                    type = type >= (TileHelper.hasRail(tile) ? 1 : 2) ? 0 : type + 1;
                    break;
                }
                case RISE: {
                    type = type == 3 ? 0 : type + 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            TileHelper.setType(tile, type);
        }
        Function.syncTile((TileEntity)tile);
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRamp) {
            this.editRampRail((TileEntityPlatformTypes.TileEntityPlatformRamp)tile);
        }
        if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformFloor) {
            this.editFloorRail((TileEntityPlatformTypes.TileEntityPlatformFloor)tile);
        }
        return true;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return null;
    }

    private boolean isPowered(World world, BlockPos pos) {
        if (world.func_175709_b(pos.func_177977_b(), EnumFacing.DOWN)) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos.func_177972_a(facing));
            if (tile != null && TileHelper.hasTorch(tile) || world.func_175651_c(pos.func_177972_a(facing), facing) <= 1) continue;
            return true;
        }
        return false;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? this.func_180656_a(state, world, pos, side) : 0;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityTypeBase tile;
        if (side == EnumFacing.UP) {
            return 0;
        }
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((IBlockState)state).TYPE;
        if (platformType == EnumHelper.EnumPlatformType.FRAME && (tile = TileHelper.getPlatformTile(world, pos)) != null) {
            EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(tile);
            return torch == EnumHelper.EnumPlatformTorch.REDSTONE_ON || torch == EnumHelper.EnumPlatformTorch.LAMP_ON ? (side == EnumFacing.DOWN ? 15 : 1) : 0;
        }
        return 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumHelper.EnumPlatformTorch torch;
        TileEntityTypeBase tile;
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((IBlockState)state).TYPE;
        if (platformType == EnumHelper.EnumPlatformType.FRAME && (tile = TileHelper.getPlatformTile(world, pos)) != null && (torch = TileHelper.getTorch(tile)) != null) {
            switch (torch) {
                case REDSTONE_ON: {
                    return Blocks.field_150429_aA.func_149750_m(Blocks.field_150429_aA.func_176223_P());
                }
                case LIGHT: {
                    return Blocks.field_150478_aa.func_149750_m(Blocks.field_150478_aa.func_176223_P());
                }
                case GLOWSTONE: {
                    return Blocks.field_150426_aN.func_149750_m(Blocks.field_150426_aN.func_176223_P());
                }
                case LAMP_ON: {
                    return Blocks.field_150374_bv.func_149750_m(Blocks.field_150374_bv.func_176223_P());
                }
            }
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        boolean isWood = BlockPlatform.getEnumPlatform((IBlockState)state).MATERIAL == EnumHelper.EnumPlatformMaterial.WOOD;
        return "axe".equals(type) && isWood || "pickaxe".equals(type) && isWood;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState state;
        ItemStack stack;
        CraftHelper.MaterialId id;
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile != null && (id = CraftHelper.MaterialId.getFor(tile.getTextures()[1])) != null && (stack = id.toStack()) != null && stack.func_77973_b() instanceof ItemBlock && (state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77973_b().func_77647_b(stack.func_77952_i()))) != null) {
            return ParticleHelper.addDestroyEffects((World)world, (BlockPos)pos, (ParticleManager)effectRenderer, (int)Block.func_176210_f((IBlockState)state));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumHelper.EnumPlatformType platformType = BlockPlatform.getEnumPlatform((IBlockState)state).TYPE;
        if (platformType != EnumHelper.EnumPlatformType.FRAME) {
            return;
        }
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile == null || !TileHelper.hasTorch(tile)) {
            return;
        }
        EnumHelper.EnumPlatformTorch torch = TileHelper.getTorch(tile);
        if (torch != null) {
            double x = (float)pos.func_177958_n() + 0.5f;
            double y = (float)pos.func_177956_o() + 0.75f;
            double z = (float)pos.func_177952_p() + 0.5f;
            switch (torch) {
                case REDSTONE_ON: 
                case LAMP_ON: {
                    float green = torch == EnumHelper.EnumPlatformTorch.REDSTONE_ON ? 0.0f : 0.75f - (rand.nextFloat() - 0.25f);
                    world.func_175688_a(EnumParticleTypes.REDSTONE, x += (double)(rand.nextFloat() - 0.5f) * 0.2, y += (double)(rand.nextFloat() - 0.5f) * 0.2, z += (double)(rand.nextFloat() - 0.5f) * 0.2, 1.0, (double)green, 0.0, new int[0]);
                    break;
                }
                case LIGHT: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        return ParticleHelper.addLandingEffects((WorldServer)world, (BlockPos)pos, (EntityLivingBase)entity, (int)numberOfParticles, (int)this.getParticleStateId(state, (World)world, pos, (Entity)entity, 1));
    }

    public boolean overrideRunningEffects(World world, BlockPos pos, IBlockState state, Entity entity) {
        return ParticleHelper.addRunningEffects((World)world, (BlockPos)pos, (Entity)entity, (int)this.getParticleStateId(state, world, pos, entity, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        BlockPos pos = target.func_178782_a();
        return ParticleHelper.addHitEffects((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b, (ParticleManager)effectRenderer, (int)this.getParticleStateId(state, world, pos, null, world.field_73012_v.nextInt(2)));
    }

    private int getParticleStateId(IBlockState state, World world, BlockPos pos, Entity entity, int tIndex) {
        String[] textures;
        ItemStack stack;
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile != null && (stack = CraftHelper.MaterialId.getFor((textures = tile.getTextures())[tIndex]).toStack()).func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            state = block.func_176203_a(stack.func_77973_b().getMetadata(stack));
        }
        return BlockPlatform.func_176210_f((IBlockState)state);
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityTypeBase tile;
        if (index > 0 && index < 5 && data.world != null && data.pos != null && (tile = TileHelper.getPlatformTile(data.world, data.pos)) != null) {
            if (tile instanceof TileEntityPlatformTypes.TileEntityPlatformRise) {
                index = index > 2 ? index - 2 : index;
            }
            return tile.getTint(index);
        }
        return 0xFFFFFF;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityTypeBase tile = TileHelper.getPlatformTile((IBlockAccess)world, pos);
        if (tile != null) {
            if (target.subHit > 0 && TileHelper.hasRail(tile)) {
                return this.getRailStack((TileEntityTypeBaseWithRail)tile);
            }
            return this.getBaseStack(tile);
        }
        return new ItemStack((Block)this, 1, 50);
    }

    public static EnumHelper.EnumPlatform getEnumPlatform(IBlockState state) {
        return BlockPlatform.getEnumType(state).getPlatform();
    }

    private static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.WOOD_FLAT;
            Platforms.errorPropertyNotFound("BlockPlatform.VARIANT", "WOOD_FLAT", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        WOOD_FLAT(0, EnumHelper.EnumPlatform.WOOD_FLAT),
        WOOD_RAMP(1, EnumHelper.EnumPlatform.WOOD_RAMP),
        WOOD_FLOOR(2, EnumHelper.EnumPlatform.WOOD_FLOOR),
        WOOD_FRAME(3, EnumHelper.EnumPlatform.WOOD_FRAME),
        WOOD_RISE(4, EnumHelper.EnumPlatform.WOOD_RISE),
        STONE_FLAT(5, EnumHelper.EnumPlatform.STONE_FLAT),
        STONE_RAMP(6, EnumHelper.EnumPlatform.STONE_RAMP),
        STONE_FLOOR(7, EnumHelper.EnumPlatform.STONE_FLOOR),
        STONE_FRAME(8, EnumHelper.EnumPlatform.STONE_FRAME),
        STONE_RISE(9, EnumHelper.EnumPlatform.STONE_RISE),
        METAL_FLAT(10, EnumHelper.EnumPlatform.METAL_FLAT),
        METAL_RAMP(11, EnumHelper.EnumPlatform.METAL_RAMP),
        METAL_FLOOR(12, EnumHelper.EnumPlatform.METAL_FLOOR),
        METAL_FRAME(13, EnumHelper.EnumPlatform.METAL_FRAME),
        METAL_RISE(14, EnumHelper.EnumPlatform.METAL_RISE),
        PLATFORMER(15, EnumHelper.EnumPlatform.PLATFORMER);

        private static final EnumType[] array;
        private final byte value;
        public final EnumHelper.EnumPlatform platform;

        private EnumType(int value, EnumHelper.EnumPlatform platform) {
            this.value = (byte)value;
            this.platform = platform;
        }

        public byte getValue() {
            return this.value;
        }

        public EnumHelper.EnumPlatform getPlatform() {
            return this.platform;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? WOOD_FLAT : type;
        }

        public static EnumType byPlatform(EnumHelper.EnumPlatform platform) {
            for (EnumType value : EnumType.values()) {
                if (value.platform != platform) continue;
                return value;
            }
            return WOOD_FLAT;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] != null) continue;
                EnumType.array[value.getValue()] = value;
            }
        }
    }
}

