/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.client;

import com.valkyrieofnight.valkyrielib.client.SizableBox;
import com.valkyrieofnight.valkyrielib.util.TextureLoc;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TexUtils {
    public static final ResourceLocation BLOCKS_TEX = TextureMap.field_110575_b;

    public static SizableBox generateSlotStyle(ResourceLocation loc, int x, int y) {
        return TexUtils.genSizableBox(loc, x, y, 2, 2);
    }

    public static SizableBox generateSearchBoxStyle(ResourceLocation loc, int x, int y) {
        return TexUtils.genSizableBox(loc, x, y, 2, 2);
    }

    public static SizableBox generateGuiBGStyle(ResourceLocation loc, int x, int y) {
        return TexUtils.genSizableBox(loc, x, y, 4, 4);
    }

    public static SizableBox genSizableBox(ResourceLocation loc, int x, int y, int w, int h) {
        SizableBox ss = new SizableBox(loc, w, h);
        int xs0 = x + w * 0;
        int xs1 = x + w * 1;
        int xs2 = x + w * 2;
        int xe0 = x + w * 1;
        int xe1 = x + w * 2;
        int xe2 = x + w * 3;
        int ys0 = y + h * 0;
        int ys1 = y + h * 1;
        int ys2 = y + h * 2;
        int ye0 = y + h * 1;
        int ye1 = y + h * 2;
        int ye2 = y + h * 3;
        ss.setTextureLoc(SizableBox.BoxLocation.TOP_LEFT, new TextureLoc(loc, xs0, ys0, xe0, ye0));
        ss.setTextureLoc(SizableBox.BoxLocation.TOP_MID, new TextureLoc(loc, xs1, ys0, xe1, ye0));
        ss.setTextureLoc(SizableBox.BoxLocation.TOP_RIGHT, new TextureLoc(loc, xs2, ys0, xe2, ye0));
        ss.setTextureLoc(SizableBox.BoxLocation.MID_LEFT, new TextureLoc(loc, xs0, ys1, xe0, ye1));
        ss.setTextureLoc(SizableBox.BoxLocation.MID, new TextureLoc(loc, xs1, ys1, xe1, ye1));
        ss.setTextureLoc(SizableBox.BoxLocation.MID_RIGHT, new TextureLoc(loc, xs2, ys1, xe2, ye1));
        ss.setTextureLoc(SizableBox.BoxLocation.BOT_LEFT, new TextureLoc(loc, xs0, ys2, xe0, ye2));
        ss.setTextureLoc(SizableBox.BoxLocation.BOT_MID, new TextureLoc(loc, xs1, ys2, xe1, ye2));
        ss.setTextureLoc(SizableBox.BoxLocation.BOT_RIGHT, new TextureLoc(loc, xs2, ys2, xe2, ye2));
        return ss;
    }

    public static void setColor(int mcColor) {
        float f3 = (float)(mcColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(mcColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(mcColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(mcColor & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
    }

    public static TextureLoc getTextureLoc(ResourceLocation loc, int x, int y, int w, int h) {
        return new TextureLoc(loc, x, y, x + w, y + h);
    }

    public static void renderTexLocation(TextureLoc tex, GuiContainer gui, int x, int y) {
        gui.field_146297_k.func_110434_K().func_110577_a(tex.texture);
        gui.func_73729_b(x, y, tex.startX, tex.startY, tex.width, tex.height);
    }

    public static void renderSizableBox(SizableBox sb, GuiContainer gui, int x, int y, int w, int h) {
        gui.field_146297_k.func_110434_K().func_110577_a(sb.getTexture());
        if (sb.getMiddleRepeatable()) {
            TexUtils.renderSizableBoxRepeatableMiddle(sb, gui, x, y, w, h);
        } else {
            TexUtils.renderSizableBoxStretchableMiddle(sb, gui, x, y, w, h);
        }
    }

    private static void renderSizableBoxStretchableMiddle(SizableBox sb, GuiContainer gui, int x, int y, int w, int h) {
        int middleW = w - 2 * sb.getUnitX();
        int middleH = h - 2 * sb.getUnitY();
        int tsy = y;
        int msy = y + sb.getUnitY();
        int bsy = y + (h - 1 * sb.getUnitY());
        int lsx = x;
        int msx = x + sb.getUnitX();
        int rsx = x + (w - 1 * sb.getUnitX());
        TextureLoc topl = sb.getTextureLoc(SizableBox.BoxLocation.TOP_LEFT);
        GuiContainer.func_146110_a((int)lsx, (int)tsy, (float)topl.startX, (float)topl.startY, (int)topl.width, (int)topl.height, (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc topm = sb.getTextureLoc(SizableBox.BoxLocation.TOP_MID);
        GuiContainer.func_152125_a((int)msx, (int)tsy, (float)topm.startX, (float)topm.startY, (int)topm.width, (int)topm.height, (int)middleW, (int)sb.getUnitY(), (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc topr = sb.getTextureLoc(SizableBox.BoxLocation.TOP_RIGHT);
        GuiContainer.func_146110_a((int)rsx, (int)tsy, (float)topr.startX, (float)topr.startY, (int)topr.width, (int)topr.height, (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc midl = sb.getTextureLoc(SizableBox.BoxLocation.MID_LEFT);
        GuiContainer.func_152125_a((int)lsx, (int)msy, (float)midl.startX, (float)midl.startY, (int)midl.width, (int)midl.height, (int)sb.getUnitX(), (int)middleH, (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc midm = sb.getTextureLoc(SizableBox.BoxLocation.MID);
        GuiContainer.func_152125_a((int)msx, (int)msy, (float)midm.startX, (float)midm.startY, (int)midm.width, (int)midm.height, (int)middleW, (int)middleH, (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc midr = sb.getTextureLoc(SizableBox.BoxLocation.MID_RIGHT);
        GuiContainer.func_152125_a((int)rsx, (int)msy, (float)midr.startX, (float)midr.startY, (int)midr.width, (int)midr.height, (int)sb.getUnitX(), (int)middleH, (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc botl = sb.getTextureLoc(SizableBox.BoxLocation.BOT_LEFT);
        GuiContainer.func_146110_a((int)lsx, (int)bsy, (float)botl.startX, (float)botl.startY, (int)botl.width, (int)botl.height, (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc botm = sb.getTextureLoc(SizableBox.BoxLocation.BOT_MID);
        GuiContainer.func_152125_a((int)msx, (int)bsy, (float)botm.startX, (float)botm.startY, (int)botm.width, (int)botm.height, (int)middleW, (int)sb.getUnitY(), (float)sb.getTexW(), (float)sb.getTexH());
        TextureLoc botr = sb.getTextureLoc(SizableBox.BoxLocation.BOT_RIGHT);
        GuiContainer.func_146110_a((int)rsx, (int)bsy, (float)botr.startX, (float)botr.startY, (int)botr.width, (int)botr.height, (float)sb.getTexW(), (float)sb.getTexH());
    }

    private static void renderSizableBoxRepeatableMiddle(SizableBox sb, GuiContainer gui, int x, int y, int w, int h) {
    }

    public static void renderGuiFluid(GuiContainer gui, FluidStack fluid, float scale, int x, int y, int wt, int maxHt) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite sprite = TexUtils.getStillTexture(fluid);
        if (sprite == null) {
            return;
        }
        int rendHeight = (int)Math.max(Math.min((float)maxHt, (float)maxHt * scale), 1.0f);
        int yPos = y + maxHt - rendHeight;
        gui.field_146297_k.func_110434_K().func_110577_a(BLOCKS_TEX);
        int fluidColor = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(fluidColor >> 16 & 0xFF)), (byte)((byte)(fluidColor >> 8 & 0xFF)), (byte)((byte)(fluidColor & 0xFF)));
        GlStateManager.func_179147_l();
        for (int i = 0; i < wt; i += 16) {
            for (int j = 0; j < rendHeight; j += 16) {
                int dwt = Math.min(wt - i, 16);
                int dht = Math.min(rendHeight - j, 16);
                int dx = x + i;
                int dy = yPos + j;
                double minU = sprite.func_94209_e();
                double maxU = sprite.func_94212_f();
                double minV = sprite.func_94206_g();
                double maxV = sprite.func_94210_h();
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)dx, (double)(dy + dht), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)dht / 16.0).func_181675_d();
                tes.func_181662_b((double)(dx + dwt), (double)(dy + dht), 0.0).func_187315_a(minU + (maxU - minU) * (double)dwt / 16.0, minV + (maxV - minV) * (double)dht / 16.0).func_181675_d();
                tes.func_181662_b((double)(dx + dwt), (double)dy, 0.0).func_187315_a(minU + (maxU - minU) * (double)dwt / 16.0, minV).func_181675_d();
                tes.func_181662_b((double)dx, (double)dy, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179084_k();
    }

    public static TextureAtlasSprite getStillTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return null;
        }
        return TexUtils.getStillTexture(fluid.getFluid());
    }

    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        ResourceLocation tex = fluid.getStill();
        if (tex == null) {
            return null;
        }
        return Minecraft.func_71410_x().func_147117_R().getTextureExtry(tex.toString());
    }
}

