/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeresources.jei.JEIConfig;
import jeresources.json.ProfilingAdapter;
import jeresources.profiling.ChunkGetter;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingExecutor;
import jeresources.profiling.ProfilingTimer;
import mezz.jei.api.IJeiHelpers;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class Profiler
implements Runnable {
    private final ConcurrentMap<Integer, ProfiledDimensionData> allDimensionData;
    private final ProfilingTimer timer;
    private final ICommandSender sender;
    private final int chunkCount;
    private final boolean allWorlds;
    private ProfilingExecutor currentExecutor;
    private static Profiler currentProfiler;

    private Profiler(ICommandSender sender, int chunkCount, boolean allWorlds) {
        this.sender = sender;
        this.allDimensionData = new ConcurrentHashMap<Integer, ProfiledDimensionData>();
        this.chunkCount = chunkCount;
        this.timer = new ProfilingTimer(sender, chunkCount);
        this.allWorlds = allWorlds;
    }

    @Override
    public void run() {
        if (!this.allWorlds) {
            WorldServer world = (WorldServer)this.sender.func_130014_f_();
            this.profileWorld(world);
        } else {
            for (WorldServer world : DimensionManager.getWorlds()) {
                this.profileWorld(world);
            }
        }
        this.writeData();
        this.timer.complete();
        IJeiHelpers jeiHelpers = JEIConfig.getJeiHelpers();
        if (jeiHelpers != null) {
            jeiHelpers.reload();
        }
    }

    private void profileWorld(WorldServer worldServer) {
        ProfilingExecutor executor;
        this.currentExecutor = executor = new ProfilingExecutor(this);
        int dimId = worldServer.field_73011_w.func_186058_p().func_186068_a();
        this.allDimensionData.put(dimId, new ProfiledDimensionData());
        DummyWorld dummyWorld = new DummyWorld(worldServer);
        dummyWorld.func_175643_b();
        ChunkGetter chunkGetter = new ChunkGetter(this.chunkCount, dummyWorld, executor);
        worldServer.func_152344_a((Runnable)chunkGetter);
        executor.awaitTermination();
        this.currentExecutor = null;
        dummyWorld.clearChunks();
    }

    public ProfilingTimer getTimer() {
        return this.timer;
    }

    public ConcurrentMap<Integer, ProfiledDimensionData> getAllDimensionData() {
        return this.allDimensionData;
    }

    private void writeData() {
        HashMap<Integer, ProfilingAdapter.DimensionData> allData = new HashMap<Integer, ProfilingAdapter.DimensionData>();
        for (Integer dim : this.allDimensionData.keySet()) {
            ProfiledDimensionData profiledData = (ProfiledDimensionData)this.allDimensionData.get(dim);
            ProfilingAdapter.DimensionData data = new ProfilingAdapter.DimensionData();
            data.dropsMap = profiledData.dropsMap;
            data.silkTouchMap = profiledData.silkTouchMap;
            for (Map.Entry entry : profiledData.distributionMap.entrySet()) {
                Float[] array = new Float[256];
                for (int i = 0; i < 256; ++i) {
                    array[i] = Float.valueOf((float)((Integer[])entry.getValue())[i].intValue() * 1.0f / (float)this.timer.getBlocksPerLayer(dim));
                }
                data.distribution.put((String)entry.getKey(), array);
            }
            allData.put(dim, data);
        }
        ProfilingAdapter.write(allData);
    }

    public static boolean init(ICommandSender sender, int chunks, boolean allWorlds) {
        if (currentProfiler != null && !Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        currentProfiler = new Profiler(sender, chunks, allWorlds);
        new Thread(currentProfiler).start();
        return true;
    }

    public static boolean stop() {
        if (currentProfiler == null || Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        if (Profiler.currentProfiler.currentExecutor != null) {
            Profiler.currentProfiler.currentExecutor.shutdownNow();
        }
        currentProfiler.writeData();
        return true;
    }
}

