/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail;

import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.rail.NetworkController;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.tileentity.TileEntityRailLink;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RailWrapper
extends BlockPos {
    private static Map<EnumSet<EnumFacing>, BlockRailBase.EnumRailDirection> DIRS_TO_RAIL_DIR = new HashMap<EnumSet<EnumFacing>, BlockRailBase.EnumRailDirection>(6);
    public final IRail rail;
    public final World world;
    public final IBlockState state;
    private Map<RailWrapper, EnumFacing> neighbors;
    private List<TileEntityStationMarker> stationMarkers;
    private Map<EnumFacing, TileEntitySignalBase> signals;
    private Set<TileEntityRailLink> railLinks = Collections.emptySet();

    public RailWrapper(World world, BlockPos pos) {
        this(world, pos, world.func_180495_p(pos));
    }

    public RailWrapper(World world, BlockPos pos, IBlockState state) {
        super((Vec3i)pos);
        this.world = world;
        this.state = state;
        this.rail = RailManager.getInstance().getRail(world, pos, state);
    }

    public boolean isRail() {
        return this.rail != null;
    }

    public boolean setRailDir(BlockRailBase.EnumRailDirection railDir) {
        boolean valid = this.rail.getValidDirections(this.world, this, this.state).contains(railDir);
        if (valid) {
            this.rail.setDirection(this.world, this, this.state, railDir);
        }
        return valid;
    }

    public void invalidate() {
        if (this.neighbors != null) {
            for (RailWrapper neighbor : this.neighbors.keySet()) {
                if (neighbor.neighbors == null) continue;
                neighbor.neighbors.remove((Object)this);
            }
        }
        for (TileEntityRailLink railLink : this.railLinks) {
            railLink.onLinkedRailInvalidated();
        }
        NetworkController.getInstance(this.world).updateColor((RailWrapper)null, (BlockPos)this);
    }

    public void link(TileEntityRailLink link) {
        if (this.railLinks == Collections.EMPTY_SET) {
            this.railLinks = new HashSet<TileEntityRailLink>();
        }
        this.railLinks.add(link);
    }

    public void unlink(TileEntityRailLink link) {
        if (this.railLinks != Collections.EMPTY_SET) {
            this.railLinks.remove((Object)link);
        }
    }

    public void updateStationCache() {
        this.stationMarkers = null;
    }

    public Set<String> getStationNames() {
        if (this.stationMarkers == null) {
            for (EnumFacing d : EnumFacing.values()) {
                TileEntity te = this.world.func_175625_s(this.func_177972_a(d));
                if (!(te instanceof TileEntityStationMarker)) continue;
                if (this.stationMarkers == null) {
                    this.stationMarkers = new ArrayList<TileEntityStationMarker>(1);
                }
                this.stationMarkers.add((TileEntityStationMarker)te);
            }
            if (this.stationMarkers == null) {
                this.stationMarkers = Collections.emptyList();
            }
        }
        HashSet<String> stationNames = new HashSet<String>(this.stationMarkers.size());
        for (TileEntityStationMarker marker : this.stationMarkers) {
            stationNames.add(marker.getStationName());
        }
        return stationNames;
    }

    public void updateSignalCache() {
        this.signals = null;
    }

    public Map<EnumFacing, TileEntitySignalBase> getSignals() {
        if (this.signals == null) {
            BlockRailBase.EnumRailDirection railDir = this.rail.getDirection(this.world, this, this.state);
            if (RailWrapper.isStraightTrack(railDir) && this.getNeighbors().size() <= 2) {
                for (EnumFacing d : RailWrapper.getDirections(railDir)) {
                    TileEntitySignalBase signal;
                    TileEntity te = this.world.func_175625_s(this.func_177972_a(d = d.func_176746_e()));
                    if (!(te instanceof TileEntitySignalBase) || !(signal = (TileEntitySignalBase)te).getNeighborPos().equals((Object)this)) continue;
                    if (this.signals == null) {
                        this.signals = new HashMap<EnumFacing, TileEntitySignalBase>(1);
                    }
                    this.signals.put(d, signal);
                }
            }
            if (this.signals == null) {
                this.signals = Collections.emptyMap();
            }
        }
        return this.signals;
    }

    public void updateNeighborCache() {
        this.neighbors = null;
    }

    public Map<RailWrapper, EnumFacing> getNeighbors() {
        if (this.neighbors == null) {
            HashMap<RailWrapper, EnumFacing> neighbors = new HashMap<RailWrapper, EnumFacing>(6);
            EnumSet<EnumFacing> validDirs = EnumSet.noneOf(EnumFacing.class);
            for (BlockRailBase.EnumRailDirection railDir : this.rail.getValidDirections(this.world, this, this.state)) {
                validDirs.addAll(RailWrapper.getDirections(railDir));
            }
            for (EnumFacing d : validDirs) {
                if (!this.world.func_175667_e(this.func_177972_a(d))) continue;
                RailWrapper rail = RailCacheManager.getInstance(this.world).getRail(this.world, this.func_177972_a(d));
                if (rail != null) {
                    neighbors.put(rail, d);
                    continue;
                }
                RailWrapper rail2 = RailCacheManager.getInstance(this.world).getRail(this.world, this.func_177972_a(d).func_177977_b());
                if (rail2 != null) {
                    neighbors.put(rail2, d);
                    continue;
                }
                RailWrapper rail3 = RailCacheManager.getInstance(this.world).getRail(this.world, this.func_177972_a(d).func_177984_a());
                if (rail3 == null) continue;
                neighbors.put(rail3, d);
            }
            for (EnumFacing d : EnumFacing.values()) {
                RailWrapper linkedNeighbor;
                TileEntity te;
                if (!this.world.func_175667_e(this.func_177972_a(d)) || !((te = this.world.func_175625_s(this.func_177972_a(d))) instanceof TileEntityRailLink) || (linkedNeighbor = ((TileEntityRailLink)te).getLinkedRail()) == null) continue;
                neighbors.put(linkedNeighbor, EnumFacing.DOWN);
            }
            this.neighbors = neighbors;
        }
        return this.neighbors;
    }

    private static EnumSet<EnumFacing> getDirections(BlockRailBase.EnumRailDirection railDir) {
        switch (railDir) {
            case NORTH_SOUTH: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return EnumSet.of(EnumFacing.NORTH, EnumFacing.SOUTH);
            }
            case EAST_WEST: 
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return EnumSet.of(EnumFacing.EAST, EnumFacing.WEST);
            }
            case SOUTH_EAST: {
                return EnumSet.of(EnumFacing.SOUTH, EnumFacing.EAST);
            }
            case SOUTH_WEST: {
                return EnumSet.of(EnumFacing.SOUTH, EnumFacing.WEST);
            }
            case NORTH_WEST: {
                return EnumSet.of(EnumFacing.NORTH, EnumFacing.WEST);
            }
            case NORTH_EAST: {
                return EnumSet.of(EnumFacing.NORTH, EnumFacing.EAST);
            }
        }
        return EnumSet.noneOf(EnumFacing.class);
    }

    private static int getHeightOffset(BlockRailBase.EnumRailDirection railDir, EnumFacing dir) {
        switch (railDir) {
            case ASCENDING_EAST: {
                return dir == EnumFacing.EAST ? 1 : 0;
            }
            case ASCENDING_WEST: {
                return dir == EnumFacing.WEST ? 1 : 0;
            }
            case ASCENDING_NORTH: {
                return dir == EnumFacing.NORTH ? 1 : 0;
            }
            case ASCENDING_SOUTH: {
                return dir == EnumFacing.SOUTH ? 1 : 0;
            }
        }
        return 0;
    }

    public boolean isStraightTrack() {
        return RailWrapper.isStraightTrack(this.rail.getDirection(this.world, this, this.state));
    }

    public static BlockRailBase.EnumRailDirection getRailDir(EnumSet<EnumFacing> facings) {
        return DIRS_TO_RAIL_DIR.get(facings);
    }

    private static boolean isStraightTrack(BlockRailBase.EnumRailDirection railDir) {
        switch (railDir) {
            case NORTH_SOUTH: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: 
            case EAST_WEST: 
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return true;
            }
        }
        return false;
    }

    static {
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumFacing.NORTH, EnumFacing.SOUTH), BlockRailBase.EnumRailDirection.NORTH_SOUTH);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumFacing.EAST, EnumFacing.WEST), BlockRailBase.EnumRailDirection.EAST_WEST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumFacing.NORTH, EnumFacing.EAST), BlockRailBase.EnumRailDirection.NORTH_EAST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumFacing.EAST, EnumFacing.SOUTH), BlockRailBase.EnumRailDirection.SOUTH_EAST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumFacing.SOUTH, EnumFacing.WEST), BlockRailBase.EnumRailDirection.SOUTH_WEST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumFacing.WEST, EnumFacing.NORTH), BlockRailBase.EnumRailDirection.NORTH_WEST);
    }
}

