/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.event;

import com.minemaarten.signals.Signals;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler
implements IWorldEventListener {
    @SubscribeEvent
    public void onCapabilityAttachment(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityMinecart) {
            event.addCapability(new ResourceLocation("Signals", "minecartDestinationCapability"), (ICapabilityProvider)new CapabilityMinecartDestination.Provider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCapabilityAttachment(AttachCapabilitiesEvent.TileEntity event) {
        RailManager.getInstance().onTileEntityCapabilityAttachEvent(event);
    }

    @SubscribeEvent
    public void onMinecartInteraction(MinecartInteractEvent event) {
        CapabilityMinecartDestination cap;
        ItemStack heldItem;
        if (!event.getMinecart().field_70170_p.field_72995_K && (heldItem = event.getPlayer().func_184614_ca()) != null && (cap = (CapabilityMinecartDestination)event.getMinecart().getCapability(CapabilityMinecartDestination.INSTANCE, null)) != null) {
            if (heldItem.func_77973_b() == ModItems.cartEngine && !cap.isMotorized()) {
                if (!event.getPlayer().func_184812_l_()) {
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a <= 0) {
                        event.getPlayer().func_184611_a(EnumHand.MAIN_HAND, null);
                    }
                }
                cap.setMotorized();
                event.getPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.cart_engine_installed", new Object[0]));
                event.setCanceled(true);
            } else if (heldItem.func_77973_b() == ModItems.railConfigurator) {
                RailCacheManager.syncStationNames((EntityPlayerMP)event.getPlayer());
                event.getPlayer().openGui((Object)Signals.instance, CommonProxy.EnumGuiId.MINECART_DESTINATION.ordinal(), event.getPlayer().field_70170_p, event.getMinecart().func_145782_y(), -1, cap.isMotorized() ? 1 : 0);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.getMinecart();
        CapabilityMinecartDestination cap = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
        if (cap != null) {
            cap.onCartUpdate(event);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDimensionChange(EntityTravelToDimensionEvent event) {
        CapabilityMinecartDestination cap = (CapabilityMinecartDestination)event.getEntity().getCapability(CapabilityMinecartDestination.INSTANCE, null);
        if (cap != null) {
            cap.travelingBetweenDimensions = !event.isCanceled();
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            RailCacheManager.getInstance(event.getWorld()).onChunkUnload(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            RailCacheManager.getInstance(event.getWorld()).onChunkLoad(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            RailCacheManager.getInstance(event.getWorld()).onWorldUnload(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onNeighborChange(BlockEvent.NeighborNotifyEvent event) {
        if (!event.getWorld().field_72995_K) {
            RailCacheManager.getInstance(event.getWorld()).onNeighborChanged(event);
        }
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
    }

    public void func_184375_a(EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
        CapabilityMinecartDestination cap;
        if (entityIn instanceof EntityMinecart && !entityIn.field_70170_p.field_72995_K && (cap = (CapabilityMinecartDestination)entityIn.getCapability(CapabilityMinecartDestination.INSTANCE, null)) != null) {
            cap.onCartBroken((EntityMinecart)entityIn);
        }
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

