/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.capabilities.destinationproviders;

import com.minemaarten.signals.Signals;
import com.minemaarten.signals.api.SignalsRail;
import com.minemaarten.signals.api.tileentity.IDestinationProvider;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.tileentity.IGUIButtonSensitive;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

@SignalsRail
public class DestinationProviderItems
implements IDestinationProvider,
IGUIButtonSensitive {
    @CapabilityInject(value=IItemHandler.class)
    private static Capability<IItemHandler> ITEM_HANDLER;
    @GuiSynced
    public boolean blacklist;
    @GuiSynced
    public boolean checkDamage = true;
    @GuiSynced
    public boolean checkNBT;
    @GuiSynced
    public boolean checkModSimilarity;
    @GuiSynced
    public boolean checkOreDictionary;

    @Override
    public boolean isTileEntityApplicable(TileEntity te) {
        return te instanceof IInventory;
    }

    @Override
    public boolean isCartApplicable(TileEntity te, EntityMinecart cart, Pattern destinationRegex) {
        IItemHandler cap = (IItemHandler)cart.getCapability(ITEM_HANDLER, null);
        if (cap != null && destinationRegex.matcher("ITEM").matches()) {
            IInventory inv = (IInventory)te;
            for (int cartSlot = 0; cartSlot < cap.getSlots(); ++cartSlot) {
                ItemStack cartStack = cap.getStackInSlot(cartSlot);
                if (cartStack == null || !this.isStackApplicable(cartStack, inv)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isStackApplicable(ItemStack cartStack, IInventory inv) {
        for (int teSlot = 0; teSlot < inv.func_70302_i_(); ++teSlot) {
            ItemStack teStack = inv.func_70301_a(teSlot);
            if (teStack == null || this.blacklist == DestinationProviderItems.areStacksEqual(cartStack, teStack, this.checkDamage, this.checkNBT, this.checkOreDictionary, this.checkModSimilarity)) continue;
            return true;
        }
        return false;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean checkMeta, boolean checkNBT, boolean checkOreDict, boolean checkModSimilarity) {
        boolean metaSame;
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null && stack2 != null || stack1 != null && stack2 == null) {
            return false;
        }
        if (checkModSimilarity) {
            ResourceLocation id1 = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack1.func_77973_b());
            ResourceLocation id2 = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack2.func_77973_b());
            return id1 != null && id2 != null && id1.func_110624_b().equals(id2.func_110624_b());
        }
        if (checkOreDict) {
            return DestinationProviderItems.isSameOreDictStack(stack1, stack2);
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        boolean bl = metaSame = stack1.func_77952_i() == stack2.func_77952_i();
        boolean nbtSame = stack1.func_77942_o() ? stack1.func_77978_p().equals((Object)stack2.func_77978_p()) : !stack2.func_77942_o();
        return !(checkMeta && !metaSame || checkNBT && !nbtSame);
    }

    public static boolean isSameOreDictStack(ItemStack stack1, ItemStack stack2) {
        int[] oredictIds;
        for (int oredictId : oredictIds = OreDictionary.getOreIDs((ItemStack)stack1)) {
            List oreDictStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)oredictId));
            for (ItemStack oreDictStack : oreDictStacks) {
                if (!OreDictionary.itemMatches((ItemStack)oreDictStack, (ItemStack)stack2, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasGui(TileEntity te) {
        return true;
    }

    @Override
    public void openGui(TileEntity te, EntityPlayer player) {
        player.openGui((Object)Signals.instance, CommonProxy.EnumGuiId.ITEM_HANDLER_DESTINATION.ordinal(), player.field_70170_p, te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
    }

    @Override
    public void handleGUIButtonPress(EntityPlayer player, int ... data) {
        switch (data[0]) {
            case 0: {
                this.checkDamage = !this.checkDamage;
                break;
            }
            case 1: {
                this.checkNBT = !this.checkNBT;
                break;
            }
            case 2: {
                this.checkModSimilarity = !this.checkModSimilarity;
                break;
            }
            case 3: {
                this.checkOreDictionary = !this.checkOreDictionary;
                break;
            }
            case 4: {
                this.blacklist = !this.blacklist;
            }
        }
    }

    @Override
    public String getLocalizedName() {
        return I18n.func_135052_a((String)"signals.gui.destination_provider.items", (Object[])new Object[0]);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        byte packedData = (byte)((this.blacklist ? 16 : 0) + (this.checkDamage ? 0 : 8) + (this.checkNBT ? 4 : 0) + (this.checkModSimilarity ? 2 : 0) + (this.checkOreDictionary ? 1 : 0));
        if (packedData > 0) {
            tag.func_74774_a("filterParams", packedData);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        byte packetData = tag.func_74771_c("filterParams");
        this.blacklist = (packetData & 0x10) > 0;
        this.checkDamage = (packetData & 8) == 0;
        this.checkNBT = (packetData & 4) > 0;
        this.checkModSimilarity = (packetData & 2) > 0;
        this.checkOreDictionary = (packetData & 1) > 0;
    }
}

