/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.block;

import com.google.common.base.Predicate;
import com.minemaarten.signals.block.BlockBase;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockSignalBase
extends BlockBase {
    public static PropertyEnum<EnumLampStatus> LAMP_STATUS = PropertyEnum.func_177709_a((String)"lamp_status", EnumLampStatus.class);
    public static PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSignalBase(Class<? extends TileEntitySignalBase> tileClass, String name) {
        super(tileClass, name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LAMP_STATUS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176736_b() * 4 + ((EnumLampStatus)((Object)state.func_177229_b(LAMP_STATUS))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta);
        return state.func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)(meta / 4))).func_177226_a(LAMP_STATUS, (Comparable)((Object)EnumLampStatus.values()[meta % 4]));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO());
    }

    public int func_180656_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        if (!(worldIn instanceof WorldServer) || state.func_177230_c() != this || state.func_177229_b(LAMP_STATUS) != EnumLampStatus.GREEN) {
            return 0;
        }
        TileEntitySignalBase signal = (TileEntitySignalBase)worldIn.func_175625_s(pos);
        signal.func_145834_a((World)((WorldServer)worldIn));
        for (RailWrapper rail : signal.getConnectedRails()) {
            for (TileEntitySignalBase s : rail.getSignals().values()) {
                if (s == signal || s.getLampStatus() == EnumLampStatus.GREEN) continue;
                return 0;
            }
        }
        return 15;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static enum EnumLampStatus implements IStringSerializable
    {
        GREEN(-16711936),
        RED(-65536),
        YELLOW(-256),
        YELLOW_BLINKING(-6711040);

        public int color;

        private EnumLampStatus(int color) {
            this.color = color;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

