/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.config.ConfigHandler;
import com.pam.harvestcraft.tileentities.ShippingBinData;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ShippingBinItems {
    private static final ArrayList<ShippingBinData> items = new ArrayList();

    private static void registerItems(ShippingBinData data) {
        items.add(data);
    }

    public static ShippingBinData getData(int i) {
        return items.get(i);
    }

    public static int getSize() {
        return items.size();
    }

    public static void registerItems() {
        if (HarvestCraft.config.shippingbinbuyCrops) {
            ShippingBinItems.registerCrops();
        }
    }

    private static void registerCrops() {
        ItemStack currency = ShippingBinItems.getCurrency(HarvestCraft.config.marketcurrencySeeds, CurrencyType.SEEDS);
        for (Item item : CropRegistry.getFoods().values()) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(item), HarvestCraft.config.shippingbincropPrice));
        }
        if (ConfigHandler.shippingbinenablevanillaMCCrops) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151015_O), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Blocks.field_150423_aK), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151127_ba), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_185164_cV), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151172_bF), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151174_bG), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151100_aR, 1, 3), HarvestCraft.config.shippingbincropPrice));
        }
    }

    private static ItemStack getCurrency(int config, CurrencyType currencyType) {
        switch (config) {
            case 1: {
                return new ItemStack(Items.field_151045_i);
            }
            case 2: {
                return new ItemStack(Items.field_151043_k);
            }
            case 3: {
                return new ItemStack(Items.field_151074_bl);
            }
            case 4: {
                return new ItemStack(Items.field_151042_j);
            }
            case 5: {
                if (currencyType.equals((Object)CurrencyType.ANIMAL)) {
                    return new ItemStack(Items.field_151110_aK);
                }
                if (currencyType.equals((Object)CurrencyType.SEEDS)) {
                    return new ItemStack(Items.field_151014_N);
                }
                if (currencyType.equals((Object)CurrencyType.SAPLING)) {
                    return new ItemStack(Blocks.field_150345_g);
                }
                return null;
            }
            case 6: {
                return new ItemStack(Items.field_151034_e);
            }
            case 7: {
                return new ItemStack(Items.field_151100_aR);
            }
        }
        return new ItemStack(Items.field_151166_bC);
    }

    private static enum CurrencyType {
        DEFAULT,
        SEEDS,
        SAPLING,
        ANIMAL;

    }
}

