/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.items.craftingcard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.tools.ItemStackList;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.items.GenericRFToolsItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingCardItem
extends GenericRFToolsItem {
    public CraftingCardItem() {
        super("crafting_card");
    }

    public static void testRecipe(World world, ItemStack craftingCard) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idx = y * 3 + x;
                int idxCard = y * 5 + x;
                workInventory.func_70299_a(idx, (ItemStack)stacks.get(idxCard));
            }
        }
        ItemStack stack = CraftingManager.func_77594_a().func_82787_a(workInventory, world);
        stacks.set(20, (Object)stack);
        CraftingCardItem.putStacksInItem(craftingCard, stacks);
    }

    public static ItemStackList getStacksFromItem(ItemStack craftingCard) {
        NBTTagCompound tagCompound = craftingCard.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            craftingCard.func_77982_d(tagCompound);
        }
        ItemStackList stacks = ItemStackList.create((int)21);
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            stacks.set(i, (Object)ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound));
        }
        return stacks;
    }

    public static void putStacksInItem(ItemStack craftingCard, ItemStackList stacks) {
        NBTTagCompound tagCompound = craftingCard.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            craftingCard.func_77982_d(tagCompound);
        }
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (ItemStackTools.isValid((ItemStack)stack)) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> list, boolean advanced) {
        super.func_77624_a(stack, playerIn, list, advanced);
        list.add("This item can be used for auto");
        list.add("crafting. It stores ingredients");
        list.add("and end result for a recipe");
        ItemStack result = CraftingCardItem.getResult(stack);
        if (ItemStackTools.isValid((ItemStack)result)) {
            if (ItemStackTools.getStackSize((ItemStack)result) > 1) {
                list.add(TextFormatting.BLUE + "Item: " + TextFormatting.WHITE + result.func_82833_r() + "(" + ItemStackTools.getStackSize((ItemStack)result) + ")");
            } else {
                list.add(TextFormatting.BLUE + "Item: " + TextFormatting.WHITE + result.func_82833_r());
            }
        }
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            player.openGui((Object)RFToolsControl.instance, RFToolsControl.GUI_CRAFTINGCARD, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static ItemStack getResult(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return ItemStackTools.getEmptyStack();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(20);
        return ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound);
    }

    private static boolean isInGrid(int index) {
        int x = index % 5;
        int y = index / 5;
        return x <= 2 && y <= 2;
    }

    public static boolean fitsGrid(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound;
            ItemStack s;
            if (i >= 20 || !ItemStackTools.isValid((ItemStack)(s = ItemStackTools.loadFromNBT((NBTTagCompound)(nbtTagCompound = bufferTagList.func_150305_b(i))))) || CraftingCardItem.isInGrid(i)) continue;
            return false;
        }
        return true;
    }

    public static List<ItemStack> getIngredientsGrid(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            if (i >= 20) continue;
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            ItemStack s = ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound);
            if (!CraftingCardItem.isInGrid(i)) continue;
            stacks.add(s);
        }
        return stacks;
    }

    public static List<ItemStack> getIngredients(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound;
            ItemStack s;
            if (i >= 20 || !ItemStackTools.isValid((ItemStack)(s = ItemStackTools.loadFromNBT((NBTTagCompound)(nbtTagCompound = bufferTagList.func_150305_b(i)))))) continue;
            stacks.add(s);
        }
        return stacks;
    }
}

